/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.core.impl.ExtendedClassInfo;
import org.apache.logging.log4j.core.impl.ExtendedStackTraceElement;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;

class ThrowableProxyHelper {
    private ThrowableProxyHelper() {
    }

    static ExtendedStackTraceElement[] toExtendedStackTrace(ThrowableProxy src, Deque<Class<?>> stack, Map<String, CacheEntry> map, StackTraceElement[] rootTrace, StackTraceElement[] stackTrace) {
        int stackLength2;
        if (rootTrace != null) {
            int stackIndex;
            int rootIndex = rootTrace.length - 1;
            for (stackIndex = stackTrace.length - 1; rootIndex >= 0 && stackIndex >= 0 && rootTrace[rootIndex].equals(stackTrace[stackIndex]); --rootIndex, --stackIndex) {
            }
            src.setCommonElementCount(stackTrace.length - 1 - stackIndex);
            stackLength2 = stackIndex + 1;
        } else {
            ThrowableProxy stackLength;
            stackLength.setCommonElementCount(0);
            stackLength2 = stackTrace.length;
        }
        ExtendedStackTraceElement[] extStackTrace = new ExtendedStackTraceElement[stackLength2];
        Class<?> clazz = stack.isEmpty() ? null : stack.peekLast();
        ClassLoader lastLoader = null;
        for (int i = stackLength2 - 1; i >= 0; --i) {
            ExtendedClassInfo extClassInfo;
            CacheEntry entry;
            StackTraceElement stackTraceElement = stackTrace[i];
            String className = stackTraceElement.getClassName();
            if (clazz != null && className.equals(clazz.getName())) {
                entry = ThrowableProxyHelper.toCacheEntry(clazz, true);
                extClassInfo = entry.element;
                lastLoader = entry.loader;
                stack.pollLast();
                clazz = stack.peekLast();
            } else {
                CacheEntry cacheEntry = map.get(className);
                if (cacheEntry != null) {
                    entry = cacheEntry;
                    extClassInfo = entry.element;
                    if (entry.loader != null) {
                        lastLoader = entry.loader;
                    }
                } else {
                    entry = ThrowableProxyHelper.toCacheEntry(ThrowableProxyHelper.loadClass(lastLoader, className), false);
                    extClassInfo = entry.element;
                    map.put(className, entry);
                    if (entry.loader != null) {
                        lastLoader = entry.loader;
                    }
                }
            }
            extStackTrace[i] = new ExtendedStackTraceElement(stackTraceElement, extClassInfo);
        }
        return extStackTrace;
    }

    /*
     * WARNING - void declaration
     */
    static ThrowableProxy[] toSuppressedProxies(Throwable thrown, Set<Throwable> suppressedVisited) {
        try {
            void var2_3;
            Throwable[] suppressed = thrown.getSuppressed();
            if (suppressed == null || suppressed.length == 0) {
                return ThrowableProxy.EMPTY_ARRAY;
            }
            ArrayList<ThrowableProxy> proxies = new ArrayList<ThrowableProxy>(suppressed.length);
            if (suppressedVisited == null) {
                suppressedVisited = new HashSet<Throwable>(suppressed.length);
            }
            for (int i = 0; i < suppressed.length; ++i) {
                Throwable candidate = suppressed[i];
                if (!suppressedVisited.add(candidate)) continue;
                proxies.add(new ThrowableProxy(candidate, suppressedVisited));
            }
            return var2_3.toArray(ThrowableProxy.EMPTY_ARRAY);
        }
        catch (Exception e) {
            void var0_1;
            StatusLogger.getLogger().error((Object)var0_1);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static CacheEntry toCacheEntry(Class<?> callerClass, boolean exact) {
        void var3_3;
        void var2_2;
        void var1_1;
        ClassLoader classLoader;
        String location = "?";
        String version = "?";
        Object lastLoader = null;
        if (callerClass != null) {
            String ver;
            try {
                URL locationURL;
                CodeSource source = callerClass.getProtectionDomain().getCodeSource();
                if (source != null && (locationURL = source.getLocation()) != null) {
                    String str = locationURL.toString().replace('\\', '/');
                    int index = str.lastIndexOf("/");
                    if (index >= 0 && index == str.length() - 1) {
                        index = str.lastIndexOf("/", index - 1);
                    }
                    location = str.substring(index + 1);
                }
            }
            catch (Exception exception) {}
            Package pkg = callerClass.getPackage();
            if (pkg != null && (ver = pkg.getImplementationVersion()) != null) {
                version = ver;
            }
            try {
                Class<?> clazz;
                classLoader = clazz.getClassLoader();
            }
            catch (SecurityException securityException) {
                classLoader = null;
            }
        }
        return new CacheEntry(new ExtendedClassInfo((boolean)var1_1, (String)var2_2, (String)var3_3), classLoader);
    }

    /*
     * WARNING - void declaration
     */
    private static Class<?> loadClass(ClassLoader lastLoader, String className) {
        Class<?> clazz;
        Class<?> clazz2;
        if (lastLoader != null) {
            try {
                clazz2 = lastLoader.loadClass(className);
                if (clazz2 != null) {
                    return clazz2;
                }
            }
            catch (Throwable throwable) {}
        }
        try {
            clazz2 = LoaderUtil.loadClass((String)className);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            void var1_1;
            return ThrowableProxyHelper.loadClass((String)var1_1);
        }
        catch (SecurityException securityException) {
            return null;
        }
        return clazz;
    }

    private static Class<?> loadClass(String className) {
        try {
            return Loader.loadClass(className, ThrowableProxyHelper.class.getClassLoader());
        }
        catch (ClassNotFoundException | NoClassDefFoundError | SecurityException throwable) {
            return null;
        }
    }

    static final class CacheEntry {
        private final ExtendedClassInfo element;
        private final ClassLoader loader;

        /*
         * WARNING - void declaration
         */
        private CacheEntry(ExtendedClassInfo element, ClassLoader loader) {
            void var2_2;
            void var1_1;
            this.element = var1_1;
            this.loader = var2_2;
        }
    }
}

