/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.core.impl.ExtendedStackTraceElement;
import org.apache.logging.log4j.core.impl.ThrowableProxyHelper;
import org.apache.logging.log4j.core.impl.ThrowableProxyRenderer;
import org.apache.logging.log4j.core.pattern.PlainTextRenderer;
import org.apache.logging.log4j.core.pattern.TextRenderer;
import org.apache.logging.log4j.util.StackLocatorUtil;

public class ThrowableProxy
implements Serializable {
    private static final char EOL = '\n';
    private static final String EOL_STR = "\n";
    private static final long serialVersionUID = -2752771578252251910L;
    private final ThrowableProxy causeProxy;
    private int commonElementCount;
    private final ExtendedStackTraceElement[] extendedStackTrace;
    private final String localizedMessage;
    private final String message;
    private final String name;
    private final ThrowableProxy[] suppressedProxies;
    private final transient Throwable throwable;
    static final ThrowableProxy[] EMPTY_ARRAY = new ThrowableProxy[0];

    ThrowableProxy() {
        this.throwable = null;
        this.name = null;
        this.extendedStackTrace = ExtendedStackTraceElement.EMPTY_ARRAY;
        this.causeProxy = null;
        this.message = null;
        this.localizedMessage = null;
        this.suppressedProxies = EMPTY_ARRAY;
    }

    /*
     * WARNING - void declaration
     */
    public ThrowableProxy(Throwable throwable) {
        this((Throwable)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    ThrowableProxy(Throwable throwable, Set<Throwable> visited) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.throwable = throwable;
        this.name = throwable.getClass().getName();
        this.message = throwable.getMessage();
        this.localizedMessage = throwable.getLocalizedMessage();
        HashMap<String, ThrowableProxyHelper.CacheEntry> map = new HashMap<String, ThrowableProxyHelper.CacheEntry>();
        Deque stack = StackLocatorUtil.getCurrentStackTrace();
        this.extendedStackTrace = ThrowableProxyHelper.toExtendedStackTrace(this, stack, map, null, throwable.getStackTrace());
        Throwable throwableCause = throwable.getCause();
        HashSet<Throwable> causeVisited = new HashSet<Throwable>(1);
        this.causeProxy = throwableCause == null ? null : new ThrowableProxy(throwable, stack, (Map<String, ThrowableProxyHelper.CacheEntry>)var3_3, throwableCause, visited, causeVisited);
        this.suppressedProxies = ThrowableProxyHelper.toSuppressedProxies((Throwable)var1_1, (Set<Throwable>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private ThrowableProxy(Throwable parent, Deque<Class<?>> stack, Map<String, ThrowableProxyHelper.CacheEntry> map, Throwable cause, Set<Throwable> suppressedVisited, Set<Throwable> causeVisited) {
        void var3_3;
        void var2_2;
        void var1_1;
        causeVisited.add(cause);
        this.throwable = cause;
        this.name = cause.getClass().getName();
        this.message = this.throwable.getMessage();
        this.localizedMessage = this.throwable.getLocalizedMessage();
        this.extendedStackTrace = ThrowableProxyHelper.toExtendedStackTrace(this, stack, map, parent.getStackTrace(), cause.getStackTrace());
        Throwable causeCause = cause.getCause();
        this.causeProxy = causeCause == null || causeVisited.contains(causeCause) ? null : new ThrowableProxy((Throwable)var1_1, (Deque<Class<?>>)var2_2, (Map<String, ThrowableProxyHelper.CacheEntry>)var3_3, causeCause, suppressedVisited, causeVisited);
        this.suppressedProxies = ThrowableProxyHelper.toSuppressedProxies(cause, suppressedVisited);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThrowableProxy other = (ThrowableProxy)obj;
        if (!Objects.equals(this.causeProxy, other.causeProxy)) {
            return false;
        }
        if (this.commonElementCount != other.commonElementCount) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Arrays.equals(this.extendedStackTrace, other.extendedStackTrace)) {
            return false;
        }
        return Arrays.equals(this.suppressedProxies, var1_1.suppressedProxies);
    }

    /*
     * WARNING - void declaration
     */
    public void formatWrapper(StringBuilder sb, ThrowableProxy cause, String suffix) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.formatWrapper((StringBuilder)var1_1, (ThrowableProxy)var2_2, null, PlainTextRenderer.getInstance(), (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void formatWrapper(StringBuilder sb, ThrowableProxy cause, List<String> ignorePackages, String suffix) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.formatWrapper((StringBuilder)var1_1, (ThrowableProxy)var2_2, (List<String>)var3_3, PlainTextRenderer.getInstance(), suffix);
    }

    /*
     * WARNING - void declaration
     */
    public void formatWrapper(StringBuilder sb, ThrowableProxy cause, List<String> ignorePackages, TextRenderer textRenderer, String suffix) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.formatWrapper((StringBuilder)var1_1, (ThrowableProxy)var2_2, (List<String>)var3_3, textRenderer, suffix, EOL_STR);
    }

    /*
     * WARNING - void declaration
     */
    public void formatWrapper(StringBuilder sb, ThrowableProxy cause, List<String> ignorePackages, TextRenderer textRenderer, String suffix, String lineSeparator) {
        void var3_3;
        void var2_2;
        ThrowableProxyRenderer.formatWrapper(sb, (ThrowableProxy)var2_2, (List<String>)var3_3, textRenderer, suffix, lineSeparator);
    }

    public ThrowableProxy getCauseProxy() {
        return this.causeProxy;
    }

    /*
     * WARNING - void declaration
     */
    public String getCauseStackTraceAsString(String suffix) {
        void var1_1;
        return this.getCauseStackTraceAsString(null, PlainTextRenderer.getInstance(), (String)var1_1, EOL_STR);
    }

    /*
     * WARNING - void declaration
     */
    public String getCauseStackTraceAsString(List<String> packages, String suffix) {
        void var2_2;
        void var1_1;
        return this.getCauseStackTraceAsString((List<String>)var1_1, PlainTextRenderer.getInstance(), (String)var2_2, EOL_STR);
    }

    /*
     * WARNING - void declaration
     */
    public String getCauseStackTraceAsString(List<String> ignorePackages, TextRenderer textRenderer, String suffix) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getCauseStackTraceAsString((List<String>)var1_1, (TextRenderer)var2_2, (String)var3_3, EOL_STR);
    }

    /*
     * WARNING - void declaration
     */
    public String getCauseStackTraceAsString(List<String> ignorePackages, TextRenderer textRenderer, String suffix, String lineSeparator) {
        void var3_3;
        void var2_2;
        void var1_1;
        StringBuilder sb = new StringBuilder();
        ThrowableProxyRenderer.formatCauseStackTrace(this, sb, (List<String>)var1_1, (TextRenderer)var2_2, (String)var3_3, lineSeparator);
        return sb.toString();
    }

    public int getCommonElementCount() {
        return this.commonElementCount;
    }

    /*
     * WARNING - void declaration
     */
    void setCommonElementCount(int value) {
        void var1_1;
        this.commonElementCount = var1_1;
    }

    public ExtendedStackTraceElement[] getExtendedStackTrace() {
        return this.extendedStackTrace;
    }

    public String getExtendedStackTraceAsString() {
        return this.getExtendedStackTraceAsString(null, PlainTextRenderer.getInstance(), "", EOL_STR);
    }

    /*
     * WARNING - void declaration
     */
    public String getExtendedStackTraceAsString(String suffix) {
        void var1_1;
        return this.getExtendedStackTraceAsString(null, PlainTextRenderer.getInstance(), (String)var1_1, EOL_STR);
    }

    /*
     * WARNING - void declaration
     */
    public String getExtendedStackTraceAsString(List<String> ignorePackages, String suffix) {
        void var2_2;
        void var1_1;
        return this.getExtendedStackTraceAsString((List<String>)var1_1, PlainTextRenderer.getInstance(), (String)var2_2, EOL_STR);
    }

    /*
     * WARNING - void declaration
     */
    public String getExtendedStackTraceAsString(List<String> ignorePackages, TextRenderer textRenderer, String suffix) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getExtendedStackTraceAsString((List<String>)var1_1, (TextRenderer)var2_2, (String)var3_3, EOL_STR);
    }

    /*
     * WARNING - void declaration
     */
    public String getExtendedStackTraceAsString(List<String> ignorePackages, TextRenderer textRenderer, String suffix, String lineSeparator) {
        void var3_3;
        void var2_2;
        void var1_1;
        StringBuilder sb = new StringBuilder(1024);
        this.formatExtendedStackTraceTo(sb, (List<String>)var1_1, (TextRenderer)var2_2, (String)var3_3, lineSeparator);
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void formatExtendedStackTraceTo(StringBuilder sb, List<String> ignorePackages, TextRenderer textRenderer, String suffix, String lineSeparator) {
        void var3_3;
        void var2_2;
        void var1_1;
        ThrowableProxyRenderer.formatExtendedStackTraceTo(this, (StringBuilder)var1_1, (List<String>)var2_2, (TextRenderer)var3_3, suffix, lineSeparator);
    }

    public String getLocalizedMessage() {
        return this.localizedMessage;
    }

    public String getMessage() {
        return this.message;
    }

    public String getName() {
        return this.name;
    }

    public StackTraceElement[] getStackTrace() {
        if (this.throwable == null) {
            return null;
        }
        return this.throwable.getStackTrace();
    }

    public ThrowableProxy[] getSuppressedProxies() {
        return this.suppressedProxies;
    }

    /*
     * WARNING - void declaration
     */
    public String getSuppressedStackTrace(String suffix) {
        void var3_3;
        void var2_2;
        ThrowableProxy[] suppressed = this.getSuppressedProxies();
        if (suppressed == null || suppressed.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder("Suppressed Stack Trace Elements:\n");
        for (void proxy : var2_2) {
            sb.append(proxy.getExtendedStackTraceAsString(suffix));
        }
        return var3_3.toString();
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = 31 + (this.causeProxy == null ? 0 : this.causeProxy.hashCode());
        result = result * 31 + this.commonElementCount;
        result = result * 31 + (this.extendedStackTrace == null ? 0 : Arrays.hashCode(this.extendedStackTrace));
        result = result * 31 + (this.suppressedProxies == null ? 0 : Arrays.hashCode(this.suppressedProxies));
        var1_1 = var1_1 * 31 + (this.name == null ? 0 : this.name.hashCode());
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        String msg = this.message;
        if (msg != null) {
            void var1_1;
            return this.name + ": " + (String)var1_1;
        }
        return this.name;
    }
}

