/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.logging.log4j.core.pattern.JAnsiTextRenderer;
import org.apache.logging.log4j.core.pattern.PlainTextRenderer;
import org.apache.logging.log4j.core.pattern.TextRenderer;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.Patterns;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

public final class ThrowableFormatOptions {
    private static final int DEFAULT_LINES = Integer.MAX_VALUE;
    protected static final ThrowableFormatOptions DEFAULT = new ThrowableFormatOptions();
    private static final String FULL = "full";
    private static final String NONE = "none";
    private static final String SHORT = "short";
    private final TextRenderer textRenderer;
    private final int lines;
    private final String separator;
    private final String suffix;
    private final List<String> ignorePackages;
    public static final String CLASS_NAME = "short.className";
    public static final String METHOD_NAME = "short.methodName";
    public static final String LINE_NUMBER = "short.lineNumber";
    public static final String FILE_NAME = "short.fileName";
    public static final String MESSAGE = "short.message";
    public static final String LOCALIZED_MESSAGE = "short.localizedMessage";

    /*
     * WARNING - void declaration
     */
    protected ThrowableFormatOptions(int lines, String separator, List<String> ignorePackages, TextRenderer textRenderer, String suffix) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.lines = var1_1;
        this.separator = separator == null ? Strings.LINE_SEPARATOR : var2_2;
        this.ignorePackages = var3_3;
        this.textRenderer = textRenderer == null ? PlainTextRenderer.getInstance() : textRenderer;
        this.suffix = suffix;
    }

    /*
     * WARNING - void declaration
     */
    protected ThrowableFormatOptions(List<String> packages) {
        this(Integer.MAX_VALUE, null, (List<String>)var1_1, null, null);
        void var1_1;
    }

    protected ThrowableFormatOptions() {
        this(Integer.MAX_VALUE, null, null, null, null);
    }

    public final int getLines() {
        return this.lines;
    }

    public final String getSeparator() {
        return this.separator;
    }

    public final TextRenderer getTextRenderer() {
        return this.textRenderer;
    }

    public final List<String> getIgnorePackages() {
        return this.ignorePackages;
    }

    public final boolean allLines() {
        return this.lines == Integer.MAX_VALUE;
    }

    public final boolean anyLines() {
        return this.lines > 0;
    }

    /*
     * WARNING - void declaration
     */
    public final int minLines(int maxLines) {
        if (this.lines > maxLines) {
            void var1_1;
            return (int)var1_1;
        }
        return this.lines;
    }

    public final boolean hasPackages() {
        return this.ignorePackages != null && !this.ignorePackages.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder s = new StringBuilder();
        s.append('{').append(this.allLines() ? FULL : (this.lines == 2 ? SHORT : (this.anyLines() ? String.valueOf(this.lines) : NONE))).append('}');
        s.append("{separator(").append(this.separator).append(")}");
        if (this.hasPackages()) {
            s.append("{filters(");
            for (String p : this.ignorePackages) {
                void var3_3;
                s.append((String)var3_3).append(',');
            }
            StringBuilder stringBuilder = s;
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            s.append(")}");
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static ThrowableFormatOptions newInstance(String[] options2) {
        void var3_5;
        void var2_4;
        void var1_3;
        String[] stringArray;
        if (options2 == null || options2.length == 0) {
            return DEFAULT;
        }
        if (options2.length == 1 && Strings.isNotEmpty((CharSequence)options2[0])) {
            String[] opts = options2[0].split(Patterns.COMMA_SEPARATOR, 2);
            String first = opts[0].trim();
            Scanner scanner = new Scanner(first);
            Throwable throwable = null;
            try {
                if (opts.length > 1 && (first.equalsIgnoreCase(FULL) || first.equalsIgnoreCase(SHORT) || first.equalsIgnoreCase(NONE) || scanner.hasNextInt())) {
                    options2 = new String[]{first, opts[1].trim()};
                }
                scanner.close();
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable options2) {
                    if (throwable != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        scanner.close();
                    }
                    throw options2;
                }
            }
        }
        int lines = ThrowableFormatOptions.DEFAULT.lines;
        String separator = ThrowableFormatOptions.DEFAULT.separator;
        List<String> packages = ThrowableFormatOptions.DEFAULT.ignorePackages;
        TextRenderer ansiRenderer = ThrowableFormatOptions.DEFAULT.textRenderer;
        String suffix = DEFAULT.getSuffix();
        for (String rawOption : stringArray) {
            void var8_12;
            String[] array;
            String option;
            if (rawOption == null || (option = rawOption.trim()).isEmpty()) continue;
            if (option.startsWith("separator(") && option.endsWith(")")) {
                separator = option.substring(10, option.length() - 1);
                continue;
            }
            if (option.startsWith("filters(") && option.endsWith(")")) {
                String filterStr = option.substring(8, option.length() - 1);
                if (filterStr.length() <= 0 || (array = filterStr.split(Patterns.COMMA_SEPARATOR)).length <= 0) continue;
                packages = new ArrayList<String>(array.length);
                int n = array.length;
                for (int i = 0; i < n; ++i) {
                    String string = array[i];
                    String token = string.trim();
                    if (token.length() <= 0) continue;
                    packages.add(token);
                }
                continue;
            }
            if (array.equalsIgnoreCase(NONE)) {
                lines = 0;
                continue;
            }
            if (array.equalsIgnoreCase(SHORT) || array.equalsIgnoreCase(CLASS_NAME) || array.equalsIgnoreCase(METHOD_NAME) || array.equalsIgnoreCase(LINE_NUMBER) || array.equalsIgnoreCase(FILE_NAME) || array.equalsIgnoreCase(MESSAGE) || array.equalsIgnoreCase(LOCALIZED_MESSAGE)) {
                lines = 2;
                continue;
            }
            if (array.startsWith("ansi(") && array.endsWith(")") || array.equals("ansi")) {
                if (Loader.isJansiAvailable()) {
                    String styleMapStr = array.equals("ansi") ? "" : array.substring(5, array.length() - 1);
                    ansiRenderer = new JAnsiTextRenderer(new String[]{null, styleMapStr}, JAnsiTextRenderer.DefaultExceptionStyleMap);
                    continue;
                }
                StatusLogger.getLogger().warn("You requested ANSI exception rendering but JANSI is not on the classpath. Please see https://logging.apache.org/log4j/2.x/runtime-dependencies.html");
                continue;
            }
            if (var8_12.startsWith("S(") && var8_12.endsWith(")")) {
                suffix = var8_12.substring(2, var8_12.length() - 1);
                continue;
            }
            if (var8_12.startsWith("suffix(") && var8_12.endsWith(")")) {
                suffix = var8_12.substring(7, var8_12.length() - 1);
                continue;
            }
            if (var8_12.equalsIgnoreCase(FULL)) continue;
            lines = Integers.parseInt((String)var8_12);
        }
        return new ThrowableFormatOptions((int)var1_3, (String)var2_4, (List<String>)var3_5, ansiRenderer, suffix);
    }

    public final String getSuffix() {
        return this.suffix;
    }
}

