/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.impl.JdkMapAdapterStringMap;
import org.apache.logging.log4j.core.util.ContextDataProvider;
import org.apache.logging.log4j.spi.ReadOnlyThreadContextMap;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.ServiceLoaderUtil;
import org.apache.logging.log4j.util.StringMap;

public class ThreadContextDataInjector {
    private static final Logger LOGGER = StatusLogger.getLogger();
    public static Collection<ContextDataProvider> contextDataProviders = new ConcurrentLinkedDeque<ContextDataProvider>();
    private static final List<ContextDataProvider> SERVICE_PROVIDERS = ThreadContextDataInjector.getServiceProviders();

    @Deprecated
    public static void initServiceProviders() {
    }

    /*
     * WARNING - void declaration
     */
    private static List<ContextDataProvider> getServiceProviders() {
        void var0;
        ArrayList providers = new ArrayList();
        ServiceLoaderUtil.loadServices(ContextDataProvider.class, (MethodHandles.Lookup)MethodHandles.lookup(), (boolean)false).forEach(providers::add);
        return Collections.unmodifiableList(var0);
    }

    /*
     * WARNING - void declaration
     */
    public static void copyProperties(List<Property> properties, StringMap result) {
        if (properties != null) {
            for (int i = 0; i < properties.size(); ++i) {
                void var3_3;
                Property prop = properties.get(i);
                result.putValue(prop.getName(), (Object)var3_3.getValue());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static List<ContextDataProvider> getProviders() {
        void var0;
        ArrayList<ContextDataProvider> providers = new ArrayList<ContextDataProvider>(contextDataProviders.size() + SERVICE_PROVIDERS.size());
        providers.addAll(contextDataProviders);
        providers.addAll(SERVICE_PROVIDERS);
        return var0;
    }

    static /* synthetic */ List access$000() {
        return ThreadContextDataInjector.getProviders();
    }

    public static class ForCopyOnWriteThreadContextMap
    implements ContextDataInjector {
        private final List<ContextDataProvider> providers = ThreadContextDataInjector.access$000();

        /*
         * WARNING - void declaration
         */
        @Override
        public StringMap injectContextData(List<Property> props, StringMap ignore) {
            void var3_4;
            void var1_1;
            int n;
            if (this.providers.size() == 1 && (props == null || props.isEmpty())) {
                return this.providers.get(0).supplyStringMap();
            }
            int count = props == null ? 0 : props.size();
            StringMap[] maps = new StringMap[this.providers.size()];
            for (int i = 0; i < this.providers.size(); ++i) {
                maps[i] = this.providers.get(i).supplyStringMap();
                count += maps[i].size();
            }
            StringMap result = ContextDataFactory.createContextData(n);
            ThreadContextDataInjector.copyProperties((List<Property>)var1_1, result);
            for (void map : var3_4) {
                result.putAll((ReadOnlyStringMap)map);
            }
            return result;
        }

        @Override
        public ReadOnlyStringMap rawContextData() {
            return ThreadContext.getThreadContextMap().getReadOnlyContextData();
        }
    }

    public static class ForGarbageFreeThreadContextMap
    implements ContextDataInjector {
        private final List<ContextDataProvider> providers = ThreadContextDataInjector.access$000();

        /*
         * WARNING - void declaration
         */
        @Override
        public StringMap injectContextData(List<Property> props, StringMap reusable) {
            void var2_3;
            ThreadContextDataInjector.copyProperties(props, reusable);
            for (int i = 0; i < this.providers.size(); ++i) {
                reusable.putAll((ReadOnlyStringMap)this.providers.get(i).supplyStringMap());
            }
            return var2_3;
        }

        @Override
        public ReadOnlyStringMap rawContextData() {
            return ThreadContext.getThreadContextMap().getReadOnlyContextData();
        }
    }

    public static class ForDefaultThreadContextMap
    implements ContextDataInjector {
        private final List<ContextDataProvider> providers = ThreadContextDataInjector.access$000();

        @Override
        public StringMap injectContextData(List<Property> props, StringMap contextData) {
            Iterator<ContextDataProvider> iterator;
            Map<Object, Object> copy;
            if (this.providers.size() == 1) {
                copy = this.providers.get(0).supplyContextData();
            } else {
                copy = new HashMap();
                iterator = this.providers.iterator();
                while (iterator.hasNext()) {
                    ContextDataProvider provider = iterator.next();
                    copy.putAll(provider.supplyContextData());
                }
            }
            if (props == null || props.isEmpty()) {
                if (copy.isEmpty()) {
                    return ContextDataFactory.emptyFrozenContextData();
                }
                return ForDefaultThreadContextMap.frozenStringMap(copy);
            }
            JdkMapAdapterStringMap result = new JdkMapAdapterStringMap(new HashMap<Object, Object>(copy));
            for (int i = 0; i < props.size(); ++i) {
                Property prop = props.get(i);
                if (copy.containsKey(prop.getName())) continue;
                result.putValue(prop.getName(), prop.getValue());
            }
            result.freeze();
            return iterator;
        }

        private static JdkMapAdapterStringMap frozenStringMap(Map<String, String> copy) {
            JdkMapAdapterStringMap jdkMapAdapterStringMap;
            JdkMapAdapterStringMap result = new JdkMapAdapterStringMap(copy);
            result.freeze();
            return jdkMapAdapterStringMap;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ReadOnlyStringMap rawContextData() {
            void var1_1;
            ReadOnlyThreadContextMap map = ThreadContext.getThreadContextMap();
            if (map instanceof ReadOnlyStringMap) {
                return (ReadOnlyStringMap)map;
            }
            Map copy = ThreadContext.getImmutableContext();
            if (copy.isEmpty()) {
                return ContextDataFactory.emptyFrozenContextData();
            }
            return new JdkMapAdapterStringMap((Map<String, String>)var1_1);
        }
    }
}

