/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.async.ThreadNameCachingStrategy;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.impl.ContextDataInjectorFactory;
import org.apache.logging.log4j.core.impl.LocationAwareLogEventFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.LogEventFactory;
import org.apache.logging.log4j.core.impl.MutableLogEvent;
import org.apache.logging.log4j.core.util.Clock;
import org.apache.logging.log4j.core.util.ClockFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.StringMap;

public class ReusableLogEventFactory
implements LocationAwareLogEventFactory,
LogEventFactory {
    private static final ThreadNameCachingStrategy THREAD_NAME_CACHING_STRATEGY = ThreadNameCachingStrategy.create();
    private static final Clock CLOCK = ClockFactory.getClock();
    private static final ThreadLocal<MutableLogEvent> mutableLogEventThreadLocal = new ThreadLocal();
    private final ContextDataInjector injector = ContextDataInjectorFactory.createInjector();

    /*
     * WARNING - void declaration
     */
    @Override
    public LogEvent createEvent(String loggerName, Marker marker, String fqcn, Level level, Message message, List<Property> properties, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.createEvent((String)var1_1, (Marker)var2_2, (String)var3_3, null, level, message, properties, t);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LogEvent createEvent(String loggerName, Marker marker, String fqcn, StackTraceElement location, Level level, Message message, List<Property> properties, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        MutableLogEvent result = ReusableLogEventFactory.getOrCreateMutableLogEvent();
        ReusableLogEventFactory.getOrCreateMutableLogEvent().reserved = true;
        result.setLoggerName((String)var1_1);
        result.setMarker((Marker)var2_2);
        result.setLoggerFqcn((String)var3_3);
        result.setLevel(level == null ? Level.OFF : level);
        result.setMessage(message);
        result.initTime(CLOCK, Log4jLogEvent.getNanoClock());
        result.setThrown(t);
        result.setSource(location);
        result.setContextData(this.injector.injectContextData(properties, (StringMap)result.getContextData()));
        result.setContextStack((ThreadContext.ContextStack)(ThreadContext.getDepth() == 0 ? ThreadContext.EMPTY_STACK : ThreadContext.cloneStack()));
        if (THREAD_NAME_CACHING_STRATEGY == ThreadNameCachingStrategy.UNCACHED) {
            result.setThreadName(Thread.currentThread().getName());
            result.setThreadPriority(Thread.currentThread().getPriority());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static MutableLogEvent getOrCreateMutableLogEvent() {
        void var0;
        MutableLogEvent result = mutableLogEventThreadLocal.get();
        if (result == null || result.reserved) {
            return ReusableLogEventFactory.createInstance(result);
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static MutableLogEvent createInstance(MutableLogEvent existing) {
        void var1_1;
        MutableLogEvent mutableLogEvent;
        MutableLogEvent result = new MutableLogEvent();
        result.setThreadId(Thread.currentThread().getId());
        result.setThreadName(Thread.currentThread().getName());
        result.setThreadPriority(Thread.currentThread().getPriority());
        if (mutableLogEvent == null) {
            mutableLogEventThreadLocal.set(result);
        }
        return var1_1;
    }

    public static void release(LogEvent logEvent) {
        if (logEvent instanceof MutableLogEvent) {
            LogEvent mutableLogEvent = (MutableLogEvent)logEvent;
            ((MutableLogEvent)mutableLogEvent).clear();
            ((MutableLogEvent)var0).reserved = false;
        }
    }
}

