/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.async.InternalAsyncUtil;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.MementoMessage;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.apache.logging.log4j.core.util.Clock;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.NanoClock;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterConsumer;
import org.apache.logging.log4j.message.ParameterVisitable;
import org.apache.logging.log4j.message.ReusableMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.message.TimestampMessage;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.apache.logging.log4j.util.StringBuilders;
import org.apache.logging.log4j.util.StringMap;

public class MutableLogEvent
implements LogEvent,
ParameterVisitable,
ReusableMessage {
    private static final Message EMPTY = new SimpleMessage("");
    private int threadPriority;
    private long threadId;
    private final MutableInstant instant = new MutableInstant();
    private long nanoTime;
    private short parameterCount;
    private boolean includeLocation;
    private boolean endOfBatch = false;
    private Level level;
    private String threadName;
    private String loggerName;
    private Message message;
    private String messageFormat;
    private StringBuilder messageText;
    private Object[] parameters;
    private Throwable thrown;
    private ThrowableProxy thrownProxy;
    private StringMap contextData = ContextDataFactory.createContextData();
    private Marker marker;
    private String loggerFqcn;
    StackTraceElement source;
    private ThreadContext.ContextStack contextStack;
    transient boolean reserved = false;

    public MutableLogEvent() {
        this(null, null);
    }

    /*
     * WARNING - void declaration
     */
    public MutableLogEvent(StringBuilder msgText, Object[] replacementParameters) {
        void var2_2;
        void var1_1;
        this.messageText = var1_1;
        this.parameters = var2_2;
    }

    @Override
    public Log4jLogEvent toImmutable() {
        return this.createMemento();
    }

    /*
     * WARNING - void declaration
     */
    public void initFrom(LogEvent event) {
        void var1_1;
        this.loggerFqcn = event.getLoggerFqcn();
        this.marker = event.getMarker();
        this.level = event.getLevel();
        this.loggerName = event.getLoggerName();
        this.thrown = event.getThrown();
        this.thrownProxy = event.getThrownProxy();
        this.instant.initFrom(event.getInstant());
        this.contextData.putAll(event.getContextData());
        this.contextStack = event.getContextStack();
        this.source = event.isIncludeLocation() ? event.getSource() : null;
        this.threadId = event.getThreadId();
        this.threadName = event.getThreadName();
        this.threadPriority = event.getThreadPriority();
        this.endOfBatch = event.isEndOfBatch();
        this.includeLocation = event.isIncludeLocation();
        this.nanoTime = event.getNanoTime();
        this.setMessage(var1_1.getMessage());
    }

    public void clear() {
        this.loggerFqcn = null;
        this.marker = null;
        this.level = null;
        this.loggerName = null;
        this.message = null;
        this.messageFormat = null;
        this.thrown = null;
        this.thrownProxy = null;
        this.source = null;
        if (this.contextData != null) {
            if (this.contextData.isFrozen()) {
                this.contextData = null;
            } else {
                this.contextData.clear();
            }
        }
        this.contextStack = null;
        StringBuilders.trimToMaxSize((StringBuilder)this.messageText, (int)Constants.MAX_REUSABLE_MESSAGE_SIZE);
        if (this.parameters != null) {
            Arrays.fill(this.parameters, null);
        }
    }

    @Override
    public String getLoggerFqcn() {
        return this.loggerFqcn;
    }

    /*
     * WARNING - void declaration
     */
    public void setLoggerFqcn(String loggerFqcn) {
        void var1_1;
        this.loggerFqcn = var1_1;
    }

    @Override
    public Marker getMarker() {
        return this.marker;
    }

    /*
     * WARNING - void declaration
     */
    public void setMarker(Marker marker) {
        void var1_1;
        this.marker = var1_1;
    }

    @Override
    public Level getLevel() {
        if (this.level == null) {
            this.level = Level.OFF;
        }
        return this.level;
    }

    /*
     * WARNING - void declaration
     */
    public void setLevel(Level level) {
        void var1_1;
        this.level = var1_1;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    /*
     * WARNING - void declaration
     */
    public void setLoggerName(String loggerName) {
        void var1_1;
        this.loggerName = var1_1;
    }

    @Override
    public Message getMessage() {
        if (this.message == null) {
            if (this.messageText == null) {
                return EMPTY;
            }
            return this;
        }
        return this.message;
    }

    /*
     * WARNING - void declaration
     */
    public void setMessage(Message msg) {
        void var1_1;
        if (msg instanceof ReusableMessage) {
            void var2_2;
            ReusableMessage reusable = (ReusableMessage)msg;
            reusable.formatTo(this.getMessageTextForWriting());
            this.messageFormat = msg.getFormat();
            this.parameters = reusable.swapParameters(this.parameters == null ? new Object[10] : this.parameters);
            this.parameterCount = var2_2.getParameterCount();
            return;
        }
        this.message = InternalAsyncUtil.makeMessageImmutable((Message)var1_1);
    }

    private StringBuilder getMessageTextForWriting() {
        if (this.messageText == null) {
            this.messageText = new StringBuilder(Constants.INITIAL_REUSABLE_MESSAGE_SIZE);
        }
        this.messageText.setLength(0);
        return this.messageText;
    }

    public String getFormattedMessage() {
        return this.messageText.toString();
    }

    public String getFormat() {
        return this.messageFormat;
    }

    public Object[] getParameters() {
        if (this.parameters == null) {
            return null;
        }
        return Arrays.copyOf(this.parameters, (int)this.parameterCount);
    }

    public <S> void forEachParameter(ParameterConsumer<S> action, S state) {
        if (this.parameters != null) {
            for (short i = 0; i < this.parameterCount; i = (short)(i + 1)) {
                action.accept(this.parameters[i], (int)i, state);
            }
        }
    }

    public Throwable getThrowable() {
        return this.getThrown();
    }

    public void formatTo(StringBuilder buffer) {
        buffer.append((CharSequence)this.messageText);
    }

    /*
     * WARNING - void declaration
     */
    public Object[] swapParameters(Object[] emptyReplacement) {
        void var2_2;
        void var1_1;
        Object[] result = this.parameters;
        this.parameters = var1_1;
        return var2_2;
    }

    public short getParameterCount() {
        return this.parameterCount;
    }

    public Message memento() {
        if (this.message == null) {
            this.message = new MementoMessage(String.valueOf(this.messageText), this.messageFormat, this.getParameters());
        }
        return this.message;
    }

    @Override
    public Throwable getThrown() {
        return this.thrown;
    }

    /*
     * WARNING - void declaration
     */
    public void setThrown(Throwable thrown) {
        void var1_1;
        this.thrown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    void initTime(Clock clock, NanoClock nanoClock) {
        void var2_2;
        if (this.message instanceof TimestampMessage) {
            this.instant.initFromEpochMilli(((TimestampMessage)this.message).getTimestamp(), 0);
        } else {
            void var1_1;
            this.instant.initFrom((Clock)var1_1);
        }
        this.nanoTime = var2_2.nanoTime();
    }

    @Override
    public long getTimeMillis() {
        return this.instant.getEpochMillisecond();
    }

    /*
     * WARNING - void declaration
     */
    public void setTimeMillis(long timeMillis) {
        void var1_1;
        this.instant.initFromEpochMilli((long)var1_1, 0);
    }

    @Override
    public Instant getInstant() {
        return this.instant;
    }

    @Override
    public ThrowableProxy getThrownProxy() {
        if (this.thrownProxy == null && this.thrown != null) {
            this.thrownProxy = new ThrowableProxy(this.thrown);
        }
        return this.thrownProxy;
    }

    /*
     * WARNING - void declaration
     */
    public void setSource(StackTraceElement source) {
        void var1_1;
        this.source = var1_1;
    }

    @Override
    public StackTraceElement getSource() {
        if (this.source != null) {
            return this.source;
        }
        if (this.loggerFqcn == null || !this.includeLocation) {
            return null;
        }
        this.source = StackLocatorUtil.calcLocation((String)this.loggerFqcn);
        return this.source;
    }

    @Override
    public ReadOnlyStringMap getContextData() {
        return this.contextData;
    }

    @Override
    public Map<String, String> getContextMap() {
        return this.contextData.toMap();
    }

    /*
     * WARNING - void declaration
     */
    public void setContextData(StringMap mutableContextData) {
        void var1_1;
        this.contextData = var1_1;
    }

    @Override
    public ThreadContext.ContextStack getContextStack() {
        return this.contextStack;
    }

    /*
     * WARNING - void declaration
     */
    public void setContextStack(ThreadContext.ContextStack contextStack) {
        void var1_1;
        this.contextStack = var1_1;
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    /*
     * WARNING - void declaration
     */
    public void setThreadId(long threadId) {
        void var1_1;
        this.threadId = var1_1;
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    /*
     * WARNING - void declaration
     */
    public void setThreadName(String threadName) {
        void var1_1;
        this.threadName = var1_1;
    }

    @Override
    public int getThreadPriority() {
        return this.threadPriority;
    }

    /*
     * WARNING - void declaration
     */
    public void setThreadPriority(int threadPriority) {
        void var1_1;
        this.threadPriority = var1_1;
    }

    @Override
    public boolean isIncludeLocation() {
        return this.includeLocation;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setIncludeLocation(boolean includeLocation) {
        void var1_1;
        this.includeLocation = var1_1;
    }

    @Override
    public boolean isEndOfBatch() {
        return this.endOfBatch;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setEndOfBatch(boolean endOfBatch) {
        void var1_1;
        this.endOfBatch = var1_1;
    }

    @Override
    public long getNanoTime() {
        return this.nanoTime;
    }

    /*
     * WARNING - void declaration
     */
    public void setNanoTime(long nanoTime) {
        void var1_1;
        this.nanoTime = var1_1;
    }

    protected Object writeReplace() {
        MutableLogEvent mutableLogEvent = this;
        return new Log4jLogEvent.LogEventProxy(mutableLogEvent, mutableLogEvent.includeLocation);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    public Log4jLogEvent createMemento() {
        MutableLogEvent mutableLogEvent = this;
        return Log4jLogEvent.deserialize(Log4jLogEvent.serialize(mutableLogEvent, mutableLogEvent.includeLocation));
    }

    public void initializeBuilder(Log4jLogEvent.Builder builder) {
        builder.setContextData(this.contextData).setContextStack(this.contextStack).setEndOfBatch(this.endOfBatch).setIncludeLocation(this.includeLocation).setLevel(this.getLevel()).setLoggerFqcn(this.loggerFqcn).setLoggerName(this.loggerName).setMarker(this.marker).setMessage(this.memento()).setNanoTime(this.nanoTime).setSource(this.source).setThreadId(this.threadId).setThreadName(this.threadName).setThreadPriority(this.threadPriority).setThrown(this.getThrown()).setThrownProxy(this.thrownProxy).setInstant(this.instant);
    }
}

