/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.async.RingBufferLogEvent;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.impl.ContextDataInjectorFactory;
import org.apache.logging.log4j.core.impl.MementoMessage;
import org.apache.logging.log4j.core.impl.MutableLogEvent;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.apache.logging.log4j.core.util.Clock;
import org.apache.logging.log4j.core.util.ClockFactory;
import org.apache.logging.log4j.core.util.DummyNanoClock;
import org.apache.logging.log4j.core.util.NanoClock;
import org.apache.logging.log4j.message.LoggerNameAwareMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ReusableMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.message.TimestampMessage;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.apache.logging.log4j.util.StringMap;

public class Log4jLogEvent
implements LogEvent {
    private static final long serialVersionUID = -8393305700508709443L;
    private static final Clock CLOCK = ClockFactory.getClock();
    private static volatile NanoClock nanoClock = new DummyNanoClock();
    private static final ContextDataInjector CONTEXT_DATA_INJECTOR = ContextDataInjectorFactory.createInjector();
    private final String loggerFqcn;
    private final Marker marker;
    private final Level level;
    private final String loggerName;
    private Message message;
    private final MutableInstant instant = new MutableInstant();
    private final transient Throwable thrown;
    private ThrowableProxy thrownProxy;
    private final StringMap contextData;
    private final ThreadContext.ContextStack contextStack;
    private long threadId;
    private String threadName;
    private int threadPriority;
    private StackTraceElement source;
    private boolean includeLocation;
    private boolean endOfBatch = false;
    private final transient long nanoTime;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Log4jLogEvent() {
        this("", null, "", null, null, null, null, null, null, 0L, null, 0, null, CLOCK, nanoClock.nanoTime());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public Log4jLogEvent(long timestamp) {
        this("", null, "", null, null, null, null, null, null, 0L, null, 0, null, (long)var1_1, 0, nanoClock.nanoTime());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public Log4jLogEvent(String loggerName, Marker marker, String loggerFQCN, Level level, Message message, Throwable t) {
        this((String)var1_1, (Marker)var2_2, (String)var3_3, level, message, null, t);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Log4jLogEvent(String loggerName, Marker marker, String loggerFQCN, Level level, Message message, List<Property> properties, Throwable t) {
        this((String)var1_1, (Marker)var2_2, (String)var3_3, level, message, t, null, Log4jLogEvent.createContextData(properties), ThreadContext.getDepth() == 0 ? null : ThreadContext.cloneStack(), 0L, null, 0, null, CLOCK, nanoClock.nanoTime());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Log4jLogEvent(String loggerName, Marker marker, String loggerFQCN, StackTraceElement source, Level level, Message message, List<Property> properties, Throwable t) {
        this((String)var1_1, (Marker)var2_2, (String)var3_3, level, message, t, null, Log4jLogEvent.createContextData(properties), ThreadContext.getDepth() == 0 ? null : ThreadContext.cloneStack(), 0L, null, 0, source, CLOCK, nanoClock.nanoTime());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public Log4jLogEvent(String loggerName, Marker marker, String loggerFQCN, Level level, Message message, Throwable t, Map<String, String> mdc, ThreadContext.ContextStack ndc, String threadName, StackTraceElement location, long timestampMillis) {
        this((String)var1_1, (Marker)var2_2, (String)var3_3, level, message, t, null, Log4jLogEvent.createContextData(mdc), ndc, 0L, threadName, 0, location, timestampMillis, 0, nanoClock.nanoTime());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static Log4jLogEvent createEvent(String loggerName, Marker marker, String loggerFQCN, Level level, Message message, Throwable thrown, ThrowableProxy thrownProxy, Map<String, String> mdc, ThreadContext.ContextStack ndc, String threadName, StackTraceElement location, long timestamp) {
        void var3_3;
        void var2_2;
        void var1_1;
        Log4jLogEvent log4jLogEvent;
        log4jLogEvent = new Log4jLogEvent((String)((Object)log4jLogEvent), (Marker)var1_1, (String)var2_2, (Level)var3_3, message, thrown, thrownProxy, Log4jLogEvent.createContextData(mdc), ndc, 0L, threadName, 0, location, timestamp, 0, nanoClock.nanoTime());
        return log4jLogEvent;
    }

    /*
     * WARNING - void declaration
     */
    private Log4jLogEvent(String loggerName, Marker marker, String loggerFQCN, Level level, Message message, Throwable thrown, ThrowableProxy thrownProxy, StringMap contextData, ThreadContext.ContextStack contextStack, long threadId, String threadName, int threadPriority, StackTraceElement source, long timestampMillis, int nanoOfMillisecond, long nanoTime) {
        this((String)var1_1, (Marker)var2_2, (String)var3_3, level, message, thrown, thrownProxy, contextData, contextStack, threadId, threadName, threadPriority, source, nanoTime);
        void var3_3;
        void var2_2;
        void var1_1;
        long millis = message instanceof TimestampMessage ? ((TimestampMessage)message).getTimestamp() : timestampMillis;
        this.instant.initFromEpochMilli(millis, nanoOfMillisecond);
    }

    /*
     * WARNING - void declaration
     */
    private Log4jLogEvent(String loggerName, Marker marker, String loggerFQCN, Level level, Message message, Throwable thrown, ThrowableProxy thrownProxy, StringMap contextData, ThreadContext.ContextStack contextStack, long threadId, String threadName, int threadPriority, StackTraceElement source, Clock clock, long nanoTime) {
        this((String)var1_1, (Marker)var2_2, (String)var3_3, level, message, thrown, thrownProxy, contextData, contextStack, threadId, threadName, threadPriority, source, nanoTime);
        void var3_3;
        void var2_2;
        void var1_1;
        if (message instanceof TimestampMessage) {
            this.instant.initFromEpochMilli(((TimestampMessage)message).getTimestamp(), 0);
            return;
        }
        this.instant.initFrom(clock);
    }

    /*
     * WARNING - void declaration
     */
    private Log4jLogEvent(String loggerName, Marker marker, String loggerFQCN, Level level, Message message, Throwable thrown, ThrowableProxy thrownProxy, StringMap contextData, ThreadContext.ContextStack contextStack, long threadId, String threadName, int threadPriority, StackTraceElement source, long nanoTime) {
        void var3_3;
        void var2_2;
        this.loggerName = loggerName;
        this.marker = var2_2;
        this.loggerFqcn = var3_3;
        this.level = level == null ? Level.OFF : level;
        this.message = message;
        this.thrown = thrown;
        this.thrownProxy = thrownProxy;
        this.contextData = contextData == null ? ContextDataFactory.createContextData() : contextData;
        this.contextStack = contextStack == null ? ThreadContext.EMPTY_STACK : contextStack;
        this.threadId = threadId;
        this.threadName = threadName;
        this.threadPriority = threadPriority;
        this.source = source;
        if (message instanceof LoggerNameAwareMessage) {
            void var1_1;
            ((LoggerNameAwareMessage)message).setLoggerName((String)var1_1);
        }
        this.nanoTime = nanoTime;
    }

    /*
     * WARNING - void declaration
     */
    private static StringMap createContextData(Map<String, String> contextMap) {
        void var1_1;
        StringMap result = ContextDataFactory.createContextData();
        if (contextMap != null) {
            Object object;
            for (Map.Entry entry : object.entrySet()) {
                result.putValue((String)entry.getKey(), entry.getValue());
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static StringMap createContextData(List<Property> properties) {
        void var1_1;
        List<Property> list;
        StringMap reusable = ContextDataFactory.createContextData();
        return CONTEXT_DATA_INJECTOR.injectContextData(list, (StringMap)var1_1);
    }

    public static NanoClock getNanoClock() {
        return nanoClock;
    }

    public static void setNanoClock(NanoClock nanoClock) {
        NanoClock nanoClock2;
        Log4jLogEvent.nanoClock = Objects.requireNonNull(nanoClock, "NanoClock must be non-null");
        StatusLogger.getLogger().trace("Using {} for nanosecond timestamps.", (Object)nanoClock2.getClass().getSimpleName());
    }

    public Builder asBuilder() {
        return new Builder(this);
    }

    @Override
    public Log4jLogEvent toImmutable() {
        if (this.getMessage() instanceof ReusableMessage) {
            this.makeMessageImmutable();
        }
        return this;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    public void makeMessageImmutable() {
        this.message = new MementoMessage(this.message.getFormattedMessage(), this.message.getFormat(), this.message.getParameters());
    }

    @Override
    public long getThreadId() {
        if (this.threadId == 0L) {
            this.threadId = Thread.currentThread().getId();
        }
        return this.threadId;
    }

    @Override
    public String getThreadName() {
        if (this.threadName == null) {
            this.threadName = Thread.currentThread().getName();
        }
        return this.threadName;
    }

    @Override
    public int getThreadPriority() {
        if (this.threadPriority == 0) {
            this.threadPriority = Thread.currentThread().getPriority();
        }
        return this.threadPriority;
    }

    @Override
    public long getTimeMillis() {
        return this.instant.getEpochMillisecond();
    }

    @Override
    public Instant getInstant() {
        return this.instant;
    }

    @Override
    public Throwable getThrown() {
        return this.thrown;
    }

    @Override
    public ThrowableProxy getThrownProxy() {
        if (this.thrownProxy == null && this.thrown != null) {
            this.thrownProxy = new ThrowableProxy(this.thrown);
        }
        return this.thrownProxy;
    }

    @Override
    public Marker getMarker() {
        return this.marker;
    }

    @Override
    public String getLoggerFqcn() {
        return this.loggerFqcn;
    }

    @Override
    public ReadOnlyStringMap getContextData() {
        return this.contextData;
    }

    @Override
    public Map<String, String> getContextMap() {
        return this.contextData.toMap();
    }

    @Override
    public ThreadContext.ContextStack getContextStack() {
        return this.contextStack;
    }

    @Override
    public StackTraceElement getSource() {
        if (this.source != null) {
            return this.source;
        }
        if (this.loggerFqcn == null || !this.includeLocation) {
            return null;
        }
        this.source = StackLocatorUtil.calcLocation((String)this.loggerFqcn);
        return this.source;
    }

    @Override
    public boolean isIncludeLocation() {
        return this.includeLocation;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setIncludeLocation(boolean includeLocation) {
        void var1_1;
        this.includeLocation = var1_1;
    }

    @Override
    public boolean isEndOfBatch() {
        return this.endOfBatch;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setEndOfBatch(boolean endOfBatch) {
        void var1_1;
        this.endOfBatch = var1_1;
    }

    @Override
    public long getNanoTime() {
        return this.nanoTime;
    }

    protected Object writeReplace() {
        this.getThrownProxy();
        Log4jLogEvent log4jLogEvent = this;
        return new LogEventProxy(log4jLogEvent, log4jLogEvent.includeLocation);
    }

    /*
     * WARNING - void declaration
     */
    public static Serializable serialize(LogEvent event, boolean includeLocation) {
        void var1_1;
        LogEvent logEvent;
        if (event instanceof Log4jLogEvent) {
            event.getThrownProxy();
            return new LogEventProxy((Log4jLogEvent)event, includeLocation);
        }
        return new LogEventProxy(logEvent, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Serializable serialize(Log4jLogEvent event, boolean includeLocation) {
        void var1_1;
        Log4jLogEvent log4jLogEvent;
        event.getThrownProxy();
        return new LogEventProxy(log4jLogEvent, (boolean)var1_1);
    }

    public static boolean canDeserialize(Serializable event) {
        return event instanceof LogEventProxy;
    }

    /*
     * WARNING - void declaration
     */
    public static Log4jLogEvent deserialize(Serializable event) {
        Serializable serializable;
        Objects.requireNonNull(event, "Event cannot be null");
        if (event instanceof LogEventProxy) {
            void var1_1;
            Serializable proxy = (LogEventProxy)event;
            Log4jLogEvent result = new Log4jLogEvent(((LogEventProxy)proxy).loggerName, ((LogEventProxy)proxy).marker, ((LogEventProxy)proxy).loggerFQCN, ((LogEventProxy)proxy).level, ((LogEventProxy)proxy).message, ((LogEventProxy)proxy).thrown, ((LogEventProxy)proxy).thrownProxy, ((LogEventProxy)proxy).contextData, ((LogEventProxy)proxy).contextStack, ((LogEventProxy)proxy).threadId, ((LogEventProxy)proxy).threadName, ((LogEventProxy)proxy).threadPriority, ((LogEventProxy)proxy).source, ((LogEventProxy)proxy).timeMillis, ((LogEventProxy)proxy).nanoOfMillisecond, ((LogEventProxy)proxy).nanoTime);
            result.setEndOfBatch(((LogEventProxy)proxy).isEndOfBatch);
            result.setIncludeLocation(((LogEventProxy)serializable).isLocationRequired);
            return var1_1;
        }
        throw new IllegalArgumentException("Event is not a serialized LogEvent: " + serializable.toString());
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    public static LogEvent createMemento(LogEvent logEvent) {
        LogEvent logEvent2;
        return new Builder(logEvent2).build();
    }

    /*
     * WARNING - void declaration
     */
    public static Log4jLogEvent createMemento(LogEvent event, boolean includeLocation) {
        void var1_1;
        return Log4jLogEvent.deserialize(Log4jLogEvent.serialize(event, (boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        void var2_2;
        StringBuilder sb = new StringBuilder();
        String n = this.loggerName.isEmpty() ? "root" : this.loggerName;
        sb.append("Logger=").append((String)var2_2);
        sb.append(" Level=").append(this.level.name());
        sb.append(" Message=").append(this.message == null ? null : this.message.getFormattedMessage());
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Log4jLogEvent that = (Log4jLogEvent)o;
        if (this.endOfBatch != that.endOfBatch) {
            return false;
        }
        if (this.includeLocation != that.includeLocation) {
            return false;
        }
        if (!this.instant.equals(that.instant)) {
            return false;
        }
        if (this.nanoTime != that.nanoTime) {
            return false;
        }
        if (this.loggerFqcn != null ? !this.loggerFqcn.equals(that.loggerFqcn) : that.loggerFqcn != null) {
            return false;
        }
        if (this.level != null ? !this.level.equals((Object)that.level) : that.level != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.marker != null ? !this.marker.equals((Object)that.marker) : that.marker != null) {
            return false;
        }
        if (this.contextData != null ? !this.contextData.equals((Object)that.contextData) : that.contextData != null) {
            return false;
        }
        if (!this.message.equals(that.message)) {
            return false;
        }
        if (!this.loggerName.equals(that.loggerName)) {
            return false;
        }
        if (this.contextStack != null ? !this.contextStack.equals(that.contextStack) : that.contextStack != null) {
            return false;
        }
        if (this.threadId != that.threadId) {
            return false;
        }
        if (this.threadName != null ? !this.threadName.equals(that.threadName) : that.threadName != null) {
            return false;
        }
        if (this.threadPriority != that.threadPriority) {
            return false;
        }
        if (this.thrown != null ? !this.thrown.equals(that.thrown) : that.thrown != null) {
            return false;
        }
        return !(this.thrownProxy != null ? !this.thrownProxy.equals(that.thrownProxy) : var1_1.thrownProxy != null);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.loggerFqcn != null ? this.loggerFqcn.hashCode() : 0;
        result = result * 31 + (this.marker != null ? this.marker.hashCode() : 0);
        result = result * 31 + (this.level != null ? this.level.hashCode() : 0);
        result = result * 31 + this.loggerName.hashCode();
        result = result * 31 + this.message.hashCode();
        result = result * 31 + this.instant.hashCode();
        result = result * 31 + (int)(this.nanoTime ^ this.nanoTime >>> 32);
        result = result * 31 + (this.thrown != null ? this.thrown.hashCode() : 0);
        result = result * 31 + (this.thrownProxy != null ? this.thrownProxy.hashCode() : 0);
        result = result * 31 + (this.contextData != null ? this.contextData.hashCode() : 0);
        result = result * 31 + (this.contextStack != null ? this.contextStack.hashCode() : 0);
        result = result * 31 + (int)(this.threadId ^ this.threadId >>> 32);
        result = result * 31 + (this.threadName != null ? this.threadName.hashCode() : 0);
        result = result * 31 + (this.threadPriority ^ this.threadPriority >>> 32);
        result = result * 31 + (this.source != null ? this.source.hashCode() : 0);
        result = result * 31 + (this.includeLocation ? 1 : 0);
        var1_1 = var1_1 * 31 + this.endOfBatch;
        return (int)var1_1;
    }

    static /* synthetic */ StringMap access$000(List x0) {
        return Log4jLogEvent.createContextData(x0);
    }

    static class LogEventProxy
    implements Serializable {
        private static final long serialVersionUID = -8634075037355293699L;
        private final String loggerFQCN;
        private final Marker marker;
        private final Level level;
        private final String loggerName;
        private final transient Message message;
        private MarshalledObject<Message> marshalledMessage;
        private String messageString;
        private final long timeMillis;
        private final int nanoOfMillisecond;
        private final transient Throwable thrown;
        private final ThrowableProxy thrownProxy;
        private final StringMap contextData;
        private final ThreadContext.ContextStack contextStack;
        private final long threadId;
        private final String threadName;
        private final int threadPriority;
        private final StackTraceElement source;
        private final boolean isLocationRequired;
        private final boolean isEndOfBatch;
        private final transient long nanoTime;

        /*
         * WARNING - void declaration
         */
        public LogEventProxy(Log4jLogEvent event, boolean includeLocation) {
            void var1_1;
            void var2_2;
            this.loggerFQCN = event.loggerFqcn;
            this.marker = event.marker;
            this.level = event.level;
            this.loggerName = event.loggerName;
            this.message = event.message instanceof ReusableMessage ? LogEventProxy.memento((ReusableMessage)event.message) : event.message;
            this.timeMillis = event.instant.getEpochMillisecond();
            this.nanoOfMillisecond = event.instant.getNanoOfMillisecond();
            this.thrown = event.thrown;
            this.thrownProxy = event.thrownProxy;
            this.contextData = event.contextData;
            this.contextStack = event.contextStack;
            this.source = includeLocation ? event.getSource() : event.source;
            this.threadId = event.getThreadId();
            this.threadName = event.getThreadName();
            this.threadPriority = event.getThreadPriority();
            this.isLocationRequired = var2_2;
            this.isEndOfBatch = event.endOfBatch;
            this.nanoTime = ((Log4jLogEvent)var1_1).nanoTime;
        }

        /*
         * WARNING - void declaration
         */
        public LogEventProxy(LogEvent event, boolean includeLocation) {
            void var1_1;
            void var2_2;
            void var3_3;
            this.loggerFQCN = event.getLoggerFqcn();
            this.marker = event.getMarker();
            this.level = event.getLevel();
            this.loggerName = event.getLoggerName();
            Message temp = event.getMessage();
            this.message = temp instanceof ReusableMessage ? LogEventProxy.memento((ReusableMessage)temp) : var3_3;
            this.timeMillis = event.getInstant().getEpochMillisecond();
            this.nanoOfMillisecond = event.getInstant().getNanoOfMillisecond();
            this.thrown = event.getThrown();
            this.thrownProxy = event.getThrownProxy();
            this.contextData = LogEventProxy.memento(event.getContextData());
            this.contextStack = event.getContextStack();
            this.source = includeLocation ? event.getSource() : (event instanceof MutableLogEvent ? ((MutableLogEvent)event).source : null);
            this.threadId = event.getThreadId();
            this.threadName = event.getThreadName();
            this.threadPriority = event.getThreadPriority();
            this.isLocationRequired = var2_2;
            this.isEndOfBatch = event.isEndOfBatch();
            this.nanoTime = var1_1.getNanoTime();
        }

        private static Message memento(ReusableMessage message) {
            return message.memento();
        }

        /*
         * WARNING - void declaration
         */
        private static StringMap memento(ReadOnlyStringMap data) {
            void var1_1;
            ReadOnlyStringMap readOnlyStringMap;
            StringMap result = ContextDataFactory.createContextData();
            result.putAll(readOnlyStringMap);
            return var1_1;
        }

        private static MarshalledObject<Message> marshall(Message msg) {
            try {
                Message message;
                return new MarshalledObject<Message>(message);
            }
            catch (Exception exception) {
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        private void writeObject(ObjectOutputStream s) throws IOException {
            void var1_1;
            this.messageString = this.message.getFormattedMessage();
            this.marshalledMessage = LogEventProxy.marshall(this.message);
            var1_1.defaultWriteObject();
        }

        /*
         * WARNING - void declaration
         */
        protected Object readResolve() {
            void var1_1;
            Log4jLogEvent result = new Log4jLogEvent(this.loggerName, this.marker, this.loggerFQCN, this.level, this.message(), this.thrown, this.thrownProxy, this.contextData, this.contextStack, this.threadId, this.threadName, this.threadPriority, this.source, this.timeMillis, this.nanoOfMillisecond, this.nanoTime);
            result.setEndOfBatch(this.isEndOfBatch);
            result.setIncludeLocation(this.isLocationRequired);
            return var1_1;
        }

        private Message message() {
            if (this.marshalledMessage != null) {
                try {
                    return this.marshalledMessage.get();
                }
                catch (Exception exception) {}
            }
            return new SimpleMessage(this.messageString);
        }
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<LogEvent> {
        private String loggerFqcn;
        private Marker marker;
        private Level level;
        private String loggerName;
        private Message message;
        private Throwable thrown;
        private final MutableInstant instant = new MutableInstant();
        private ThrowableProxy thrownProxy;
        private StringMap contextData = Log4jLogEvent.access$000(null);
        private ThreadContext.ContextStack contextStack = ThreadContext.getImmutableStack();
        private long threadId;
        private String threadName;
        private int threadPriority;
        private StackTraceElement source;
        private boolean includeLocation;
        private boolean endOfBatch = false;
        private long nanoTime;

        public Builder() {
        }

        /*
         * WARNING - void declaration
         */
        public Builder(LogEvent other) {
            void var1_1;
            Objects.requireNonNull(other);
            if (other instanceof RingBufferLogEvent) {
                ((RingBufferLogEvent)other).initializeBuilder(this);
                return;
            }
            if (other instanceof MutableLogEvent) {
                ((MutableLogEvent)other).initializeBuilder(this);
                return;
            }
            this.loggerFqcn = other.getLoggerFqcn();
            this.marker = other.getMarker();
            this.level = other.getLevel();
            this.loggerName = other.getLoggerName();
            this.message = other.getMessage();
            this.instant.initFrom(other.getInstant());
            this.thrown = other.getThrown();
            this.contextStack = other.getContextStack();
            this.includeLocation = other.isIncludeLocation();
            this.endOfBatch = other.isEndOfBatch();
            this.nanoTime = other.getNanoTime();
            if (other instanceof Log4jLogEvent) {
                Log4jLogEvent evt = (Log4jLogEvent)other;
                this.contextData = evt.contextData;
                this.thrownProxy = evt.thrownProxy;
                this.source = evt.source;
                this.threadId = evt.threadId;
                this.threadName = evt.threadName;
                this.threadPriority = ((Log4jLogEvent)var1_1).threadPriority;
                return;
            }
            if (var1_1.getContextData() instanceof StringMap) {
                this.contextData = (StringMap)var1_1.getContextData();
            } else {
                if (this.contextData.isFrozen()) {
                    this.contextData = ContextDataFactory.createContextData();
                } else {
                    this.contextData.clear();
                }
                this.contextData.putAll(var1_1.getContextData());
            }
            this.thrownProxy = var1_1.getThrownProxy();
            this.source = var1_1.getSource();
            this.threadId = var1_1.getThreadId();
            this.threadName = var1_1.getThreadName();
            this.threadPriority = var1_1.getThreadPriority();
        }

        /*
         * WARNING - void declaration
         */
        public Builder setLevel(Level level) {
            void var1_1;
            this.level = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setLoggerFqcn(String loggerFqcn) {
            void var1_1;
            this.loggerFqcn = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setLoggerName(String loggerName) {
            void var1_1;
            this.loggerName = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setMarker(Marker marker) {
            void var1_1;
            this.marker = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setMessage(Message message) {
            void var1_1;
            this.message = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setThrown(Throwable thrown) {
            void var1_1;
            this.thrown = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setTimeMillis(long timeMillis) {
            void var1_1;
            this.instant.initFromEpochMilli((long)var1_1, 0);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setInstant(Instant instant) {
            void var1_1;
            this.instant.initFrom((Instant)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setThrownProxy(ThrowableProxy thrownProxy) {
            void var1_1;
            this.thrownProxy = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public Builder setContextMap(Map<String, String> contextMap) {
            this.contextData = ContextDataFactory.createContextData();
            if (contextMap != null) {
                Iterator iterator;
                for (Map.Entry entry : iterator.entrySet()) {
                    void var2_2;
                    this.contextData.putValue((String)entry.getKey(), var2_2.getValue());
                }
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setContextData(StringMap contextData) {
            void var1_1;
            this.contextData = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setContextStack(ThreadContext.ContextStack contextStack) {
            void var1_1;
            this.contextStack = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setThreadId(long threadId) {
            void var1_1;
            this.threadId = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setThreadName(String threadName) {
            void var1_1;
            this.threadName = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setThreadPriority(int threadPriority) {
            void var1_1;
            this.threadPriority = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSource(StackTraceElement source) {
            void var1_1;
            this.source = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setIncludeLocation(boolean includeLocation) {
            void var1_1;
            this.includeLocation = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setEndOfBatch(boolean endOfBatch) {
            void var1_1;
            this.endOfBatch = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setNanoTime(long nanoTime) {
            void var1_1;
            this.nanoTime = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Log4jLogEvent build() {
            void var1_1;
            this.initTimeFields();
            Log4jLogEvent result = new Log4jLogEvent(this.loggerName, this.marker, this.loggerFqcn, this.level, this.message, this.thrown, this.thrownProxy, this.contextData, this.contextStack, this.threadId, this.threadName, this.threadPriority, this.source, this.instant.getEpochMillisecond(), this.instant.getNanoOfMillisecond(), this.nanoTime);
            result.setIncludeLocation(this.includeLocation);
            result.setEndOfBatch(this.endOfBatch);
            return var1_1;
        }

        private void initTimeFields() {
            if (this.instant.getEpochMillisecond() == 0L) {
                this.instant.initFrom(CLOCK);
            }
        }
    }
}

