/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.composite.CompositeConfiguration;
import org.apache.logging.log4j.core.impl.ContextAnchor;
import org.apache.logging.log4j.core.selector.ClassLoaderContextSelector;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.core.util.Cancellable;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.DefaultShutdownCallbackRegistry;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;

public class Log4jContextFactory
implements ShutdownCallbackRegistry,
LoggerContextFactory {
    private static final StatusLogger LOGGER = StatusLogger.getLogger();
    private static final boolean SHUTDOWN_HOOK_ENABLED = PropertiesUtil.getProperties().getBooleanProperty("log4j.shutdownHookEnabled", true) && !Constants.IS_WEB_APP;
    private final ContextSelector selector;
    private final ShutdownCallbackRegistry shutdownCallbackRegistry;

    public Log4jContextFactory() {
        this(Log4jContextFactory.createContextSelector(), Log4jContextFactory.createShutdownCallbackRegistry());
    }

    /*
     * WARNING - void declaration
     */
    public Log4jContextFactory(ContextSelector selector) {
        this((ContextSelector)var1_1, Log4jContextFactory.createShutdownCallbackRegistry());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Log4jContextFactory(ShutdownCallbackRegistry shutdownCallbackRegistry) {
        this(Log4jContextFactory.createContextSelector(), (ShutdownCallbackRegistry)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Log4jContextFactory(ContextSelector selector, ShutdownCallbackRegistry shutdownCallbackRegistry) {
        void var2_2;
        void var1_1;
        this.selector = (ContextSelector)Objects.requireNonNull(var1_1, "No ContextSelector provided");
        this.shutdownCallbackRegistry = Objects.requireNonNull(shutdownCallbackRegistry, "No ShutdownCallbackRegistry provided");
        LOGGER.debug("Using ShutdownCallbackRegistry {}", var2_2.getClass());
        this.initializeShutdownCallbackRegistry();
    }

    /*
     * WARNING - void declaration
     */
    private static ContextSelector createContextSelector() {
        try {
            ContextSelector selector = Loader.newCheckedInstanceOfProperty("Log4jContextSelector", ContextSelector.class);
            if (selector != null) {
                return selector;
            }
        }
        catch (Exception e) {
            void var0_1;
            LOGGER.error("Unable to create custom ContextSelector. Falling back to default.", (Throwable)var0_1);
        }
        return new ClassLoaderContextSelector();
    }

    /*
     * WARNING - void declaration
     */
    private static ShutdownCallbackRegistry createShutdownCallbackRegistry() {
        try {
            ShutdownCallbackRegistry registry = Loader.newCheckedInstanceOfProperty("log4j.shutdownCallbackRegistry", ShutdownCallbackRegistry.class);
            if (registry != null) {
                return registry;
            }
        }
        catch (Exception e) {
            void var0_1;
            LOGGER.error("Unable to create custom ShutdownCallbackRegistry. Falling back to default.", (Throwable)var0_1);
        }
        return new DefaultShutdownCallbackRegistry();
    }

    /*
     * WARNING - void declaration
     */
    private void initializeShutdownCallbackRegistry() {
        if (this.isShutdownHookEnabled() && this.shutdownCallbackRegistry instanceof LifeCycle) {
            try {
                ((LifeCycle)((Object)this.shutdownCallbackRegistry)).start();
                return;
            }
            catch (IllegalStateException e) {
                LOGGER.error("Cannot start ShutdownCallbackRegistry, already shutting down.");
                throw e;
            }
            catch (RuntimeException e) {
                void var1_2;
                LOGGER.error("There was an error starting the ShutdownCallbackRegistry.", (Throwable)var1_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public LoggerContext getContext(String fqcn, ClassLoader loader, Object externalContext, boolean currentContext) {
        void var1_1;
        void var2_2;
        LoggerContext ctx = this.selector.getContext(fqcn, (ClassLoader)var2_2, currentContext);
        if (externalContext != null && ctx.getExternalContext() == null) {
            void var3_3;
            ctx.setExternalContext(var3_3);
        }
        if (ctx.getState() == LifeCycle.State.INITIALIZED) {
            ((AbstractLifeCycle)ctx).start();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LoggerContext getContext(String fqcn, ClassLoader loader, Object externalContext, boolean currentContext, ConfigurationSource source) {
        void var1_1;
        LoggerContext ctx = this.selector.getContext(fqcn, loader, currentContext, null);
        if (externalContext != null && ctx.getExternalContext() == null) {
            void var3_3;
            ctx.setExternalContext(var3_3);
        }
        if (ctx.getState() == LifeCycle.State.INITIALIZED) {
            if (source != null) {
                void var2_2;
                ContextAnchor.THREAD_CONTEXT.set(ctx);
                Configuration config = ConfigurationFactory.getInstance().getConfiguration(ctx, source);
                LOGGER.debug("Starting LoggerContext[name={}] from configuration {}", (Object)ctx.getName(), (Object)source);
                ctx.start((Configuration)var2_2);
                ContextAnchor.THREAD_CONTEXT.remove();
            } else {
                ((AbstractLifeCycle)ctx).start();
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LoggerContext getContext(String fqcn, ClassLoader loader, Object externalContext, boolean currentContext, Configuration configuration) {
        void var1_1;
        void var2_3;
        LoggerContext ctx = this.selector.getContext(fqcn, (ClassLoader)var2_3, currentContext, null);
        if (externalContext != null && ctx.getExternalContext() == null) {
            void var3_4;
            ctx.setExternalContext(var3_4);
        }
        if (ctx.getState() == LifeCycle.State.INITIALIZED) {
            ContextAnchor.THREAD_CONTEXT.set(ctx);
            try {
                ctx.start(configuration);
            }
            finally {
                ContextAnchor.THREAD_CONTEXT.remove();
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LoggerContext getContext(String fqcn, ClassLoader loader, Object externalContext, boolean currentContext, URI configLocation, String name) {
        void var1_1;
        LoggerContext ctx = this.selector.getContext(fqcn, loader, currentContext, configLocation);
        if (externalContext != null && ctx.getExternalContext() == null) {
            void var3_3;
            ctx.setExternalContext(var3_3);
        }
        if (name != null) {
            ctx.setName(name);
        }
        if (ctx.getState() == LifeCycle.State.INITIALIZED) {
            if (configLocation != null || name != null) {
                void var2_2;
                ContextAnchor.THREAD_CONTEXT.set(ctx);
                Configuration config = ConfigurationFactory.getInstance().getConfiguration(ctx, name, configLocation);
                LOGGER.debug("Starting LoggerContext[name={}] from configuration at {}", (Object)ctx.getName(), (Object)configLocation);
                ctx.start((Configuration)var2_2);
                ContextAnchor.THREAD_CONTEXT.remove();
            } else {
                ((AbstractLifeCycle)ctx).start();
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LoggerContext getContext(String fqcn, ClassLoader loader, Map.Entry<String, Object> entry, boolean currentContext, URI configLocation, String name) {
        void var1_1;
        void var3_3;
        LoggerContext ctx = this.selector.getContext(fqcn, loader, (Map.Entry<String, Object>)var3_3, currentContext, configLocation);
        if (name != null) {
            ctx.setName(name);
        }
        if (ctx.getState() == LifeCycle.State.INITIALIZED) {
            if (configLocation != null || name != null) {
                void var2_2;
                ContextAnchor.THREAD_CONTEXT.set(ctx);
                Configuration config = ConfigurationFactory.getInstance().getConfiguration(ctx, name, configLocation);
                LOGGER.debug("Starting LoggerContext[name={}] from configuration at {}", (Object)ctx.getName(), (Object)configLocation);
                ctx.start((Configuration)var2_2);
                ContextAnchor.THREAD_CONTEXT.remove();
            } else {
                ((AbstractLifeCycle)ctx).start();
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LoggerContext getContext(String fqcn, ClassLoader loader, Object externalContext, boolean currentContext, List<URI> configLocations, String name) {
        void var1_1;
        LoggerContext ctx = this.selector.getContext(fqcn, loader, currentContext, null);
        if (externalContext != null && ctx.getExternalContext() == null) {
            ctx.setExternalContext(externalContext);
        }
        if (name != null) {
            ctx.setName(name);
        }
        if (ctx.getState() == LifeCycle.State.INITIALIZED) {
            if (configLocations != null && !configLocations.isEmpty()) {
                ContextAnchor.THREAD_CONTEXT.set(ctx);
                ArrayList<AbstractConfiguration> configurations = new ArrayList<AbstractConfiguration>(configLocations.size());
                for (URI configLocation : configLocations) {
                    Configuration currentReadConfiguration = ConfigurationFactory.getInstance().getConfiguration(ctx, name, configLocation);
                    if (currentReadConfiguration != null) {
                        if (currentReadConfiguration instanceof DefaultConfiguration) {
                            LOGGER.warn("Unable to locate configuration {}, ignoring", (Object)configLocation.toString());
                            continue;
                        }
                        if (currentReadConfiguration instanceof AbstractConfiguration) {
                            configurations.add((AbstractConfiguration)currentReadConfiguration);
                            continue;
                        }
                        LOGGER.error("Found configuration {}, which is not an AbstractConfiguration and can't be handled by CompositeConfiguration", (Object)configLocation);
                        continue;
                    }
                    LOGGER.info("Unable to access configuration {}, ignoring", (Object)configLocation.toString());
                }
                if (configurations.isEmpty()) {
                    LOGGER.error("No configurations could be created for {}", (Object)configLocations.toString());
                } else if (configurations.size() == 1) {
                    AbstractConfiguration config = (AbstractConfiguration)configurations.get(0);
                    LOGGER.debug("Starting LoggerContext[name={}] from configuration at {}", (Object)ctx.getName(), (Object)config.getConfigurationSource().getLocation());
                    ctx.start(config);
                } else {
                    void var3_3;
                    void var2_2;
                    CompositeConfiguration compositeConfiguration = new CompositeConfiguration((List<? extends AbstractConfiguration>)var2_2);
                    LOGGER.debug("Starting LoggerContext[name={}] from configurations at {}", (Object)ctx.getName(), configLocations);
                    ctx.start((Configuration)var3_3);
                }
                ContextAnchor.THREAD_CONTEXT.remove();
            } else {
                ((AbstractLifeCycle)ctx).start();
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void shutdown(String fqcn, ClassLoader loader, boolean currentContext, boolean allContexts) {
        if (this.selector.hasContext(fqcn, loader, currentContext)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.selector.shutdown((String)var1_1, (ClassLoader)var2_2, (boolean)var3_3, allContexts);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasContext(String fqcn, ClassLoader loader, boolean currentContext) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.selector.hasContext((String)var1_1, (ClassLoader)var2_2, (boolean)var3_3);
    }

    public ContextSelector getSelector() {
        return this.selector;
    }

    public ShutdownCallbackRegistry getShutdownCallbackRegistry() {
        return this.shutdownCallbackRegistry;
    }

    /*
     * WARNING - void declaration
     */
    public void removeContext(org.apache.logging.log4j.spi.LoggerContext context) {
        if (context instanceof LoggerContext) {
            void var1_1;
            this.selector.removeContext((LoggerContext)var1_1);
        }
    }

    public boolean isClassLoaderDependent() {
        return this.selector.isClassLoaderDependent();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Cancellable addShutdownCallback(Runnable callback) {
        if (this.isShutdownHookEnabled()) {
            void var1_1;
            return this.shutdownCallbackRegistry.addShutdownCallback((Runnable)var1_1);
        }
        return null;
    }

    public boolean isShutdownHookEnabled() {
        return SHUTDOWN_HOOK_ENABLED;
    }
}

