/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.apache.logging.log4j.util.Strings;
import org.apache.logging.log4j.util.TriConsumer;

public class JdkMapAdapterStringMap
implements StringMap {
    private static final long serialVersionUID = -7348247784983193612L;
    private static final String FROZEN = "Frozen collection cannot be modified";
    private static final Comparator<? super String> NULL_FIRST_COMPARATOR = (left, right) -> {
        void var1_1;
        String string;
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return string.compareTo((String)var1_1);
    };
    private final Map<String, String> map;
    private boolean immutable = false;
    private transient String[] sortedKeys;
    private static TriConsumer<String, String, Map<String, String>> PUT_ALL = (key, value, stringStringMap) -> {
        void var1_1;
        String string;
        String cfr_ignored_0 = (String)stringStringMap.put(string, var1_1);
    };

    public JdkMapAdapterStringMap() {
        this(new HashMap<String, String>());
    }

    /*
     * WARNING - void declaration
     */
    public JdkMapAdapterStringMap(Map<String, String> map) {
        void var1_1;
        this.map = (Map)Objects.requireNonNull(var1_1, "map");
    }

    public Map<String, String> toMap() {
        return this.map;
    }

    private void assertNotFrozen() {
        if (this.immutable) {
            throw new UnsupportedOperationException(FROZEN);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsKey(String key) {
        void var1_1;
        return this.map.containsKey(var1_1);
    }

    public <V> void forEach(BiConsumer<String, ? super V> action) {
        String[] keys = this.getSortedKeys();
        for (int i = 0; i < keys.length; ++i) {
            action.accept((Object)keys[i], (Object)this.map.get(keys[i]));
        }
    }

    public <V, S> void forEach(TriConsumer<String, ? super V, S> action, S state) {
        String[] keys = this.getSortedKeys();
        for (int i = 0; i < keys.length; ++i) {
            action.accept((Object)keys[i], (Object)this.map.get(keys[i]), state);
        }
    }

    private String[] getSortedKeys() {
        if (this.sortedKeys == null) {
            this.sortedKeys = this.map.keySet().toArray(Strings.EMPTY_ARRAY);
            Arrays.sort(this.sortedKeys, NULL_FIRST_COMPARATOR);
        }
        return this.sortedKeys;
    }

    /*
     * WARNING - void declaration
     */
    public <V> V getValue(String key) {
        void var1_1;
        return (V)this.map.get(var1_1);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        if (this.map.isEmpty()) {
            return;
        }
        this.assertNotFrozen();
        this.map.clear();
        this.sortedKeys = null;
    }

    public void freeze() {
        this.immutable = true;
    }

    public boolean isFrozen() {
        return this.immutable;
    }

    /*
     * WARNING - void declaration
     */
    public void putAll(ReadOnlyStringMap source) {
        void var1_1;
        this.assertNotFrozen();
        var1_1.forEach(PUT_ALL, this.map);
        this.sortedKeys = null;
    }

    /*
     * WARNING - void declaration
     */
    public void putValue(String key, Object value) {
        void var2_2;
        void var1_1;
        this.assertNotFrozen();
        this.map.put((String)var1_1, value == null ? null : String.valueOf(var2_2));
        this.sortedKeys = null;
    }

    /*
     * WARNING - void declaration
     */
    public void remove(String key) {
        void var1_1;
        if (!this.map.containsKey(key)) {
            return;
        }
        this.assertNotFrozen();
        this.map.remove(var1_1);
        this.sortedKeys = null;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder result = new StringBuilder(this.map.size() * 13);
        result.append('{');
        String[] keys = this.getSortedKeys();
        for (int i = 0; i < keys.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(keys[i]).append('=').append(this.map.get(keys[i]));
        }
        result.append('}');
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        void var1_1;
        if (object == this) {
            return true;
        }
        if (!(object instanceof JdkMapAdapterStringMap)) {
            return false;
        }
        JdkMapAdapterStringMap other = (JdkMapAdapterStringMap)object;
        return this.map.equals(other.map) && this.immutable == var1_1.immutable;
    }

    public int hashCode() {
        return this.map.hashCode() + (this.immutable ? 31 : 0);
    }
}

