/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.io.Serializable;
import java.util.Objects;
import org.apache.logging.log4j.core.impl.ExtendedClassInfo;
import org.apache.logging.log4j.core.pattern.PlainTextRenderer;
import org.apache.logging.log4j.core.pattern.TextRenderer;

public final class ExtendedStackTraceElement
implements Serializable {
    static final ExtendedStackTraceElement[] EMPTY_ARRAY = new ExtendedStackTraceElement[0];
    private static final long serialVersionUID = -2171069569241280505L;
    private final ExtendedClassInfo extraClassInfo;
    private final StackTraceElement stackTraceElement;

    /*
     * WARNING - void declaration
     */
    public ExtendedStackTraceElement(StackTraceElement stackTraceElement, ExtendedClassInfo extraClassInfo) {
        void var2_2;
        void var1_1;
        this.stackTraceElement = var1_1;
        this.extraClassInfo = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public ExtendedStackTraceElement(String declaringClass, String methodName, String fileName, int lineNumber, boolean exact, String location, String version) {
        this(new StackTraceElement((String)var1_1, (String)var2_2, (String)var3_3, lineNumber), new ExtendedClassInfo(exact, location, version));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtendedStackTraceElement)) {
            return false;
        }
        ExtendedStackTraceElement other = (ExtendedStackTraceElement)obj;
        if (!Objects.equals(this.extraClassInfo, other.extraClassInfo)) {
            return false;
        }
        return Objects.equals(this.stackTraceElement, var1_1.stackTraceElement);
    }

    public final String getClassName() {
        return this.stackTraceElement.getClassName();
    }

    public final boolean getExact() {
        return this.extraClassInfo.getExact();
    }

    public final ExtendedClassInfo getExtraClassInfo() {
        return this.extraClassInfo;
    }

    public final String getFileName() {
        return this.stackTraceElement.getFileName();
    }

    public final int getLineNumber() {
        return this.stackTraceElement.getLineNumber();
    }

    public final String getLocation() {
        return this.extraClassInfo.getLocation();
    }

    public final String getMethodName() {
        return this.stackTraceElement.getMethodName();
    }

    public final StackTraceElement getStackTraceElement() {
        return this.stackTraceElement;
    }

    public final String getVersion() {
        return this.extraClassInfo.getVersion();
    }

    public final int hashCode() {
        return Objects.hash(this.extraClassInfo, this.stackTraceElement);
    }

    public final boolean isNativeMethod() {
        return this.stackTraceElement.isNativeMethod();
    }

    /*
     * WARNING - void declaration
     */
    final void renderOn(StringBuilder output, TextRenderer textRenderer) {
        void var2_2;
        void var1_1;
        ExtendedStackTraceElement extendedStackTraceElement = this;
        extendedStackTraceElement.render(extendedStackTraceElement.stackTraceElement, output, textRenderer);
        textRenderer.render(" ", output, "Text");
        this.extraClassInfo.renderOn((StringBuilder)var1_1, (TextRenderer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void render(StackTraceElement stElement, StringBuilder output, TextRenderer textRenderer) {
        void var2_2;
        void var3_3;
        void var1_1;
        String fileName = stElement.getFileName();
        int lineNumber = stElement.getLineNumber();
        textRenderer.render(this.getClassName(), output, "StackTraceElement.ClassName");
        textRenderer.render(".", output, "StackTraceElement.ClassMethodSeparator");
        textRenderer.render(stElement.getMethodName(), output, "StackTraceElement.MethodName");
        if (var1_1.isNativeMethod()) {
            textRenderer.render("(Native Method)", output, "StackTraceElement.NativeMethod");
            return;
        }
        if (fileName != null && lineNumber >= 0) {
            textRenderer.render("(", output, "StackTraceElement.Container");
            textRenderer.render(fileName, output, "StackTraceElement.FileName");
            textRenderer.render(":", output, "StackTraceElement.ContainerSeparator");
            textRenderer.render(Integer.toString(lineNumber), output, "StackTraceElement.LineNumber");
            textRenderer.render(")", output, "StackTraceElement.Container");
            return;
        }
        if (fileName != null) {
            textRenderer.render("(", output, "StackTraceElement.Container");
            textRenderer.render(fileName, output, "StackTraceElement.FileName");
            textRenderer.render(")", output, "StackTraceElement.Container");
            return;
        }
        textRenderer.render("(", output, "StackTraceElement.Container");
        textRenderer.render("Unknown Source", output, "StackTraceElement.UnknownSource");
        var3_3.render(")", (StringBuilder)var2_2, "StackTraceElement.Container");
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        this.renderOn(sb, PlainTextRenderer.getInstance());
        return var1_1.toString();
    }
}

