/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.MapFilter;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.apache.logging.log4j.util.IndexedReadOnlyStringMap;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.StringBuilders;

@Plugin(name="StructuredDataFilter", category="Core", elementType="filter", printObject=true)
@PerformanceSensitive(value={"allocation"})
public final class StructuredDataFilter
extends MapFilter {
    private static final int MAX_BUFFER_SIZE = 2048;
    private static ThreadLocal<StringBuilder> threadLocalStringBuilder = new ThreadLocal();

    /*
     * WARNING - void declaration
     */
    private StructuredDataFilter(Map<String, List<String>> map, boolean oper, Filter.Result onMatch, Filter.Result onMismatch) {
        super((Map<String, List<String>>)var1_1, (boolean)var2_2, (Filter.Result)var3_3, onMismatch);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        if (msg instanceof StructuredDataMessage) {
            return this.filter((StructuredDataMessage)msg);
        }
        return Filter.Result.NEUTRAL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(LogEvent event) {
        void var1_1;
        Message msg = event.getMessage();
        if (msg instanceof StructuredDataMessage) {
            void var2_2;
            return this.filter((StructuredDataMessage)var2_2);
        }
        return super.filter((LogEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected final Filter.Result filter(StructuredDataMessage message) {
        boolean bl;
        boolean match = false;
        IndexedReadOnlyStringMap map = this.getStringMap();
        for (int i = 0; i < map.size(); ++i) {
            void var2_3;
            StringBuilder toMatch = this.getValue(message, map.getKeyAt(i));
            bl = toMatch != null ? this.listContainsValue((List)map.getValueAt(i), (StringBuilder)var2_3) : false;
            if (!this.isAnd() && bl || this.isAnd() && !bl) break;
        }
        if (bl) {
            return this.onMatch;
        }
        return this.onMismatch;
    }

    /*
     * WARNING - void declaration
     */
    private StringBuilder getValue(StructuredDataMessage data, String key) {
        void var3_3;
        void var2_2;
        void var1_1;
        StringBuilder sb = this.getStringBuilder();
        if (key.equalsIgnoreCase("id")) {
            data.getId().formatTo(sb);
            return sb;
        }
        if (key.equalsIgnoreCase("id.name")) {
            return this.appendOrNull(data.getId().getName(), sb);
        }
        if (key.equalsIgnoreCase("type")) {
            return this.appendOrNull(data.getType(), sb);
        }
        if (key.equalsIgnoreCase("message")) {
            data.formatTo(sb);
            return sb;
        }
        return this.appendOrNull(var1_1.get((String)var2_2), (StringBuilder)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private StringBuilder getStringBuilder() {
        void var1_1;
        StringBuilder result = threadLocalStringBuilder.get();
        if (result == null) {
            result = new StringBuilder();
            threadLocalStringBuilder.set(result);
        }
        StringBuilders.trimToMaxSize((StringBuilder)result, (int)2048);
        result.setLength(0);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private StringBuilder appendOrNull(String value, StringBuilder sb) {
        void var2_2;
        void var1_1;
        if (value == null) {
            return null;
        }
        sb.append((String)var1_1);
        return var2_2;
    }

    private boolean listContainsValue(List<String> candidates, StringBuilder toMatch) {
        if (toMatch == null) {
            for (int i = 0; i < candidates.size(); ++i) {
                String string = candidates.get(i);
                if (string != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < candidates.size(); ++i) {
                String candidate = candidates.get(i);
                if (candidate == null) {
                    return false;
                }
                if (!StringBuilders.equals((CharSequence)candidate, (int)0, (int)candidate.length(), (CharSequence)toMatch, (int)0, (int)toMatch.length())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static StructuredDataFilter createFilter(@PluginElement(value="Pairs") KeyValuePair[] pairs, @PluginAttribute(value="operator") String oper, @PluginAttribute(value="onMatch") Filter.Result match, @PluginAttribute(value="onMismatch") Filter.Result mismatch) {
        void var3_4;
        void var2_3;
        void var0_1;
        void var1_2;
        if (pairs == null || pairs.length == 0) {
            LOGGER.error("keys and values must be specified for the StructuredDataFilter");
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (KeyValuePair pair : pairs) {
            String key = pair.getKey();
            if (key == null) {
                LOGGER.error("A null key is not valid in MapFilter");
                continue;
            }
            String value = pair.getValue();
            if (value == null) {
                LOGGER.error("A null value for key " + key + " is not allowed in MapFilter");
                continue;
            }
            ArrayList<String> list = (ArrayList<String>)map.get(pair.getKey());
            if (list != null) {
                list.add(value);
                continue;
            }
            list = new ArrayList<String>();
            list.add(value);
            map.put(pair.getKey(), list);
        }
        if (map.isEmpty()) {
            LOGGER.error("StructuredDataFilter is not configured with any valid key value pairs");
            return null;
        }
        boolean isAnd = oper == null || !var1_2.equalsIgnoreCase("or");
        return new StructuredDataFilter(map, (boolean)var0_1, (Filter.Result)var2_3, (Filter.Result)var3_4);
    }
}

