/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.Map;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.script.ScriptRef;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="ScriptFilter", category="Core", elementType="filter", printObject=true)
public final class ScriptFilter
extends AbstractFilter {
    private static Logger logger = StatusLogger.getLogger();
    private final AbstractScript script;
    private final Configuration configuration;

    /*
     * WARNING - void declaration
     */
    private ScriptFilter(AbstractScript script, Configuration configuration, Filter.Result onMatch, Filter.Result onMismatch) {
        super((Filter.Result)var3_3, onMismatch);
        void var2_2;
        void var1_1;
        void var3_3;
        this.script = var1_1;
        this.configuration = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object ... params) {
        void var1_1;
        void var3_3;
        void var2_2;
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("logger", (Object)logger);
        bindings.put("level", (Object)var2_2);
        bindings.put("marker", (Object)var3_3);
        bindings.put("message", (Object)new SimpleMessage(msg));
        bindings.put("parameters", (Object)params);
        bindings.put("throwable", (Object)null);
        bindings.putAll((Map<? extends String, ? extends Object>)this.configuration.getProperties());
        bindings.put("substitutor", (Object)this.configuration.getStrSubstitutor());
        Object object = this.configuration.getScriptManager().execute(this.script.getName(), bindings);
        if (object == null || !Boolean.TRUE.equals(var1_1)) {
            return this.onMismatch;
        }
        return this.onMatch;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        void var1_1;
        void var3_3;
        void var2_2;
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("logger", (Object)logger);
        bindings.put("level", (Object)var2_2);
        bindings.put("marker", (Object)var3_3);
        bindings.put("message", msg instanceof String ? new SimpleMessage((String)msg) : new ObjectMessage(msg));
        bindings.put("parameters", (Object)null);
        bindings.put("throwable", (Object)t);
        bindings.putAll((Map<? extends String, ? extends Object>)this.configuration.getProperties());
        bindings.put("substitutor", (Object)this.configuration.getStrSubstitutor());
        Object object = this.configuration.getScriptManager().execute(this.script.getName(), bindings);
        if (object == null || !Boolean.TRUE.equals(var1_1)) {
            return this.onMismatch;
        }
        return this.onMatch;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        void var1_1;
        void var3_3;
        void var2_2;
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("logger", (Object)logger);
        bindings.put("level", (Object)var2_2);
        bindings.put("marker", (Object)var3_3);
        bindings.put("message", (Object)msg);
        bindings.put("parameters", (Object)null);
        bindings.put("throwable", (Object)t);
        bindings.putAll((Map<? extends String, ? extends Object>)this.configuration.getProperties());
        bindings.put("substitutor", (Object)this.configuration.getStrSubstitutor());
        Object object = this.configuration.getScriptManager().execute(this.script.getName(), bindings);
        if (object == null || !Boolean.TRUE.equals(var1_1)) {
            return this.onMismatch;
        }
        return this.onMatch;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(LogEvent event) {
        void var1_1;
        void var2_2;
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("logEvent", (Object)event);
        bindings.putAll((Map<? extends String, ? extends Object>)this.configuration.getProperties());
        bindings.put("substitutor", (Object)this.configuration.getStrSubstitutor());
        Object object = this.configuration.getScriptManager().execute(this.script.getName(), (Bindings)var2_2);
        if (object == null || !Boolean.TRUE.equals(var1_1)) {
            return this.onMismatch;
        }
        return this.onMatch;
    }

    @Override
    public final String toString() {
        return this.script.getName();
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static ScriptFilter createFilter(@PluginElement(value="Script") AbstractScript script, @PluginAttribute(value="onMatch") Filter.Result match, @PluginAttribute(value="onMismatch") Filter.Result mismatch, @PluginConfiguration Configuration configuration) {
        void var2_2;
        void var1_1;
        void var3_3;
        AbstractScript abstractScript;
        if (script == null) {
            LOGGER.error("A Script, ScriptFile or ScriptRef element must be provided for this ScriptFilter");
            return null;
        }
        if (configuration.getScriptManager() == null) {
            LOGGER.error("Script support is not enabled");
            return null;
        }
        if (script instanceof ScriptRef) {
            if (configuration.getScriptManager().getScript(script.getName()) == null) {
                logger.error("No script with name {} has been declared.", (Object)script.getName());
                return null;
            }
        } else if (!configuration.getScriptManager().addScript(script)) {
            return null;
        }
        return new ScriptFilter(abstractScript, (Configuration)var3_3, (Filter.Result)var1_1, (Filter.Result)var2_2);
    }
}

