/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;

@Plugin(name="RegexFilter", category="Core", elementType="filter", printObject=true)
public final class RegexFilter
extends AbstractFilter {
    private static final int DEFAULT_PATTERN_FLAGS = 0;
    private final Pattern pattern;
    private final boolean useRawMessage;

    /*
     * WARNING - void declaration
     */
    private RegexFilter(boolean raw, Pattern pattern, Filter.Result onMatch, Filter.Result onMismatch) {
        super((Filter.Result)var3_3, onMismatch);
        void var1_1;
        void var2_2;
        void var3_3;
        this.pattern = var2_2;
        this.useRawMessage = var1_1;
    }

    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        if (this.useRawMessage || params == null || params.length == 0) {
            return this.filter(msg);
        }
        return this.filter(ParameterizedMessage.format((String)msg, (Object[])params));
    }

    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        if (msg == null) {
            return this.onMismatch;
        }
        return this.filter(msg.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        void var1_1;
        if (msg == null) {
            return this.onMismatch;
        }
        String text = this.useRawMessage ? msg.getFormat() : msg.getFormattedMessage();
        return this.filter((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(LogEvent event) {
        void var1_1;
        String text = this.useRawMessage ? event.getMessage().getFormat() : event.getMessage().getFormattedMessage();
        return this.filter((String)var1_1);
    }

    private Filter.Result filter(String msg) {
        Matcher matcher;
        if (msg == null) {
            return this.onMismatch;
        }
        if ((matcher = this.pattern.matcher((CharSequence)((Object)matcher))).matches()) {
            return this.onMatch;
        }
        return this.onMismatch;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        sb.append("useRaw=").append(this.useRawMessage);
        sb.append(", pattern=").append(this.pattern.toString());
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static RegexFilter createFilter(@PluginAttribute(value="regex") String regex, @PluginElement(value="PatternFlags") String[] patternFlags, @PluginAttribute(value="useRawMsg") Boolean useRawMsg, @PluginAttribute(value="onMatch") Filter.Result match, @PluginAttribute(value="onMismatch") Filter.Result mismatch) throws IllegalArgumentException, IllegalAccessException {
        void var3_3;
        void var1_1;
        String string;
        void var2_2;
        if (regex == null) {
            LOGGER.error("A regular expression must be provided for RegexFilter");
            return null;
        }
        return new RegexFilter(var2_2.booleanValue(), Pattern.compile(string, RegexFilter.toPatternFlags((String[])var1_1)), (Filter.Result)var3_3, mismatch);
    }

    /*
     * WARNING - void declaration
     */
    private static int toPatternFlags(String[] patternFlags) throws IllegalArgumentException, IllegalAccessException {
        void var3_3;
        String[] stringArray;
        if (patternFlags == null || patternFlags.length == 0) {
            return 0;
        }
        Field[] fields = Pattern.class.getDeclaredFields();
        Comparator comparator = (f1, f2) -> {
            void var1_1;
            return f1.getName().compareTo(var1_1.getName());
        };
        Arrays.sort(fields, comparator);
        Object[] fieldNames = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldNames[i] = fields[i].getName();
        }
        int flags = 0;
        for (String test : stringArray) {
            int index = Arrays.binarySearch(fieldNames, test);
            if (index < 0) continue;
            Field field = fields[index];
            flags |= field.getInt(Pattern.class);
        }
        return (int)var3_3;
    }
}

