/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationScheduler;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAliases;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.filter.ThreadContextMapFilter;
import org.apache.logging.log4j.core.filter.mutable.KeyValuePairConfig;
import org.apache.logging.log4j.core.util.AuthorizationProvider;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.core.util.Source;
import org.apache.logging.log4j.core.util.internal.HttpInputStreamUtil;
import org.apache.logging.log4j.core.util.internal.LastModifiedSource;
import org.apache.logging.log4j.core.util.internal.Status;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.PropertiesUtil;

@Plugin(name="MutableThreadContextMapFilter", category="Core", elementType="filter", printObject=true)
@PluginAliases(value={"MutableContextMapFilter"})
@PerformanceSensitive(value={"allocation"})
public class MutableThreadContextMapFilter
extends AbstractFilter {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final KeyValuePair[] EMPTY_ARRAY = new KeyValuePair[0];
    private volatile Filter filter;
    private final long pollInterval;
    private final ConfigurationScheduler scheduler;
    private final LastModifiedSource source;
    private final AuthorizationProvider authorizationProvider;
    private final List<FilterConfigUpdateListener> listeners = new ArrayList<FilterConfigUpdateListener>();
    private ScheduledFuture<?> future = null;

    /*
     * WARNING - void declaration
     */
    private MutableThreadContextMapFilter(Filter filter, LastModifiedSource source, long pollInterval, AuthorizationProvider authorizationProvider, Filter.Result onMatch, Filter.Result onMismatch, Configuration configuration) {
        super(onMatch, onMismatch);
        void var2_2;
        void var3_3;
        void var1_1;
        this.filter = var1_1;
        this.pollInterval = var3_3;
        this.source = var2_2;
        this.scheduler = configuration.getScheduler();
        this.authorizationProvider = authorizationProvider;
    }

    @Override
    public void start() {
        if (this.pollInterval > 0L) {
            this.future = this.scheduler.scheduleWithFixedDelay(new FileMonitor(), 0L, this.pollInterval, TimeUnit.SECONDS);
            LOGGER.debug("Watching {} with poll interval {}", (Object)this.source.toString(), (Object)this.pollInterval);
        }
        super.start();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        void var3_2;
        void var1_1;
        this.future.cancel(true);
        return super.stop((long)var1_1, (TimeUnit)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public void registerListener(FilterConfigUpdateListener listener) {
        void var1_1;
        this.listeners.add((FilterConfigUpdateListener)var1_1);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Filter.Result filter(LogEvent event) {
        void var1_1;
        return this.filter.filter((LogEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.filter.filter((Logger)var1_1, (Level)var2_2, (Marker)var3_3, msg, t);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.filter.filter((Logger)var1_1, (Level)var2_2, (Marker)var3_3, msg, t);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.filter.filter((Logger)var1_1, (Level)var2_2, (Marker)var3_3, msg, params);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.filter.filter((Logger)var1_1, (Level)var2_2, (Marker)var3_3, msg, p0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.filter.filter((Logger)var1_1, (Level)var2_2, (Marker)var3_3, msg, p0, p1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.filter.filter((Logger)var1_1, (Level)var2_2, (Marker)var3_3, msg, p0, p1, p2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.filter.filter((Logger)var1_1, (Level)var2_2, (Marker)var3_3, msg, p0, p1, p2, p3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.filter.filter((Logger)var1_1, (Level)var2_2, (Marker)var3_3, msg, p0, p1, p2, p3, p4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.filter.filter((Logger)var1_1, (Level)var2_2, (Marker)var3_3, msg, p0, p1, p2, p3, p4, p5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.filter.filter((Logger)var1_1, (Level)var2_2, (Marker)var3_3, msg, p0, p1, p2, p3, p4, p5, p6);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.filter.filter((Logger)var1_1, (Level)var2_2, (Marker)var3_3, msg, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.filter.filter((Logger)var1_1, (Level)var2_2, (Marker)var3_3, msg, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.filter.filter((Logger)var1_1, (Level)var2_2, (Marker)var3_3, msg, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    private static LastModifiedSource getSource(String configLocation) {
        LastModifiedSource source;
        URI uRI;
        try {
            uRI = new URI(configLocation);
            source = uRI.getScheme() != null ? new LastModifiedSource(new URI(configLocation)) : new LastModifiedSource(new File(configLocation));
        }
        catch (Exception exception) {
            String string;
            source = new LastModifiedSource(new File(string));
        }
        return uRI;
    }

    private static ConfigResult getConfig(LastModifiedSource source, AuthorizationProvider authorizationProvider) {
        ConfigResult configResult;
        block22: {
            Iterator iterator;
            HttpInputStreamUtil.Result result;
            InputStream inputStream;
            block21: {
                File inputFile = source.getFile();
                inputStream = null;
                long lastModified = source.getLastModified();
                if (inputFile != null && inputFile.exists()) {
                    try {
                        long modified = inputFile.lastModified();
                        if (modified > lastModified) {
                            source.setLastModified(modified);
                            inputStream = new FileInputStream(inputFile);
                            result = new HttpInputStreamUtil.Result(Status.SUCCESS);
                            break block21;
                        }
                        result = new HttpInputStreamUtil.Result(Status.NOT_MODIFIED);
                    }
                    catch (Exception exception) {
                        result = new HttpInputStreamUtil.Result(Status.ERROR);
                    }
                } else if (source.getURI() != null) {
                    try {
                        result = HttpInputStreamUtil.getInputStream(source, (AuthorizationProvider)((Object)result));
                        inputStream = result.getInputStream();
                    }
                    catch (ConfigurationException configurationException) {
                        result = new HttpInputStreamUtil.Result(Status.ERROR);
                    }
                } else {
                    result = new HttpInputStreamUtil.Result(Status.NOT_FOUND);
                }
            }
            configResult = new ConfigResult();
            if (result.getStatus() == Status.SUCCESS) {
                LOGGER.debug("Processing Debug key/value pairs from: {}", (Object)source.toString());
                try {
                    KeyValuePairConfig keyValuePairConfig = (KeyValuePairConfig)MAPPER.readValue(inputStream, KeyValuePairConfig.class);
                    if (keyValuePairConfig != null) {
                        ArrayList arrayList;
                        Map<String, String[]> configs = keyValuePairConfig.getConfigs();
                        if (configs != null && configs.size() > 0) {
                            ArrayList pairs = new ArrayList();
                            for (Map.Entry entry : iterator.entrySet()) {
                                String[] stringArray;
                                String key = (String)entry.getKey();
                                for (String value : (String[])stringArray.getValue()) {
                                    if (value != null) {
                                        pairs.add(new KeyValuePair(key, value));
                                        continue;
                                    }
                                    LOGGER.warn("Ignoring null value for {}", (Object)key);
                                }
                            }
                            if (pairs.size() > 0) {
                                configResult.pairs = arrayList.toArray(EMPTY_ARRAY);
                                configResult.status = Status.SUCCESS;
                            } else {
                                configResult.status = Status.EMPTY;
                            }
                        } else {
                            LOGGER.debug("No configuration data in {}", (Object)((Source)((Object)arrayList)).toString());
                            configResult.status = Status.EMPTY;
                        }
                        break block22;
                    }
                    LOGGER.warn("No configs element in MutableThreadContextMapFilter configuration");
                    configResult.status = Status.ERROR;
                }
                catch (Exception ex) {
                    LOGGER.warn("Invalid key/value pair configuration, input ignored: {}", (Object)ex.getMessage());
                    configResult.status = Status.ERROR;
                }
            } else {
                configResult.status = ((HttpInputStreamUtil.Result)((Object)iterator)).getStatus();
            }
        }
        return configResult;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ConfigResult access$300(LastModifiedSource x0, AuthorizationProvider x1) {
        void var1_1;
        return MutableThreadContextMapFilter.getConfig(x0, (AuthorizationProvider)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Filter access$702(MutableThreadContextMapFilter x0, Filter x1) {
        void var1_1;
        x0.filter = var1_1;
        return x0.filter;
    }

    private static class ConfigResult
    extends HttpInputStreamUtil.Result {
        public KeyValuePair[] pairs;
        public Status status;

        private ConfigResult() {
        }
    }

    public static interface FilterConfigUpdateListener {
        public void onEvent();
    }

    private static class NoOpFilter
    extends AbstractFilter {
        public NoOpFilter() {
            Filter.Result result = Filter.Result.NEUTRAL;
            super(result, result);
        }
    }

    private class FileMonitor
    implements Runnable {
        private FileMonitor() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            void var1_1;
            Iterator result = MutableThreadContextMapFilter.access$300(MutableThreadContextMapFilter.this.source, MutableThreadContextMapFilter.this.authorizationProvider);
            if (((ConfigResult)((Object)result)).status == Status.SUCCESS) {
                MutableThreadContextMapFilter.access$702(MutableThreadContextMapFilter.this, ThreadContextMapFilter.createFilter(((ConfigResult)((Object)result)).pairs, "or", MutableThreadContextMapFilter.this.getOnMatch(), MutableThreadContextMapFilter.this.getOnMismatch()));
                LOGGER.info("Filter configuration was updated: {}", (Object)MutableThreadContextMapFilter.this.filter.toString());
                for (FilterConfigUpdateListener filterConfigUpdateListener : MutableThreadContextMapFilter.this.listeners) {
                    filterConfigUpdateListener.onEvent();
                }
                return;
            }
            if (((ConfigResult)((Object)result)).status == Status.NOT_FOUND) {
                if (!(MutableThreadContextMapFilter.this.filter instanceof NoOpFilter)) {
                    LOGGER.info("Filter configuration was removed");
                    MutableThreadContextMapFilter.access$702(MutableThreadContextMapFilter.this, new NoOpFilter());
                    for (FilterConfigUpdateListener filterConfigUpdateListener : MutableThreadContextMapFilter.this.listeners) {
                        filterConfigUpdateListener.onEvent();
                    }
                    return;
                }
            } else if (var1_1.status == Status.EMPTY) {
                LOGGER.debug("Filter configuration is empty");
                MutableThreadContextMapFilter.access$702(MutableThreadContextMapFilter.this, new NoOpFilter());
            }
        }
    }

    public static class Builder
    extends AbstractFilter.AbstractFilterBuilder<Builder>
    implements org.apache.logging.log4j.core.util.Builder<MutableThreadContextMapFilter> {
        @PluginBuilderAttribute
        private String configLocation;
        @PluginBuilderAttribute
        private long pollInterval;
        @PluginConfiguration
        private Configuration configuration;

        /*
         * WARNING - void declaration
         */
        public Builder setConfiguration(Configuration configuration) {
            void var1_1;
            this.configuration = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setPollInterval(long pollInterval) {
            void var1_1;
            this.pollInterval = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setConfigLocation(String configLocation) {
            void var1_1;
            this.configLocation = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public MutableThreadContextMapFilter build() {
            void var2_2;
            void var1_1;
            void var3_3;
            AbstractFilter filter;
            LastModifiedSource source = MutableThreadContextMapFilter.getSource(this.configLocation);
            if (source == null) {
                return new MutableThreadContextMapFilter(new NoOpFilter(), null, 0L, null, this.getOnMatch(), this.getOnMismatch(), this.configuration);
            }
            AuthorizationProvider authorizationProvider = ConfigurationFactory.authorizationProvider(PropertiesUtil.getProperties());
            if (this.pollInterval <= 0L) {
                ConfigResult result = MutableThreadContextMapFilter.access$300(source, authorizationProvider);
                if (result.status == Status.SUCCESS) {
                    filter = result.pairs.length > 0 ? ThreadContextMapFilter.createFilter(result.pairs, "or", this.getOnMatch(), this.getOnMismatch()) : new NoOpFilter();
                } else if (((ConfigResult)((Object)filter)).status == Status.NOT_FOUND || ((ConfigResult)((Object)filter)).status == Status.EMPTY) {
                    filter = new NoOpFilter();
                } else {
                    LOGGER.warn("Unexpected response returned on initial call: {}", (Object)((ConfigResult)((Object)filter)).status);
                    filter = new NoOpFilter();
                }
            } else {
                filter = new NoOpFilter();
            }
            if (this.pollInterval > 0L) {
                this.configuration.getScheduler().incrementScheduledItems();
            }
            return new MutableThreadContextMapFilter((Filter)var3_3, (LastModifiedSource)var1_1, this.pollInterval, (AuthorizationProvider)var2_2, this.getOnMatch(), this.getOnMismatch(), this.configuration);
        }
    }
}

