/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.IndexedReadOnlyStringMap;
import org.apache.logging.log4j.util.IndexedStringMap;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.SortedArrayStringMap;

@Plugin(name="MapFilter", category="Core", elementType="filter", printObject=true)
@PerformanceSensitive(value={"allocation"})
public class MapFilter
extends AbstractFilter {
    private final IndexedStringMap map;
    private final boolean isAnd;

    /*
     * WARNING - void declaration
     */
    protected MapFilter(Map<String, List<String>> map, boolean oper, Filter.Result onMatch, Filter.Result onMismatch) {
        super((Filter.Result)var3_4, onMismatch);
        Iterator iterator;
        void var3_4;
        this.isAnd = oper;
        Objects.requireNonNull(map, "map cannot be null");
        this.map = new SortedArrayStringMap(map.size());
        for (Map.Entry entry : iterator.entrySet()) {
            void var2_3;
            this.map.putValue((String)entry.getKey(), var2_3.getValue());
        }
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        if (msg instanceof MapMessage) {
            if (this.filter((MapMessage)msg)) {
                return this.onMatch;
            }
            return this.onMismatch;
        }
        return Filter.Result.NEUTRAL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Filter.Result filter(LogEvent event) {
        Message msg = event.getMessage();
        if (msg instanceof MapMessage) {
            void var1_1;
            if (this.filter((MapMessage)var1_1)) {
                return this.onMatch;
            }
            return this.onMismatch;
        }
        return Filter.Result.NEUTRAL;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean filter(MapMessage<?, ?> mapMessage) {
        boolean bl;
        boolean match = false;
        for (int i = 0; i < this.map.size(); ++i) {
            void var2_3;
            String toMatch = mapMessage.get(this.map.getKeyAt(i));
            boolean bl2 = bl = toMatch != null && ((List)this.map.getValueAt(i)).contains(var2_3);
            if (!this.isAnd && bl || this.isAnd && !bl) break;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean filter(Map<String, String> data) {
        boolean bl;
        boolean match = false;
        for (int i = 0; i < this.map.size(); ++i) {
            void var2_3;
            String toMatch = data.get(this.map.getKeyAt(i));
            boolean bl2 = bl = toMatch != null && ((List)this.map.getValueAt(i)).contains(var2_3);
            if (!this.isAnd && bl || this.isAnd && !bl) break;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean filter(ReadOnlyStringMap data) {
        boolean bl;
        boolean match = false;
        for (int i = 0; i < this.map.size(); ++i) {
            void var2_3;
            String toMatch = (String)data.getValue(this.map.getKeyAt(i));
            boolean bl2 = bl = toMatch != null && ((List)this.map.getValueAt(i)).contains(var2_3);
            if (!this.isAnd && bl || this.isAnd && !bl) break;
        }
        return bl;
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0) {
        return Filter.Result.NEUTRAL;
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1) {
        return Filter.Result.NEUTRAL;
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2) {
        return Filter.Result.NEUTRAL;
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3) {
        return Filter.Result.NEUTRAL;
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return Filter.Result.NEUTRAL;
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return Filter.Result.NEUTRAL;
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return Filter.Result.NEUTRAL;
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return Filter.Result.NEUTRAL;
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return Filter.Result.NEUTRAL;
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return Filter.Result.NEUTRAL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        sb.append("isAnd=").append(this.isAnd);
        if (this.map.size() > 0) {
            sb.append(", {");
            for (int i = 0; i < this.map.size(); ++i) {
                void var3_3;
                List list;
                if (i > 0) {
                    sb.append(", ");
                }
                String value = (list = (List)this.map.getValueAt(i)).size() > 1 ? (String)list.get(0) : list.toString();
                sb.append(this.map.getKeyAt(i)).append('=').append((String)var3_3);
            }
            sb.append('}');
        }
        return var1_1.toString();
    }

    protected boolean isAnd() {
        return this.isAnd;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected Map<String, List<String>> getMap() {
        void var1_1;
        HashMap result = new HashMap(this.map.size());
        this.map.forEach((key, value) -> {
            void var2_2;
            void var1_1;
            result.put(var1_1, (List)var2_2);
        });
        return var1_1;
    }

    protected IndexedReadOnlyStringMap getStringMap() {
        return this.map;
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static MapFilter createFilter(@PluginElement(value="Pairs") KeyValuePair[] pairs, @PluginAttribute(value="operator") String oper, @PluginAttribute(value="onMatch") Filter.Result match, @PluginAttribute(value="onMismatch") Filter.Result mismatch) {
        void var3_4;
        void var2_3;
        void var0_1;
        void var1_2;
        if (pairs == null || pairs.length == 0) {
            LOGGER.error("keys and values must be specified for the MapFilter");
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (KeyValuePair pair : pairs) {
            String key = pair.getKey();
            if (key == null) {
                LOGGER.error("A null key is not valid in MapFilter");
                continue;
            }
            String value = pair.getValue();
            if (value == null) {
                LOGGER.error("A null value for key " + key + " is not allowed in MapFilter");
                continue;
            }
            ArrayList<String> list = (ArrayList<String>)map.get(pair.getKey());
            if (list != null) {
                list.add(value);
                continue;
            }
            list = new ArrayList<String>();
            list.add(value);
            map.put(pair.getKey(), list);
        }
        if (map.isEmpty()) {
            LOGGER.error("MapFilter is not configured with any valid key value pairs");
            return null;
        }
        boolean isAnd = oper == null || !var1_2.equalsIgnoreCase("or");
        return new MapFilter(map, (boolean)var0_1, (Filter.Result)var2_3, (Filter.Result)var3_4);
    }
}

