/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Plugin(name="LevelRangeFilter", category="Core", elementType="filter", printObject=true)
@PerformanceSensitive(value={"allocation"})
public final class LevelRangeFilter
extends AbstractFilter {
    private final Level maxLevel;
    private final Level minLevel;

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static LevelRangeFilter createFilter(@PluginAttribute(value="minLevel") Level minLevel, @PluginAttribute(value="maxLevel") Level maxLevel, @PluginAttribute(value="onMatch") Filter.Result match, @PluginAttribute(value="onMismatch") Filter.Result mismatch) {
        void var3_3;
        void var2_2;
        void var1_1;
        Level level;
        Filter.Result onMismatch;
        Filter.Result onMatch;
        Level actualMaxLevel;
        Level actualMinLevel;
        actualMinLevel = minLevel == null ? Level.ERROR : actualMinLevel;
        actualMaxLevel = maxLevel == null ? Level.ERROR : actualMaxLevel;
        onMatch = match == null ? Filter.Result.NEUTRAL : onMatch;
        onMismatch = mismatch == null ? Filter.Result.DENY : onMismatch;
        return new LevelRangeFilter(level, (Level)var1_1, (Filter.Result)var2_2, (Filter.Result)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private LevelRangeFilter(Level minLevel, Level maxLevel, Filter.Result onMatch, Filter.Result onMismatch) {
        super((Filter.Result)var3_3, onMismatch);
        void var2_2;
        void var1_1;
        void var3_3;
        this.minLevel = var1_1;
        this.maxLevel = var2_2;
    }

    private Filter.Result filter(Level level) {
        if (level.isInRange(this.minLevel, this.maxLevel)) {
            return this.onMatch;
        }
        return this.onMismatch;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(LogEvent event) {
        void var1_1;
        return this.filter(var1_1.getLevel());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    public final Level getMinLevel() {
        return this.minLevel;
    }

    public final Level getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    public final String toString() {
        return this.minLevel.toString();
    }
}

