/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.impl.ContextDataInjectorFactory;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StringMap;

@Plugin(name="DynamicThresholdFilter", category="Core", elementType="filter", printObject=true)
@PerformanceSensitive(value={"allocation"})
public final class DynamicThresholdFilter
extends AbstractFilter {
    private Level defaultThreshold = Level.ERROR;
    private final String key;
    private final ContextDataInjector injector = ContextDataInjectorFactory.createInjector();
    private Map<String, Level> levelMap = new HashMap<String, Level>();

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static DynamicThresholdFilter createFilter(@PluginAttribute(value="key") String key, @PluginElement(value="Pairs") KeyValuePair[] pairs, @PluginAttribute(value="defaultThreshold") Level defaultThreshold, @PluginAttribute(value="onMatch") Filter.Result onMatch, @PluginAttribute(value="onMismatch") Filter.Result onMismatch) {
        void var3_3;
        void var1_1;
        String string;
        void var2_2;
        HashMap<String, Level> map = new HashMap<String, Level>();
        for (KeyValuePair pair : pairs) {
            map.put(pair.getKey(), Level.toLevel((String)pair.getValue()));
        }
        Level level = defaultThreshold == null ? Level.ERROR : var2_2;
        return new DynamicThresholdFilter(string, map, (Level)var1_1, (Filter.Result)var3_3, onMismatch);
    }

    /*
     * WARNING - void declaration
     */
    private DynamicThresholdFilter(String key, Map<String, Level> pairs, Level defaultLevel, Filter.Result onMatch, Filter.Result onMismatch) {
        super(onMatch, onMismatch);
        void var3_3;
        void var2_2;
        void var1_1;
        StringMap map = ContextDataFactory.createContextData();
        LOGGER.debug("Successfully initialized ContextDataFactory by retrieving the context data with {} entries", (Object)map.size());
        Objects.requireNonNull(key, "key cannot be null");
        this.key = var1_1;
        this.levelMap = var2_2;
        this.defaultThreshold = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (!super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DynamicThresholdFilter other = (DynamicThresholdFilter)obj;
        if (!Objects.equals(this.defaultThreshold, other.defaultThreshold)) {
            return false;
        }
        if (!Objects.equals(this.key, other.key)) {
            return false;
        }
        return Objects.equals(this.levelMap, var1_1.levelMap);
    }

    /*
     * WARNING - void declaration
     */
    private Filter.Result filter(Level level, ReadOnlyStringMap contextMap) {
        String value = (String)contextMap.getValue(this.key);
        if (value != null) {
            void var2_2;
            void var1_1;
            Level ctxLevel = this.levelMap.get(value);
            if (ctxLevel == null) {
                ctxLevel = this.defaultThreshold;
            }
            if (var1_1.isMoreSpecificThan((Level)var2_2)) {
                return this.onMatch;
            }
            return this.onMismatch;
        }
        return Filter.Result.NEUTRAL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(LogEvent event) {
        void var1_1;
        return this.filter(event.getLevel(), var1_1.getContextData());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        void var2_2;
        return this.filter((Level)var2_2, this.currentContextData());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        void var2_2;
        return this.filter((Level)var2_2, this.currentContextData());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        void var2_2;
        return this.filter((Level)var2_2, this.currentContextData());
    }

    private ReadOnlyStringMap currentContextData() {
        return this.injector.rawContextData();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0) {
        void var2_2;
        return this.filter((Level)var2_2, this.currentContextData());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1) {
        void var2_2;
        return this.filter((Level)var2_2, this.currentContextData());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2) {
        void var2_2;
        return this.filter((Level)var2_2, this.currentContextData());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3) {
        void var2_2;
        return this.filter((Level)var2_2, this.currentContextData());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var2_2;
        return this.filter((Level)var2_2, this.currentContextData());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var2_2;
        return this.filter((Level)var2_2, this.currentContextData());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var2_2;
        return this.filter((Level)var2_2, this.currentContextData());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var2_2;
        return this.filter((Level)var2_2, this.currentContextData());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var2_2;
        return this.filter((Level)var2_2, this.currentContextData());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var2_2;
        return this.filter((Level)var2_2, this.currentContextData());
    }

    public final String getKey() {
        return this.key;
    }

    public final Map<String, Level> getLevelMap() {
        return this.levelMap;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int result = super.hashCodeImpl();
        result = result * 31 + (this.defaultThreshold == null ? 0 : this.defaultThreshold.hashCode());
        result = result * 31 + (this.key == null ? 0 : this.key.hashCode());
        var1_1 = var1_1 * 31 + (this.levelMap == null ? 0 : this.levelMap.hashCode());
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        sb.append("key=").append(this.key);
        sb.append(", default=").append(this.defaultThreshold);
        if (this.levelMap.size() > 0) {
            sb.append('{');
            for (Map.Entry<String, Level> entry : this.levelMap.entrySet()) {
                void var3_3;
                sb.append(entry.getKey()).append('=').append(var3_3.getValue());
            }
            sb.append('}');
        }
        return var1_1.toString();
    }
}

