/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LifeCycle2;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.util.ObjectArrayIterator;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Plugin(name="filters", category="Core", printObject=true)
@PerformanceSensitive(value={"allocation"})
public final class CompositeFilter
extends AbstractLifeCycle
implements Iterable<Filter>,
Filter {
    private final Filter[] filters;

    private CompositeFilter() {
        this.filters = Filter.EMPTY_ARRAY;
    }

    /*
     * WARNING - void declaration
     */
    private CompositeFilter(Filter[] filters) {
        void var1_1;
        this.filters = filters == null ? Filter.EMPTY_ARRAY : var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final CompositeFilter addFilter(Filter filter) {
        void var2_3;
        void var1_1;
        if (filter == null) {
            return this;
        }
        if (filter instanceof CompositeFilter) {
            CompositeFilter compositeFilter = (CompositeFilter)filter;
            Filter[] copy = Arrays.copyOf(this.filters, this.filters.length + compositeFilter.size());
            System.arraycopy(compositeFilter.filters, 0, copy, this.filters.length, compositeFilter.filters.length);
            return new CompositeFilter((Filter[])var1_1);
        }
        Filter[] filterArray = Arrays.copyOf(this.filters, this.filters.length + 1);
        Filter[] copy = filterArray;
        filterArray[this.filters.length] = var1_1;
        return new CompositeFilter((Filter[])var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public final CompositeFilter removeFilter(Filter filter) {
        void var2_2;
        if (filter == null) {
            return this;
        }
        ArrayList<Filter> filterList = new ArrayList<Filter>(Arrays.asList(this.filters));
        if (filter instanceof CompositeFilter) {
            filter = ((CompositeFilter)filter).filters;
            int n = ((CompositeFilter)filter).filters.length;
            for (int i = 0; i < n; ++i) {
                Filter currentFilter = filter[i];
                filterList.remove(currentFilter);
            }
        } else {
            void var1_1;
            filterList.remove(var1_1);
        }
        return new CompositeFilter(var2_2.toArray(Filter.EMPTY_ARRAY));
    }

    @Override
    public final Iterator<Filter> iterator() {
        return new ObjectArrayIterator<Filter>(this.filters);
    }

    @Deprecated
    public final List<Filter> getFilters() {
        return Arrays.asList(this.filters);
    }

    public final Filter[] getFiltersArray() {
        return this.filters;
    }

    public final boolean isEmpty() {
        return this.filters.length == 0;
    }

    public final int size() {
        return this.filters.length;
    }

    @Override
    public final void start() {
        this.setStarting();
        Filter[] filterArray = this.filters;
        int n = this.filters.length;
        for (int i = 0; i < n; ++i) {
            Filter filter = filterArray[i];
            filter.start();
        }
        this.setStarted();
    }

    @Override
    public final boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        Filter[] filterArray = this.filters;
        int n = this.filters.length;
        for (int i = 0; i < n; ++i) {
            Filter filter = filterArray[i];
            if (filter instanceof LifeCycle2) {
                ((LifeCycle2)((Object)filter)).stop(timeout, timeUnit);
                continue;
            }
            filter.stop();
        }
        this.setStopped();
        return true;
    }

    @Override
    public final Filter.Result getOnMismatch() {
        return Filter.Result.NEUTRAL;
    }

    @Override
    public final Filter.Result getOnMatch() {
        return Filter.Result.NEUTRAL;
    }

    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        Filter.Result result = Filter.Result.NEUTRAL;
        for (int i = 0; i < this.filters.length; ++i) {
            result = this.filters[i].filter(logger, level, marker, msg, params);
            if (result != Filter.Result.ACCEPT && result != Filter.Result.DENY) continue;
            return result;
        }
        return result;
    }

    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0) {
        Filter.Result result = Filter.Result.NEUTRAL;
        for (int i = 0; i < this.filters.length; ++i) {
            result = this.filters[i].filter(logger, level, marker, msg, p0);
            if (result != Filter.Result.ACCEPT && result != Filter.Result.DENY) continue;
            return result;
        }
        return result;
    }

    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1) {
        Filter.Result result = Filter.Result.NEUTRAL;
        for (int i = 0; i < this.filters.length; ++i) {
            result = this.filters[i].filter(logger, level, marker, msg, p0, p1);
            if (result != Filter.Result.ACCEPT && result != Filter.Result.DENY) continue;
            return result;
        }
        return result;
    }

    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2) {
        Filter.Result result = Filter.Result.NEUTRAL;
        for (int i = 0; i < this.filters.length; ++i) {
            result = this.filters[i].filter(logger, level, marker, msg, p0, p1, p2);
            if (result != Filter.Result.ACCEPT && result != Filter.Result.DENY) continue;
            return result;
        }
        return result;
    }

    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3) {
        Filter.Result result = Filter.Result.NEUTRAL;
        for (int i = 0; i < this.filters.length; ++i) {
            result = this.filters[i].filter(logger, level, marker, msg, p0, p1, p2, p3);
            if (result != Filter.Result.ACCEPT && result != Filter.Result.DENY) continue;
            return result;
        }
        return result;
    }

    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4) {
        Filter.Result result = Filter.Result.NEUTRAL;
        for (int i = 0; i < this.filters.length; ++i) {
            result = this.filters[i].filter(logger, level, marker, msg, p0, p1, p2, p3, p4);
            if (result != Filter.Result.ACCEPT && result != Filter.Result.DENY) continue;
            return result;
        }
        return result;
    }

    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        Filter.Result result = Filter.Result.NEUTRAL;
        for (int i = 0; i < this.filters.length; ++i) {
            result = this.filters[i].filter(logger, level, marker, msg, p0, p1, p2, p3, p4, p5);
            if (result != Filter.Result.ACCEPT && result != Filter.Result.DENY) continue;
            return result;
        }
        return result;
    }

    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        Filter.Result result = Filter.Result.NEUTRAL;
        for (int i = 0; i < this.filters.length; ++i) {
            result = this.filters[i].filter(logger, level, marker, msg, p0, p1, p2, p3, p4, p5, p6);
            if (result != Filter.Result.ACCEPT && result != Filter.Result.DENY) continue;
            return result;
        }
        return result;
    }

    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        Filter.Result result = Filter.Result.NEUTRAL;
        for (int i = 0; i < this.filters.length; ++i) {
            result = this.filters[i].filter(logger, level, marker, msg, p0, p1, p2, p3, p4, p5, p6, p7);
            if (result != Filter.Result.ACCEPT && result != Filter.Result.DENY) continue;
            return result;
        }
        return result;
    }

    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        Filter.Result result = Filter.Result.NEUTRAL;
        for (int i = 0; i < this.filters.length; ++i) {
            result = this.filters[i].filter(logger, level, marker, msg, p0, p1, p2, p3, p4, p5, p6, p7, p8);
            if (result != Filter.Result.ACCEPT && result != Filter.Result.DENY) continue;
            return result;
        }
        return result;
    }

    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        Filter.Result result = Filter.Result.NEUTRAL;
        for (int i = 0; i < this.filters.length; ++i) {
            result = this.filters[i].filter(logger, level, marker, msg, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
            if (result != Filter.Result.ACCEPT && result != Filter.Result.DENY) continue;
            return result;
        }
        return result;
    }

    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        Filter.Result result = Filter.Result.NEUTRAL;
        for (int i = 0; i < this.filters.length; ++i) {
            result = this.filters[i].filter(logger, level, marker, msg, t);
            if (result != Filter.Result.ACCEPT && result != Filter.Result.DENY) continue;
            return result;
        }
        return result;
    }

    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        Filter.Result result = Filter.Result.NEUTRAL;
        for (int i = 0; i < this.filters.length; ++i) {
            result = this.filters[i].filter(logger, level, marker, msg, t);
            if (result != Filter.Result.ACCEPT && result != Filter.Result.DENY) continue;
            return result;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(LogEvent event) {
        void var2_2;
        Filter.Result result = Filter.Result.NEUTRAL;
        for (int i = 0; i < this.filters.length; ++i) {
            result = this.filters[i].filter(event);
            if (result != Filter.Result.ACCEPT && result != Filter.Result.DENY) continue;
            return result;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.filters.length; ++i) {
            if (sb.length() == 0) {
                sb.append('{');
            } else {
                sb.append(", ");
            }
            sb.append(this.filters[i].toString());
        }
        if (sb.length() > 0) {
            sb.append('}');
        }
        return var1_1.toString();
    }

    @PluginFactory
    public static CompositeFilter createFilters(@PluginElement(value="Filters") Filter[] filters) {
        Filter[] filterArray;
        return new CompositeFilter(filterArray);
    }
}

