/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;

@Plugin(name="BurstFilter", category="Core", elementType="filter", printObject=true)
public final class BurstFilter
extends AbstractFilter {
    private static final long NANOS_IN_SECONDS = 1000000000L;
    private static final int DEFAULT_RATE = 10;
    private static final int DEFAULT_RATE_MULTIPLE = 100;
    private static final int HASH_SHIFT = 32;
    private final Level level;
    private final long burstInterval;
    private final DelayQueue<LogDelay> history = new DelayQueue();
    private final Queue<LogDelay> available = new ConcurrentLinkedQueue<LogDelay>();

    static LogDelay createLogDelay(long expireTime) {
        long l;
        return new LogDelay(l);
    }

    /*
     * WARNING - void declaration
     */
    private BurstFilter(Level level, float rate, long maxBurst, Filter.Result onMatch, Filter.Result onMismatch) {
        super(onMatch, onMismatch);
        void var2_3;
        this.level = level;
        this.burstInterval = (long)(1.0E9f * ((float)maxBurst / var2_3));
        int i = 0;
        while ((long)i < maxBurst) {
            this.available.add(BurstFilter.createLogDelay(0L));
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(LogEvent event) {
        void var1_1;
        return this.filter(var1_1.getLevel());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var2_2;
        return this.filter((Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Filter.Result filter(Level level) {
        if (this.level.isMoreSpecificThan(level)) {
            LogDelay delay = (LogDelay)this.history.poll();
            while (delay != null) {
                this.available.add(delay);
                delay = (LogDelay)this.history.poll();
            }
            delay = this.available.poll();
            if (delay != null) {
                void var1_1;
                delay.setDelay(this.burstInterval);
                this.history.add((LogDelay)var1_1);
                return this.onMatch;
            }
            return this.onMismatch;
        }
        return this.onMatch;
    }

    public final int getAvailable() {
        return this.available.size();
    }

    /*
     * WARNING - void declaration
     */
    public final void clear() {
        for (LogDelay delay : this.history) {
            void var2_2;
            this.history.remove(delay);
            this.available.add((LogDelay)var2_2);
        }
    }

    @Override
    public final String toString() {
        return "level=" + this.level.toString() + ", interval=" + this.burstInterval + ", max=" + this.history.size();
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractFilter.AbstractFilterBuilder<Builder>
    implements org.apache.logging.log4j.core.util.Builder<BurstFilter> {
        @PluginBuilderAttribute
        private Level level = Level.WARN;
        @PluginBuilderAttribute
        private float rate = 10.0f;
        @PluginBuilderAttribute
        private long maxBurst;

        /*
         * WARNING - void declaration
         */
        public Builder setLevel(Level level) {
            void var1_1;
            this.level = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setRate(float rate) {
            void var1_1;
            this.rate = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setMaxBurst(long maxBurst) {
            void var1_1;
            this.maxBurst = var1_1;
            return this;
        }

        @Override
        public BurstFilter build() {
            if (this.rate <= 0.0f) {
                this.rate = 10.0f;
            }
            if (this.maxBurst <= 0L) {
                this.maxBurst = (long)(this.rate * 100.0f);
            }
            return new BurstFilter(this.level, this.rate, this.maxBurst, this.getOnMatch(), this.getOnMismatch());
        }
    }

    private static class LogDelay
    implements Delayed {
        private long expireTime;

        /*
         * WARNING - void declaration
         */
        LogDelay(long expireTime) {
            void var1_1;
            this.expireTime = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setDelay(long delay) {
            void var1_1;
            this.expireTime = var1_1 + System.nanoTime();
        }

        @Override
        public long getDelay(TimeUnit timeUnit) {
            return timeUnit.convert(this.expireTime - System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(Delayed delayed) {
            void var1_1;
            long l = this.expireTime - ((LogDelay)var1_1).expireTime;
            return Long.signum(l);
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o) {
            void var1_1;
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogDelay logDelay = (LogDelay)o;
            return this.expireTime == var1_1.expireTime;
        }

        public int hashCode() {
            return (int)(this.expireTime ^ this.expireTime >>> 32);
        }
    }
}

