/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LifeCycle2;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.filter.CompositeFilter;
import org.apache.logging.log4j.core.filter.Filterable;

public abstract class AbstractFilterable
extends AbstractLifeCycle
implements Filterable {
    private volatile Filter filter;
    @PluginElement(value="Properties")
    private final Property[] propertyArray;

    protected AbstractFilterable() {
        this(null, Property.EMPTY_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractFilterable(Filter filter) {
        this((Filter)var1_1, Property.EMPTY_ARRAY);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractFilterable(Filter filter, Property[] propertyArray) {
        void var2_2;
        void var1_1;
        this.filter = var1_1;
        this.propertyArray = propertyArray == null ? Property.EMPTY_ARRAY : var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void addFilter(Filter filter) {
        void var1_1;
        if (filter == null) {
            return;
        }
        if (this.filter == null) {
            this.filter = filter;
            return;
        }
        if (this.filter instanceof CompositeFilter) {
            this.filter = ((CompositeFilter)this.filter).addFilter(filter);
            return;
        }
        Filter[] filters = new Filter[]{this.filter, filter};
        this.filter = CompositeFilter.createFilters((Filter[])var1_1);
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public boolean hasFilter() {
        return this.filter != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isFiltered(LogEvent event) {
        void var1_1;
        return this.filter != null && this.filter.filter((LogEvent)var1_1) == Filter.Result.DENY;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void removeFilter(Filter filter) {
        if (this.filter == null || filter == null) {
            return;
        }
        if (this.filter == filter || this.filter.equals(filter)) {
            this.filter = null;
            return;
        }
        if (this.filter instanceof CompositeFilter) {
            CompositeFilter compositeFilter = (CompositeFilter)this.filter;
            CompositeFilter composite = compositeFilter.removeFilter(filter);
            if (composite.size() > 1) {
                this.filter = composite;
                return;
            }
            if (composite.size() == 1) {
                void var1_1;
                Iterator<Filter> iter = compositeFilter.iterator();
                this.filter = (Filter)var1_1.next();
                return;
            }
            this.filter = null;
        }
    }

    @Override
    public void start() {
        this.setStarting();
        if (this.filter != null) {
            this.filter.start();
        }
        this.setStarted();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        void var3_2;
        void var1_1;
        return this.stop((long)var1_1, (TimeUnit)var3_2, true);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean stop(long timeout, TimeUnit timeUnit, boolean changeLifeCycleState) {
        if (changeLifeCycleState) {
            this.setStopping();
        }
        boolean stopped = true;
        if (this.filter != null) {
            if (this.filter instanceof LifeCycle2) {
                void var3_2;
                void var1_1;
                stopped = ((LifeCycle2)((Object)this.filter)).stop((long)var1_1, (TimeUnit)var3_2);
            } else {
                this.filter.stop();
                stopped = true;
            }
        }
        if (changeLifeCycleState) {
            this.setStopped();
        }
        return stopped;
    }

    public Property[] getPropertyArray() {
        return this.propertyArray;
    }

    public static abstract class Builder<B extends Builder<B>> {
        @PluginElement(value="Filter")
        private Filter filter;
        @PluginElement(value="Properties")
        private Property[] propertyArray;

        public B asBuilder() {
            return (B)this;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public Property[] getPropertyArray() {
            return this.propertyArray;
        }

        /*
         * WARNING - void declaration
         */
        public B setFilter(Filter filter) {
            void var1_1;
            this.filter = var1_1;
            return this.asBuilder();
        }

        /*
         * WARNING - void declaration
         */
        public B setPropertyArray(Property[] properties) {
            void var1_1;
            this.propertyArray = var1_1;
            return this.asBuilder();
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public B withFilter(Filter filter) {
            void var1_1;
            return this.setFilter((Filter)var1_1);
        }
    }
}

