/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.config.plugins.util.ResolverUtil;
import org.apache.logging.log4j.core.config.status.StatusConfiguration;
import org.apache.logging.log4j.core.util.Closer;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.Patterns;
import org.apache.logging.log4j.core.util.Throwables;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlConfiguration
extends AbstractConfiguration
implements Reconfigurable {
    private static final String XINCLUDE_FIXUP_LANGUAGE = "http://apache.org/xml/features/xinclude/fixup-language";
    private static final String XINCLUDE_FIXUP_BASE_URIS = "http://apache.org/xml/features/xinclude/fixup-base-uris";
    private static final String[] VERBOSE_CLASSES = new String[]{ResolverUtil.class.getName()};
    private static final String LOG4J_XSD = "Log4j-config.xsd";
    private final List<Status> status;
    private Element rootElement;
    private boolean strict;
    private String schemaResource;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XmlConfiguration(LoggerContext loggerContext, ConfigurationSource configSource) {
        void var2_3;
        block36: {
            super(loggerContext, configSource);
            this.status = new ArrayList<Status>();
            configSource.getFile();
            byte[] buffer = null;
            try {
                Object document;
                InputStream configStream = configSource.getInputStream();
                try {
                    buffer = XmlConfiguration.toByteArray(configStream);
                }
                finally {
                    Closer.closeSilently(configStream);
                }
                InputSource inputSource = new InputSource(new ByteArrayInputStream(buffer));
                inputSource.setSystemId(configSource.getLocation());
                DocumentBuilder documentBuilder = XmlConfiguration.newDocumentBuilder(true);
                try {
                    document = documentBuilder.parse(inputSource);
                }
                catch (Exception exception) {
                    Exception e = exception;
                    document = Throwables.getRootCause(exception);
                    if (!(document instanceof UnsupportedOperationException)) throw e;
                    LOGGER.warn("The DocumentBuilder {} does not support an operation: {}.Trying again without XInclude...", (Object)documentBuilder, (Object)e);
                    document = XmlConfiguration.newDocumentBuilder(false).parse(inputSource);
                }
                this.rootElement = document.getDocumentElement();
                XmlConfiguration xmlConfiguration = this;
                Map<String, String> attrs = xmlConfiguration.processAttributes(xmlConfiguration.rootNode, this.rootElement);
                StatusConfiguration statusConfig = new StatusConfiguration().withVerboseClasses(VERBOSE_CLASSES).withStatus(this.getDefaultStatus());
                int monitorIntervalSeconds = 0;
                for (Map.Entry entry : attrs.entrySet()) {
                    String key = (String)entry.getKey();
                    String string = this.getConfigurationStrSubstitutor().replace((String)entry.getValue());
                    if ("status".equalsIgnoreCase(key)) {
                        statusConfig.withStatus(string);
                        continue;
                    }
                    if ("dest".equalsIgnoreCase(key)) {
                        statusConfig.withDestination(string);
                        continue;
                    }
                    if ("shutdownHook".equalsIgnoreCase(key)) {
                        this.isShutdownHookEnabled = !"disable".equalsIgnoreCase(string);
                        continue;
                    }
                    if ("shutdownTimeout".equalsIgnoreCase(key)) {
                        this.shutdownTimeoutMillis = Long.parseLong(string);
                        continue;
                    }
                    if ("verbose".equalsIgnoreCase(key)) {
                        statusConfig.withVerbosity(string);
                        continue;
                    }
                    if ("packages".equalsIgnoreCase(key)) {
                        this.pluginPackages.addAll(Arrays.asList(string.split(Patterns.COMMA_SEPARATOR)));
                        continue;
                    }
                    if ("name".equalsIgnoreCase(key)) {
                        this.setName(string);
                        continue;
                    }
                    if ("strict".equalsIgnoreCase(key)) {
                        this.strict = Boolean.parseBoolean(string);
                        continue;
                    }
                    if ("schema".equalsIgnoreCase(key)) {
                        this.schemaResource = string;
                        continue;
                    }
                    if ("monitorInterval".equalsIgnoreCase(key)) {
                        monitorIntervalSeconds = Integers.parseInt(string);
                        continue;
                    }
                    if (!"advertiser".equalsIgnoreCase(key)) continue;
                    this.createAdvertiser(string, configSource, buffer, "text/xml");
                }
                XmlConfiguration xmlConfiguration2 = this;
                xmlConfiguration2.initializeWatchers(xmlConfiguration2, configSource, monitorIntervalSeconds);
                statusConfig.initialize();
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                LOGGER.error("Error parsing " + configSource.getLocation(), (Throwable)e);
            }
            if (this.strict && this.schemaResource != null && buffer != null) {
                try {
                    InputStream is2 = Loader.getResourceAsStream(this.schemaResource, XmlConfiguration.class.getClassLoader());
                    Throwable throwable = null;
                    try {
                        if (is2 != null) {
                            StreamSource src = new StreamSource(is2, LOG4J_XSD);
                            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                            Schema schema = null;
                            try {
                                schema = factory.newSchema(src);
                            }
                            catch (SAXException ex) {
                                LOGGER.error("Error parsing Log4j schema", (Throwable)ex);
                            }
                            if (schema != null) {
                                Validator validator = schema.newValidator();
                                try {
                                    void var1_1;
                                    validator.validate(new StreamSource(new ByteArrayInputStream((byte[])var1_1)));
                                }
                                catch (IOException ioe) {
                                    LOGGER.error("Error reading configuration for validation", (Throwable)ioe);
                                }
                                catch (SAXException ex) {
                                    LOGGER.error("Error validating configuration", (Throwable)ex);
                                }
                            }
                        }
                        if (is2 == null) break block36;
                    }
                    catch (Throwable throwable2) {
                        try {
                            Throwable throwable3 = throwable2;
                            Throwable throwable4 = throwable2;
                            throw throwable3;
                        }
                        catch (Throwable throwable5) {
                            if (is2 == null) throw throwable5;
                            if (throwable == null) {
                                is2.close();
                                throw throwable5;
                            }
                            try {
                                is2.close();
                                throw throwable5;
                            }
                            catch (Throwable is2) {
                                throwable.addSuppressed(is2);
                                throw throwable5;
                            }
                        }
                    }
                    is2.close();
                }
                catch (Exception ex) {
                    void var3_7;
                    LOGGER.error("Unable to access schema {}", (Object)this.schemaResource, (Object)var3_7);
                }
            }
        }
        if (this.getName() != null) return;
        this.setName(var2_3.getLocation());
    }

    /*
     * WARNING - void declaration
     */
    static DocumentBuilder newDocumentBuilder(boolean xIncludeAware) throws ParserConfigurationException {
        void var1_1;
        boolean bl;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        XmlConfiguration.disableDtdProcessing(factory);
        if (bl) {
            XmlConfiguration.enableXInclude(factory);
        }
        return var1_1.newDocumentBuilder();
    }

    private static void disableDtdProcessing(DocumentBuilderFactory factory) {
        DocumentBuilderFactory documentBuilderFactory;
        factory.setValidating(false);
        factory.setExpandEntityReferences(false);
        XmlConfiguration.setFeature(factory, "http://xml.org/sax/features/external-general-entities", false);
        XmlConfiguration.setFeature(factory, "http://xml.org/sax/features/external-parameter-entities", false);
        XmlConfiguration.setFeature(documentBuilderFactory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
    }

    /*
     * WARNING - void declaration
     */
    private static void setFeature(DocumentBuilderFactory factory, String featureName, boolean value) {
        try {
            factory.setFeature(featureName, value);
            return;
        }
        catch (ParserConfigurationException e) {
            void var1_1;
            LOGGER.warn("The DocumentBuilderFactory [{}] does not support the feature [{}]: {}", (Object)factory, (Object)var1_1, (Object)e);
            return;
        }
        catch (AbstractMethodError err) {
            void var2_4;
            DocumentBuilderFactory documentBuilderFactory;
            LOGGER.warn("The DocumentBuilderFactory [{}] is out of date and does not support setFeature: {}", (Object)documentBuilderFactory, (Object)var2_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void enableXInclude(DocumentBuilderFactory factory) {
        DocumentBuilderFactory documentBuilderFactory;
        try {
            factory.setXIncludeAware(true);
            factory.newDocumentBuilder();
        }
        catch (UnsupportedOperationException | ParserConfigurationException e) {
            factory.setXIncludeAware(false);
            LOGGER.warn("The DocumentBuilderFactory [{}] does not support XInclude: {}", (Object)factory, (Object)e);
        }
        catch (AbstractMethodError | NoSuchMethodError err) {
            void var1_2;
            LOGGER.warn("The DocumentBuilderFactory [{}] is out of date and does not support XInclude: {}", (Object)factory, (Object)var1_2);
        }
        XmlConfiguration.setFeature(factory, XINCLUDE_FIXUP_BASE_URIS, true);
        XmlConfiguration.setFeature(documentBuilderFactory, XINCLUDE_FIXUP_LANGUAGE, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setup() {
        if (this.rootElement == null) {
            LOGGER.error("No logging configuration");
            return;
        }
        XmlConfiguration xmlConfiguration = this;
        xmlConfiguration.constructHierarchy(xmlConfiguration.rootNode, this.rootElement);
        if (this.status.size() > 0) {
            for (Status s : this.status) {
                void var2_2;
                LOGGER.error("Error processing element {} ({}): {}", (Object)s.name, (Object)s.element, (Object)((Status)var2_2).errorType);
            }
            return;
        }
        this.rootElement = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Configuration reconfigure() {
        try {
            ConfigurationSource source = this.getConfigurationSource().resetInputStream();
            if (source == null) {
                return null;
            }
            XmlConfiguration config = new XmlConfiguration(this.getLoggerContext(), source);
            if (config.rootElement == null) {
                return null;
            }
            return config;
        }
        catch (IOException ex) {
            void var1_2;
            LOGGER.error("Cannot locate file {}", (Object)this.getConfigurationSource(), (Object)var1_2);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void constructHierarchy(Node node, Element element) {
        void var3_3;
        this.processAttributes(node, element);
        StringBuilder buffer = new StringBuilder();
        NodeList list = element.getChildNodes();
        List<Node> children = node.getChildren();
        for (int i = 0; i < list.getLength(); ++i) {
            String value;
            org.w3c.dom.Node w3cNode = list.item(i);
            if (w3cNode instanceof Element) {
                Element child = (Element)w3cNode;
                String name = this.getType(child);
                PluginType<?> type = this.pluginManager.getPluginType(name);
                Node childNode = new Node(node, name, type);
                this.constructHierarchy(childNode, child);
                if (type == null) {
                    value = childNode.getValue();
                    if (!childNode.hasChildren() && value != null) {
                        node.getAttributes().put(name, value);
                        continue;
                    }
                    this.status.add(new Status(name, element, ErrorType.CLASS_NOT_FOUND));
                    continue;
                }
                children.add(childNode);
                continue;
            }
            if (!(value instanceof Text)) continue;
            Text data = (Text)((Object)value);
            buffer.append(data.getData());
        }
        String text = var3_3.toString().trim();
        if (text.length() > 0 || !node.hasChildren() && !node.isRoot()) {
            void var1_1;
            var1_1.setValue(text);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getType(Element element) {
        void var1_1;
        if (this.strict) {
            NamedNodeMap attrs = element.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr;
                org.w3c.dom.Node w3cNode = attrs.item(i);
                if (!(w3cNode instanceof Attr) || !(attr = (Attr)w3cNode).getName().equalsIgnoreCase("type")) continue;
                String type = attr.getValue();
                attrs.removeNamedItem(attr.getName());
                return var1_1;
            }
        }
        return var1_1.getTagName();
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> processAttributes(Node node, Element element) {
        void var1_1;
        NamedNodeMap attrs = element.getAttributes();
        Map<String, String> attributes = node.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr;
            org.w3c.dom.Node w3cNode = attrs.item(i);
            if (!(w3cNode instanceof Attr) || (attr = (Attr)w3cNode).getName().equals("xml:base")) continue;
            attributes.put(attr.getName(), attr.getValue());
        }
        return var1_1;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[location=" + this.getConfigurationSource() + "]";
    }

    private static class Status {
        private final Element element;
        private final String name;
        private final ErrorType errorType;

        /*
         * WARNING - void declaration
         */
        public Status(String name, Element element, ErrorType errorType) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.name = var1_1;
            this.element = var2_2;
            this.errorType = var3_3;
        }

        public String toString() {
            return "Status [name=" + this.name + ", element=" + this.element + ", errorType=" + (Object)((Object)this.errorType) + "]";
        }
    }

    private static enum ErrorType {
        CLASS_NOT_FOUND;

    }
}

