/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.status;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.status.StatusConsoleListener;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;

public class StatusConfiguration {
    private static final PrintStream DEFAULT_STREAM = System.out;
    private static final Level DEFAULT_STATUS = Level.ERROR;
    private static final Verbosity DEFAULT_VERBOSITY = Verbosity.QUIET;
    private final Collection<String> errorMessages = new LinkedBlockingQueue<String>();
    private final StatusLogger logger = StatusLogger.getLogger();
    private volatile boolean initialized;
    private PrintStream destination = DEFAULT_STREAM;
    private Level status = DEFAULT_STATUS;
    private Verbosity verbosity = DEFAULT_VERBOSITY;
    private String[] verboseClasses;

    /*
     * WARNING - void declaration
     */
    public void error(String message) {
        void var1_1;
        if (!this.initialized) {
            this.errorMessages.add(message);
            return;
        }
        this.logger.error((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public StatusConfiguration withDestination(String destination) {
        try {
            this.destination = this.parseStreamName(destination);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.error("Could not parse URI [" + destination + "]. Falling back to default of stdout.");
            this.destination = DEFAULT_STREAM;
        }
        catch (FileNotFoundException fileNotFoundException) {
            void var1_1;
            this.error("File could not be found at [" + (String)var1_1 + "]. Falling back to default of stdout.");
            this.destination = DEFAULT_STREAM;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private PrintStream parseStreamName(String name) throws URISyntaxException, FileNotFoundException {
        void var1_1;
        if (name == null || ((String)name).equalsIgnoreCase("out")) {
            return DEFAULT_STREAM;
        }
        if (((String)name).equalsIgnoreCase("err")) {
            return System.err;
        }
        File output = FileUtils.fileFromUri((URI)(name = NetUtils.toURI((String)name)));
        if (output == null) {
            return DEFAULT_STREAM;
        }
        FileOutputStream fos = new FileOutputStream(output);
        return new PrintStream((OutputStream)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public StatusConfiguration withStatus(String status) {
        this.status = Level.toLevel((String)status, null);
        if (this.status == null) {
            void var1_1;
            this.error("Invalid status level specified: " + (String)var1_1 + ". Defaulting to ERROR.");
            this.status = Level.ERROR;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StatusConfiguration withStatus(Level status) {
        void var1_1;
        this.status = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StatusConfiguration withVerbosity(String verbosity) {
        void var1_1;
        this.verbosity = Verbosity.toVerbosity((String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StatusConfiguration withVerboseClasses(String ... verboseClasses) {
        void var1_1;
        this.verboseClasses = var1_1;
        return this;
    }

    public void initialize() {
        if (!this.initialized) {
            if (this.status == Level.OFF) {
                this.initialized = true;
                return;
            }
            boolean bl = this.configureExistingStatusConsoleListener();
            if (!bl) {
                this.registerNewStatusConsoleListener();
            }
            this.migrateSavedLogMessages();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean configureExistingStatusConsoleListener() {
        boolean bl;
        boolean configured = false;
        for (StatusListener statusListener : this.logger.getListeners()) {
            void var3_4;
            if (!(statusListener instanceof StatusConsoleListener)) continue;
            StatusConsoleListener listener = (StatusConsoleListener)var3_4;
            listener.setLevel(this.status);
            this.logger.updateListenerLevel(this.status);
            if (this.verbosity == Verbosity.QUIET) {
                void var1_2;
                var1_2.setFilters(this.verboseClasses);
            }
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private void registerNewStatusConsoleListener() {
        void var1_1;
        StatusConsoleListener listener = new StatusConsoleListener(this.status, this.destination);
        if (this.verbosity == Verbosity.QUIET) {
            listener.setFilters(this.verboseClasses);
        }
        this.logger.registerListener((StatusListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void migrateSavedLogMessages() {
        for (String message : this.errorMessages) {
            void var2_2;
            this.logger.error((String)var2_2);
        }
        this.initialized = true;
        this.errorMessages.clear();
    }

    public static enum Verbosity {
        QUIET,
        VERBOSE;


        public static Verbosity toVerbosity(String value) {
            if (Boolean.parseBoolean(value)) {
                return VERBOSE;
            }
            return QUIET;
        }
    }
}

