/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.properties;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.AppenderRefComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.FilterComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.FilterableComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggableComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ScriptComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ScriptFileComponentBuilder;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.core.util.Builder;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Strings;

public class PropertiesConfigurationBuilder
extends ConfigurationBuilderFactory
implements Builder<PropertiesConfiguration> {
    private static final String ADVERTISER_KEY = "advertiser";
    private static final String STATUS_KEY = "status";
    private static final String SHUTDOWN_HOOK = "shutdownHook";
    private static final String SHUTDOWN_TIMEOUT = "shutdownTimeout";
    private static final String VERBOSE = "verbose";
    private static final String DEST = "dest";
    private static final String PACKAGES = "packages";
    private static final String CONFIG_NAME = "name";
    private static final String MONITOR_INTERVAL = "monitorInterval";
    private static final String CONFIG_TYPE = "type";
    private final ConfigurationBuilder<PropertiesConfiguration> builder = PropertiesConfigurationBuilder.newConfigurationBuilder(PropertiesConfiguration.class);
    private LoggerContext loggerContext;
    private Properties rootProperties;

    /*
     * WARNING - void declaration
     */
    public PropertiesConfigurationBuilder setRootProperties(Properties rootProperties) {
        void var1_1;
        this.rootProperties = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public PropertiesConfigurationBuilder setConfigurationSource(ConfigurationSource source) {
        void var1_1;
        this.builder.setConfigurationSource((ConfigurationSource)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PropertiesConfiguration build() {
        String string;
        String string2;
        String string3;
        for (String string4 : this.rootProperties.stringPropertyNames()) {
            if (string4.contains(".")) continue;
            this.builder.addRootProperty(string4, this.rootProperties.getProperty(string4));
        }
        this.builder.setStatusLevel(Level.toLevel((String)this.rootProperties.getProperty(STATUS_KEY), (Level)Level.ERROR)).setShutdownHook(this.rootProperties.getProperty(SHUTDOWN_HOOK)).setShutdownTimeout(Long.parseLong(this.rootProperties.getProperty(SHUTDOWN_TIMEOUT, "0")), TimeUnit.MILLISECONDS).setVerbosity(this.rootProperties.getProperty(VERBOSE)).setDestination(this.rootProperties.getProperty(DEST)).setPackages(this.rootProperties.getProperty(PACKAGES)).setConfigurationName(this.rootProperties.getProperty(CONFIG_NAME)).setMonitorInterval(this.rootProperties.getProperty(MONITOR_INTERVAL, "0")).setAdvertiser(this.rootProperties.getProperty(ADVERTISER_KEY));
        Properties properties = PropertiesUtil.extractSubset((Properties)this.rootProperties, (String)"property");
        for (String string5 : properties.stringPropertyNames()) {
            this.builder.addProperty(string5, properties.getProperty(string5));
        }
        Map map = PropertiesUtil.partitionOnCommonPrefixes((Properties)PropertiesUtil.extractSubset((Properties)this.rootProperties, (String)"script"));
        for (Map.Entry entry : map.entrySet()) {
            Properties properties2 = (Properties)entry.getValue();
            String string6 = (String)properties2.remove(CONFIG_TYPE);
            if (string6 == null) {
                throw new ConfigurationException("No type provided for script - must be Script or ScriptFile");
            }
            if (string6.equalsIgnoreCase("script")) {
                this.builder.add(this.createScript(properties2));
                continue;
            }
            this.builder.add(this.createScriptFile(properties2));
        }
        Properties properties3 = PropertiesUtil.extractSubset((Properties)this.rootProperties, (String)"customLevel");
        if (properties3.size() > 0) {
            for (String string7 : properties3.stringPropertyNames()) {
                this.builder.add(this.builder.newCustomLevel(string7, Integers.parseInt(properties3.getProperty(string7))));
            }
        }
        if ((string3 = this.rootProperties.getProperty("filters")) != null) {
            void var3_45;
            String[] stringArray;
            String[] stringArray2 = stringArray = string3.split(",");
            int n = stringArray.length;
            boolean bl = false;
            while (var3_45 < n) {
                String string8 = stringArray2[var3_45];
                String name2 = string8.trim();
                this.builder.add(this.createFilter(name2, PropertiesUtil.extractSubset((Properties)this.rootProperties, (String)("filter." + name2))));
                ++var3_45;
            }
        } else {
            Map map2 = PropertiesUtil.partitionOnCommonPrefixes((Properties)PropertiesUtil.extractSubset((Properties)this.rootProperties, (String)"filter"));
            for (Map.Entry entry : map2.entrySet()) {
                this.builder.add(this.createFilter(((String)entry.getKey()).trim(), (Properties)entry.getValue()));
            }
        }
        if ((string2 = this.rootProperties.getProperty("appenders")) != null) {
            void var4_54;
            String[] stringArray;
            String[] stringArray3 = stringArray = string2.split(",");
            int n = stringArray.length;
            boolean bl = false;
            while (var4_54 < n) {
                String appenderName = stringArray3[var4_54];
                String string9 = appenderName.trim();
                this.builder.add(this.createAppender(appenderName.trim(), PropertiesUtil.extractSubset((Properties)this.rootProperties, (String)("appender." + string9))));
                ++var4_54;
            }
        } else {
            Map map3 = PropertiesUtil.partitionOnCommonPrefixes((Properties)PropertiesUtil.extractSubset((Properties)this.rootProperties, (String)"appender"));
            for (Map.Entry entry : map3.entrySet()) {
                this.builder.add(this.createAppender(((String)entry.getKey()).trim(), (Properties)entry.getValue()));
            }
        }
        if ((string = this.rootProperties.getProperty("loggers")) != null) {
            String[] stringArray;
            String[] stringArray4 = stringArray = string.split(",");
            int n = stringArray.length;
            for (int appenderName = 0; appenderName < n; ++appenderName) {
                String string11 = stringArray4[appenderName];
                string11 = string11.trim();
                if (string11.equals("root")) continue;
                this.builder.add(this.createLogger(string11, PropertiesUtil.extractSubset((Properties)this.rootProperties, (String)("logger." + string11))));
            }
        } else {
            Map map4 = PropertiesUtil.partitionOnCommonPrefixes((Properties)PropertiesUtil.extractSubset((Properties)this.rootProperties, (String)"logger"), (boolean)true);
            for (Map.Entry entry : map4.entrySet()) {
                String name = ((String)entry.getKey()).trim();
                if (name.equals("root")) continue;
                this.builder.add(this.createLogger(name, (Properties)entry.getValue()));
            }
        }
        String string12 = this.rootProperties.getProperty("rootLogger");
        Properties properties4 = PropertiesUtil.extractSubset((Properties)this.rootProperties, (String)"rootLogger");
        if (string12 != null) {
            properties4.setProperty("", string12);
            this.rootProperties.remove("rootLogger");
        }
        if (properties4.size() > 0) {
            this.builder.add(this.createRootLogger(properties4));
        }
        this.builder.setLoggerContext(this.loggerContext);
        return this.builder.build(false);
    }

    /*
     * WARNING - void declaration
     */
    private ScriptComponentBuilder createScript(Properties properties) {
        void var1_1;
        void var3_3;
        ScriptComponentBuilder scriptComponentBuilder;
        String name = (String)properties.remove(CONFIG_NAME);
        String language = (String)properties.remove("language");
        String text = (String)properties.remove("text");
        scriptComponentBuilder = this.builder.newScript((String)((Object)scriptComponentBuilder), (String)var3_3, text);
        return PropertiesConfigurationBuilder.processRemainingProperties(scriptComponentBuilder, (Properties)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private ScriptFileComponentBuilder createScriptFile(Properties properties) {
        void var1_1;
        void var3_3;
        ScriptFileComponentBuilder scriptFileComponentBuilder;
        String name = (String)properties.remove(CONFIG_NAME);
        String path = (String)properties.remove("path");
        scriptFileComponentBuilder = this.builder.newScriptFile((String)((Object)scriptFileComponentBuilder), (String)var3_3);
        return PropertiesConfigurationBuilder.processRemainingProperties(scriptFileComponentBuilder, (Properties)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private AppenderComponentBuilder createAppender(String key, Properties properties) {
        void var2_2;
        void var1_1;
        String name = (String)properties.remove(CONFIG_NAME);
        if (Strings.isEmpty((CharSequence)name)) {
            throw new ConfigurationException("No name attribute provided for Appender " + key);
        }
        String type = (String)properties.remove(CONFIG_TYPE);
        if (Strings.isEmpty((CharSequence)type)) {
            throw new ConfigurationException("No type attribute provided for Appender " + key);
        }
        AppenderComponentBuilder appenderBuilder = this.builder.newAppender(name, type);
        this.addFiltersToComponent(appenderBuilder, properties);
        Properties layoutProps = PropertiesUtil.extractSubset((Properties)properties, (String)"layout");
        if (layoutProps.size() > 0) {
            void var3_3;
            appenderBuilder.add(this.createLayout((String)var3_3, layoutProps));
        }
        return (AppenderComponentBuilder)PropertiesConfigurationBuilder.processRemainingProperties(var1_1, (Properties)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private FilterComponentBuilder createFilter(String key, Properties properties) {
        void var2_2;
        FilterComponentBuilder filterComponentBuilder;
        void var3_3;
        String type = (String)properties.remove(CONFIG_TYPE);
        if (Strings.isEmpty((CharSequence)type)) {
            throw new ConfigurationException("No type attribute provided for Filter " + key);
        }
        String onMatch = (String)properties.remove("onMatch");
        String onMismatch = (String)properties.remove("onMismatch");
        filterComponentBuilder = this.builder.newFilter((String)var3_3, (String)((Object)filterComponentBuilder), onMismatch);
        return PropertiesConfigurationBuilder.processRemainingProperties(filterComponentBuilder, (Properties)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private AppenderRefComponentBuilder createAppenderRef(String key, Properties properties) {
        void var2_2;
        void var1_1;
        String ref = (String)properties.remove("ref");
        if (Strings.isEmpty((CharSequence)ref)) {
            throw new ConfigurationException("No ref attribute provided for AppenderRef " + key);
        }
        AppenderRefComponentBuilder appenderRefBuilder = this.builder.newAppenderRef(ref);
        String level = Strings.trimToNull((String)((String)properties.remove("level")));
        if (!Strings.isEmpty((CharSequence)level)) {
            void var3_3;
            appenderRefBuilder.addAttribute("level", (String)var3_3);
        }
        return (AppenderRefComponentBuilder)this.addFiltersToComponent(var1_1, (Properties)var2_2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LoggerComponentBuilder createLogger(String key, Properties properties) {
        void var3_3;
        void var1_1;
        void includeLocation2;
        LoggerComponentBuilder loggerBuilder;
        String levelAndRefs = properties.getProperty("");
        String name = (String)properties.remove(CONFIG_NAME);
        String location = (String)properties.remove("includeLocation");
        if (Strings.isEmpty((CharSequence)name)) {
            throw new ConfigurationException("No name attribute provided for Logger " + key);
        }
        String level = Strings.trimToNull((String)((String)properties.remove("level")));
        String type = (String)properties.remove(CONFIG_TYPE);
        if (type != null) {
            if (!type.equalsIgnoreCase("asyncLogger")) throw new ConfigurationException("Unknown Logger type " + type + " for Logger " + name);
            if (location != null) {
                boolean includeLocation2 = Boolean.parseBoolean(location);
                loggerBuilder = this.builder.newAsyncLogger(name, level, includeLocation2);
            } else {
                loggerBuilder = this.builder.newAsyncLogger(name, (String)((Object)loggerBuilder));
            }
        } else if (includeLocation2 != null) {
            boolean includeLocation3 = Boolean.parseBoolean((String)includeLocation2);
            loggerBuilder = this.builder.newLogger(name, (String)((Object)loggerBuilder), includeLocation3);
        } else {
            loggerBuilder = this.builder.newLogger(name, (String)((Object)loggerBuilder));
        }
        this.addLoggersToComponent(loggerBuilder, properties);
        this.addFiltersToComponent(loggerBuilder, properties);
        String additivity = (String)properties.remove("additivity");
        if (!Strings.isEmpty((CharSequence)additivity)) {
            void var2_2;
            loggerBuilder.addAttribute("additivity", (String)var2_2);
        }
        if (levelAndRefs == null) return var1_1;
        loggerBuilder.addAttribute("levelAndRefs", (String)var3_3);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RootLoggerComponentBuilder createRootLogger(Properties properties) {
        void var2_2;
        void var1_1;
        void var3_3;
        RootLoggerComponentBuilder loggerBuilder;
        String levelAndRefs = properties.getProperty("");
        String level = Strings.trimToNull((String)((String)properties.remove("level")));
        String type = (String)properties.remove(CONFIG_TYPE);
        String location = (String)properties.remove("includeLocation");
        if (type != null) {
            if (!type.equalsIgnoreCase("asyncRoot")) void includeLocation;
            throw new ConfigurationException("Unknown Logger type for root logger" + (String)includeLocation);
            if (location != null) {
                boolean includeLocation = Boolean.parseBoolean(location);
                loggerBuilder = this.builder.newAsyncRootLogger(level, includeLocation);
            } else {
                loggerBuilder = this.builder.newAsyncRootLogger((String)((Object)loggerBuilder));
            }
        } else if (location != null) {
            boolean includeLocation = Boolean.parseBoolean(location);
            loggerBuilder = this.builder.newRootLogger((String)((Object)loggerBuilder), includeLocation);
        } else {
            loggerBuilder = this.builder.newRootLogger((String)((Object)loggerBuilder));
        }
        this.addLoggersToComponent(loggerBuilder, properties);
        if (levelAndRefs == null) return (RootLoggerComponentBuilder)this.addFiltersToComponent(var3_3, (Properties)var1_1);
        loggerBuilder.addAttribute("levelAndRefs", (String)var2_2);
        return (RootLoggerComponentBuilder)this.addFiltersToComponent(var3_3, (Properties)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private LayoutComponentBuilder createLayout(String appenderName, Properties properties) {
        void var2_2;
        void var3_3;
        LayoutComponentBuilder layoutComponentBuilder;
        String type = (String)properties.remove(CONFIG_TYPE);
        if (Strings.isEmpty((CharSequence)type)) {
            throw new ConfigurationException("No type attribute provided for Layout on Appender " + (String)((Object)layoutComponentBuilder));
        }
        layoutComponentBuilder = this.builder.newLayout((String)var3_3);
        return PropertiesConfigurationBuilder.processRemainingProperties(layoutComponentBuilder, (Properties)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static <B extends ComponentBuilder<B>> ComponentBuilder<B> createComponent(ComponentBuilder<?> parent, String key, Properties properties) {
        void var2_2;
        void var3_3;
        ComponentBuilder<Object> componentBuilder;
        String name = (String)properties.remove(CONFIG_NAME);
        String type = (String)properties.remove(CONFIG_TYPE);
        if (Strings.isEmpty((CharSequence)type)) {
            void var1_1;
            throw new ConfigurationException("No type attribute provided for component " + (String)var1_1);
        }
        componentBuilder = componentBuilder.getBuilder().newComponent((String)var3_3, type);
        return PropertiesConfigurationBuilder.processRemainingProperties(componentBuilder, (Properties)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static <B extends ComponentBuilder<?>> B processRemainingProperties(B builder, Properties properties) {
        B b;
        while (properties.size() > 0) {
            void var2_2;
            String propertyName = properties.stringPropertyNames().iterator().next();
            int index = propertyName.indexOf(46);
            if (index > 0) {
                void var3_4;
                String prefix = propertyName.substring(0, index);
                Properties componentProperties = PropertiesUtil.extractSubset((Properties)properties, (String)prefix);
                B b2 = builder;
                b2.addComponent(PropertiesConfigurationBuilder.createComponent(b2, (String)var2_2, (Properties)var3_4));
                continue;
            }
            builder.addAttribute((String)var2_2, properties.getProperty((String)var2_2));
            properties.remove(var2_2);
        }
        return b;
    }

    /*
     * WARNING - void declaration
     */
    private <B extends FilterableComponentBuilder<? extends ComponentBuilder<?>>> B addFiltersToComponent(B componentBuilder, Properties properties) {
        void var1_1;
        Map map = PropertiesUtil.partitionOnCommonPrefixes((Properties)PropertiesUtil.extractSubset((Properties)properties, (String)"filter"));
        for (Map.Entry entry : map.entrySet()) {
            componentBuilder.add(this.createFilter(((String)entry.getKey()).trim(), (Properties)entry.getValue()));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private <B extends LoggableComponentBuilder<? extends ComponentBuilder<?>>> B addLoggersToComponent(B loggerBuilder, Properties properties) {
        void var1_1;
        Map map = PropertiesUtil.partitionOnCommonPrefixes((Properties)PropertiesUtil.extractSubset((Properties)properties, (String)"appenderRef"));
        for (Map.Entry entry : map.entrySet()) {
            loggerBuilder.add(this.createAppenderRef(((String)entry.getKey()).trim(), (Properties)entry.getValue()));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PropertiesConfigurationBuilder setLoggerContext(LoggerContext loggerContext) {
        void var1_1;
        this.loggerContext = var1_1;
        return this;
    }

    public LoggerContext getLoggerContext() {
        return this.loggerContext;
    }
}

