/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.visitors;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.convert.TypeConverters;
import org.apache.logging.log4j.core.config.plugins.visitors.PluginVisitor;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

public abstract class AbstractPluginVisitor<A extends Annotation>
implements PluginVisitor<A> {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    protected final Class<A> clazz;
    protected A annotation;
    protected String[] aliases;
    protected Class<?> conversionType;
    protected StrSubstitutor substitutor;
    protected Member member;

    /*
     * WARNING - void declaration
     */
    protected AbstractPluginVisitor(Class<A> clazz) {
        void var1_1;
        this.clazz = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PluginVisitor<A> setAnnotation(Annotation anAnnotation) {
        Annotation a = Objects.requireNonNull(anAnnotation, "No annotation was provided");
        if (this.clazz.isInstance(a)) {
            void var1_1;
            this.annotation = var1_1;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PluginVisitor<A> setAliases(String ... someAliases) {
        void var1_1;
        this.aliases = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PluginVisitor<A> setConversionType(Class<?> aConversionType) {
        void var1_1;
        this.conversionType = (Class)Objects.requireNonNull(var1_1, "No conversion type class was provided");
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PluginVisitor<A> setStrSubstitutor(StrSubstitutor aSubstitutor) {
        void var1_1;
        this.substitutor = (StrSubstitutor)Objects.requireNonNull(var1_1, "No StrSubstitutor was provided");
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PluginVisitor<A> setMember(Member aMember) {
        void var1_1;
        this.member = var1_1;
        return this;
    }

    protected static String removeAttributeValue(Map<String, String> attributes, String name, String ... aliases) {
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.equalsIgnoreCase(name)) {
                attributes.remove(key);
                return value;
            }
            if (aliases == null) continue;
            String[] stringArray = aliases;
            int n = aliases.length;
            for (int i = 0; i < n; ++i) {
                String alias = stringArray[i];
                if (!key.equalsIgnoreCase(alias)) continue;
                attributes.remove(key);
                return value;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected Object convert(String value, Object defaultValue) {
        void var2_2;
        void var1_1;
        if (defaultValue instanceof String) {
            return TypeConverters.convert(value, this.conversionType, Strings.trimToNull((String)((String)defaultValue)));
        }
        return TypeConverters.convert((String)var1_1, this.conversionType, var2_2);
    }
}

