/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.logging.log4j.core.config.plugins.validation.Constraint;
import org.apache.logging.log4j.core.config.plugins.validation.ConstraintValidator;
import org.apache.logging.log4j.core.util.ReflectionUtil;

public final class ConstraintValidators {
    private ConstraintValidators() {
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<ConstraintValidator<?>> findValidators(Annotation ... annotations) {
        void var1_1;
        Annotation[] annotationArray;
        ArrayList<ConstraintValidator<? extends Annotation>> validators = new ArrayList<ConstraintValidator<? extends Annotation>>();
        for (Annotation annotation : annotationArray) {
            ConstraintValidator<? extends Annotation> validator;
            Class<? extends Annotation> type = annotation.annotationType();
            if (!type.isAnnotationPresent(Constraint.class) || (validator = ConstraintValidators.getValidator(annotation, type)) == null) continue;
            validators.add(validator);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static <A extends Annotation> ConstraintValidator<A> getValidator(A annotation, Class<? extends A> type) {
        Constraint constraint = type.getAnnotation(Constraint.class);
        Class<? extends ConstraintValidator<? extends Annotation>> validatorClass = constraint.value();
        if (type.equals(ConstraintValidators.getConstraintValidatorAnnotationType(validatorClass))) {
            void var1_1;
            A a;
            ConstraintValidator validator = (ConstraintValidator)ReflectionUtil.instantiate(constraint);
            validator.initialize(a);
            return var1_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Type getConstraintValidatorAnnotationType(Class<? extends ConstraintValidator<?>> type) {
        for (Type parentType : type.getGenericInterfaces()) {
            void var3_3;
            ParameterizedType parameterizedType;
            if (!(parentType instanceof ParameterizedType) || !ConstraintValidator.class.equals((Object)(parameterizedType = (ParameterizedType)parentType).getRawType())) continue;
            return var3_3.getActualTypeArguments()[0];
        }
        return Void.TYPE;
    }
}

