/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.status.StatusLogger;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;

public class ResolverUtil {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String VFSZIP = "vfszip";
    private static final String VFS = "vfs";
    private static final String JAR = "jar";
    private static final String BUNDLE_RESOURCE = "bundleresource";
    private final Set<Class<?>> classMatches = new HashSet();
    private final Set<URI> resourceMatches = new HashSet<URI>();
    private ClassLoader classloader;

    public Set<Class<?>> getClasses() {
        return this.classMatches;
    }

    public Set<URI> getResources() {
        return this.resourceMatches;
    }

    public ClassLoader getClassLoader() {
        if (this.classloader != null) {
            return this.classloader;
        }
        this.classloader = Loader.getClassLoader(ResolverUtil.class, null);
        return this.classloader;
    }

    /*
     * WARNING - void declaration
     */
    public void setClassLoader(ClassLoader aClassloader) {
        void var1_1;
        this.classloader = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void find(Test test, String ... packageNames) {
        void var2_2;
        if (packageNames == null) {
            return;
        }
        for (void pkg : var2_2) {
            this.findInPackage(test, (String)pkg);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void findInPackage(Test test, String packageName) {
        Enumeration<URL> urls;
        packageName = packageName.replace('.', '/');
        ClassLoader loader = this.getClassLoader();
        try {
            urls = loader.getResources(packageName);
        }
        catch (IOException ioe) {
            LOGGER.warn("Could not read package: {}", (Object)packageName, (Object)ioe);
            return;
        }
        while (urls.hasMoreElements()) {
            try {
                void var5_9;
                InputStream is2;
                JarInputStream stream;
                URL url = urls.nextElement();
                String urlPath = this.extractPath(url);
                LOGGER.info("Scanning for classes in '{}' matching criteria {}", (Object)urlPath, (Object)test);
                if (VFSZIP.equals(url.getProtocol())) {
                    String path = urlPath.substring(0, urlPath.length() - packageName.length() - 2);
                    URL newURL = new URL(url.getProtocol(), url.getHost(), path);
                    stream = new JarInputStream(newURL.openStream());
                    try {
                        this.loadImplementationsInJar(test, packageName, path, stream);
                        continue;
                    }
                    finally {
                        this.close(stream, newURL);
                        continue;
                    }
                }
                if (VFS.equals(url.getProtocol())) {
                    Object containerPath = ((String)((Object)stream)).substring(1, ((String)((Object)stream)).length() - packageName.length() - 2);
                    File containerFile = new File((String)containerPath);
                    if (containerFile.exists()) {
                        if (containerFile.isDirectory()) {
                            this.loadImplementationsInDirectory(test, packageName, new File(containerFile, packageName));
                            continue;
                        }
                        this.loadImplementationsInJar(test, packageName, containerFile);
                        continue;
                    }
                    String path = ((String)((Object)stream)).substring(0, ((String)((Object)stream)).length() - packageName.length() - 2);
                    url = new URL(url.getProtocol(), url.getHost(), path);
                    is2 = url.openStream();
                    containerPath = null;
                    try {
                        JarInputStream jarStream = is2 instanceof JarInputStream ? (JarInputStream)is2 : new JarInputStream(is2);
                        this.loadImplementationsInJar(test, packageName, path, jarStream);
                        if (is2 == null) continue;
                    }
                    catch (Throwable throwable) {
                        try {
                            Throwable throwable2 = throwable;
                            containerPath = throwable;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (is2 != null) {
                                if (containerPath != null) {
                                    try {
                                        is2.close();
                                    }
                                    catch (Throwable is2) {
                                        ((Throwable)containerPath).addSuppressed(is2);
                                    }
                                } else {
                                    is2.close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                    is2.close();
                    continue;
                }
                if (BUNDLE_RESOURCE.equals(((URL)((Object)is2)).getProtocol())) {
                    this.loadImplementationsInBundle(test, packageName);
                    continue;
                }
                if (JAR.equals(((URL)((Object)is2)).getProtocol())) {
                    this.loadImplementationsInJar(test, packageName, (URL)((Object)is2));
                    continue;
                }
                File file = new File((String)var5_9);
                if (file.isDirectory()) {
                    this.loadImplementationsInDirectory(test, packageName, file);
                    continue;
                }
                this.loadImplementationsInJar(test, packageName, file);
            }
            catch (IOException | URISyntaxException ioe) {
                LOGGER.warn("Could not read entries", (Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    String extractPath(URL url) throws UnsupportedEncodingException, URISyntaxException {
        void var2_2;
        int bangIndex;
        String urlPath = url.getPath();
        if (urlPath.startsWith("jar:")) {
            urlPath = urlPath.substring(4);
        }
        if (urlPath.startsWith("file:")) {
            urlPath = urlPath.substring(5);
        }
        if ((bangIndex = urlPath.indexOf(33)) > 0) {
            void var3_3;
            urlPath = urlPath.substring(0, (int)var3_3);
        }
        String protocol = url.getProtocol();
        List<String> list = Arrays.asList(VFS, VFSZIP, BUNDLE_RESOURCE);
        if (list.contains(protocol)) {
            return urlPath;
        }
        String cleanPath = new URI(urlPath).getPath();
        if (new File(cleanPath).exists()) {
            void var1_1;
            return var1_1;
        }
        return URLDecoder.decode((String)var2_2, StandardCharsets.UTF_8.name());
    }

    private void loadImplementationsInBundle(Test test, String packageName) {
        Object object;
        BundleWiring bundleWiring = (BundleWiring)FrameworkUtil.getBundle(ResolverUtil.class).adapt(BundleWiring.class);
        object = bundleWiring.listResources((String)object, "*.class", 1);
        object = object.iterator();
        while (object.hasNext()) {
            String name = (String)object.next();
            this.addIfMatching(test, (String)bundleWiring);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadImplementationsInDirectory(Test test, String parent, File location) {
        File[] files = location.listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        for (int i = 0; i < n; ++i) {
            void var3_3;
            String packageOrClass;
            File file = fileArray[i];
            StringBuilder builder = new StringBuilder();
            builder.append(parent).append('/').append(file.getName());
            String string = packageOrClass = parent == null ? file.getName() : builder.toString();
            if (file.isDirectory()) {
                this.loadImplementationsInDirectory(test, packageOrClass, file);
                continue;
            }
            if (!this.isTestApplicable(test, file.getName())) continue;
            this.addIfMatching(test, (String)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isTestApplicable(Test test, String path) {
        void var1_1;
        void var2_2;
        return test.doesMatchResource() || var2_2.endsWith(".class") && var1_1.doesMatchClass();
    }

    /*
     * WARNING - void declaration
     */
    private void loadImplementationsInJar(Test test, String parent, URL url) {
        block12: {
            try {
                block14: {
                    block13: {
                        JarURLConnection connection = (JarURLConnection)url.openConnection();
                        if (connection == null) break block13;
                        connection.setUseCaches(false);
                        JarFile jarFile2 = connection.getJarFile();
                        Throwable throwable = null;
                        try {
                            Enumeration<JarEntry> entries = jarFile2.entries();
                            while (entries.hasMoreElements()) {
                                JarEntry entry = entries.nextElement();
                                String name = entry.getName();
                                if (entry.isDirectory() || !name.startsWith(parent) || !this.isTestApplicable(test, name)) continue;
                                this.addIfMatching(test, name);
                            }
                            if (jarFile2 == null) break block12;
                        }
                        catch (Throwable throwable2) {
                            try {
                                Throwable throwable3 = throwable2;
                                throwable = throwable2;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (jarFile2 != null) {
                                    if (throwable != null) {
                                        try {
                                            jarFile2.close();
                                        }
                                        catch (Throwable jarFile2) {
                                            throwable.addSuppressed(jarFile2);
                                        }
                                    } else {
                                        jarFile2.close();
                                    }
                                }
                                throw throwable4;
                            }
                        }
                        jarFile2.close();
                        break block14;
                    }
                    LOGGER.error("Could not establish connection to {}", (Object)url.toString());
                }
                return;
            }
            catch (IOException ex) {
                void var1_1;
                void var3_4;
                LOGGER.error("Could not search JAR file '{}' for classes matching criteria {}, file not found", (Object)var3_4.toString(), (Object)var1_1, (Object)ex);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadImplementationsInJar(Test test, String parent, File jarFile) {
        JarInputStream jarStream = null;
        try {
            jarStream = new JarInputStream(new FileInputStream(jarFile));
            this.loadImplementationsInJar(test, parent, jarFile.getPath(), jarStream);
            this.close(jarStream, jarFile);
            return;
        }
        catch (IOException ex) {
            try {
                void var2_4;
                void var1_1;
                LOGGER.error("Could not search JAR file '{}' for classes matching criteria {}, file not found", (Object)jarFile, (Object)var1_1, (Object)var2_4);
                this.close(jarStream, jarFile);
                return;
            }
            catch (Throwable throwable) {
                void var3_5;
                this.close(jarStream, var3_5);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void close(JarInputStream jarStream, Object source) {
        if (jarStream != null) {
            try {
                jarStream.close();
                return;
            }
            catch (IOException e) {
                void var1_2;
                void var2_3;
                LOGGER.error("Error closing JAR file stream for {}", (Object)var2_3, (Object)var1_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadImplementationsInJar(Test test, String parent, String path, JarInputStream stream) {
        try {
            JarEntry entry;
            while ((entry = stream.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory() || !name.startsWith(parent) || !this.isTestApplicable(test, name)) continue;
                this.addIfMatching(test, name);
            }
            return;
        }
        catch (IOException ioe) {
            void var1_1;
            void var3_3;
            LOGGER.error("Could not search JAR file '{}' for classes matching criteria {} due to an IOException", (Object)var3_3, (Object)var1_1, (Object)ioe);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addIfMatching(Test test, String fqn) {
        try {
            ClassLoader loader = this.getClassLoader();
            if (test.doesMatchClass()) {
                Class<?> type;
                String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Checking to see if class {} matches criteria {}", (Object)externalName, (Object)test);
                }
                if (test.matches(type = loader.loadClass(externalName))) {
                    this.classMatches.add(type);
                }
            }
            if (test.doesMatchResource()) {
                void var1_1;
                URL url = loader.getResource(fqn);
                if (url == null) {
                    url = loader.getResource(fqn.substring(1));
                }
                if (url != null && var1_1.matches(url.toURI())) {
                    this.resourceMatches.add(url.toURI());
                }
            }
            return;
        }
        catch (Throwable t) {
            void var3_4;
            void var2_2;
            LOGGER.warn("Could not examine class {}", (Object)var2_2, (Object)var3_4);
            return;
        }
    }

    public static interface Test {
        public boolean matches(Class<?> var1);

        public boolean matches(URI var1);

        public boolean doesMatchClass();

        public boolean doesMatchResource();
    }
}

