/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;

public final class PluginUtil {
    private PluginUtil() {
    }

    public static Map<String, PluginType<?>> collectPluginsByCategory(String category) {
        String string;
        Objects.requireNonNull(category, "category");
        return PluginUtil.collectPluginsByCategoryAndPackage(string, Collections.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, PluginType<?>> collectPluginsByCategoryAndPackage(String category, List<String> packages) {
        PluginManager pluginManager;
        void var1_1;
        Objects.requireNonNull(category, "category");
        Objects.requireNonNull(packages, "packages");
        PluginManager pluginManager2 = new PluginManager(category);
        pluginManager2.collectPlugins((List<String>)var1_1);
        return pluginManager.getPlugins();
    }

    /*
     * WARNING - void declaration
     */
    public static <V> V instantiatePlugin(Class<V> pluginClass) {
        Objects.requireNonNull(pluginClass, "pluginClass");
        Method pluginFactoryMethod = PluginUtil.findPluginFactoryMethod(pluginClass);
        try {
            Object object = pluginFactoryMethod.invoke(null, new Object[0]);
            return (V)object;
        }
        catch (IllegalAccessException | InvocationTargetException error) {
            void var2_3;
            String string;
            void var1_1;
            String message = String.format("failed to instantiate plugin of type %s using the factory method %s", pluginClass, var1_1);
            throw new IllegalStateException(string, (Throwable)var2_3);
        }
    }

    public static Method findPluginFactoryMethod(Class<?> pluginClass) {
        Class<?> clazz;
        Objects.requireNonNull(pluginClass, "pluginClass");
        for (Method method : pluginClass.getDeclaredMethods()) {
            boolean bl = method.isAnnotationPresent(PluginFactory.class);
            if (!bl || !(bl = Modifier.isStatic(method.getModifiers()))) continue;
            return method;
        }
        throw new IllegalStateException("no factory method found for class " + clazz);
    }
}

