/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.util.PluginRegistry;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

public class PluginManager {
    private static final CopyOnWriteArrayList<String> PACKAGES = new CopyOnWriteArrayList();
    private static final String LOG4J_PACKAGES = "org.apache.logging.log4j.core";
    private static final Logger LOGGER = StatusLogger.getLogger();
    private Map<String, PluginType<?>> plugins = new HashMap();
    private final String category;

    /*
     * WARNING - void declaration
     */
    public PluginManager(String category) {
        void var1_1;
        this.category = var1_1;
    }

    @Deprecated
    public static void main(String[] args) {
        System.err.println("ERROR: this tool is superseded by the annotation processor included in log4j-core.");
        System.err.println("If the annotation processor does not work for you, please see the manual page:");
        System.err.println("http://logging.apache.org/log4j/2.x/manual/configuration.html#ConfigurationSyntax");
        System.exit(-1);
    }

    public static void addPackage(String p) {
        String string;
        if (Strings.isBlank((String)p)) {
            return;
        }
        PACKAGES.addIfAbsent(string);
    }

    /*
     * WARNING - void declaration
     */
    public static void addPackages(Collection<String> packages) {
        for (String pkg : packages) {
            void var1_1;
            if (!Strings.isNotBlank((String)pkg)) continue;
            PACKAGES.addIfAbsent((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public PluginType<?> getPluginType(String name) {
        void var1_1;
        return this.plugins.get(var1_1.toLowerCase());
    }

    public Map<String, PluginType<?>> getPlugins() {
        return this.plugins;
    }

    public void collectPlugins() {
        this.collectPlugins(null);
    }

    /*
     * WARNING - void declaration
     */
    public void collectPlugins(List<String> packages) {
        void var3_3;
        if (this.isNotEmpty(packages) || this.isNotEmpty(PACKAGES)) {
            LOGGER.warn("The use of package scanning to locate plugins is deprecated and will be removed in a future release");
        }
        String categoryLowerCase = this.category.toLowerCase();
        LinkedHashMap newPlugins = new LinkedHashMap();
        Map<String, List<PluginType<?>>> builtInPlugins = PluginRegistry.getInstance().loadFromMainClassLoader();
        if (builtInPlugins.isEmpty()) {
            builtInPlugins = PluginRegistry.getInstance().loadFromPackage(LOG4J_PACKAGES);
        }
        PluginManager.mergeByName(newPlugins, builtInPlugins.get(categoryLowerCase));
        for (Map<String, List<PluginType<?>>> pluginsByCategory : PluginRegistry.getInstance().getPluginsByCategoryByBundleId().values()) {
            PluginManager.mergeByName(newPlugins, pluginsByCategory.get(categoryLowerCase));
        }
        for (String pkg : PACKAGES) {
            PluginManager.mergeByName(newPlugins, PluginRegistry.getInstance().loadFromPackage(pkg).get(categoryLowerCase));
        }
        if (packages != null) {
            void var1_1;
            for (String pkg : var1_1) {
                PluginManager.mergeByName(newPlugins, PluginRegistry.getInstance().loadFromPackage(pkg).get(categoryLowerCase));
            }
        }
        LOGGER.debug("PluginManager '{}' found {} plugins", (Object)this.category, (Object)newPlugins.size());
        this.plugins = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static void mergeByName(Map<String, PluginType<?>> newPlugins, List<PluginType<?>> plugins) {
        Iterator iterator;
        if (plugins == null) {
            return;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            void var3_3;
            PluginType pluginType = (PluginType)iterator.next();
            String key = pluginType.getKey();
            PluginType<?> existing = newPlugins.get(key);
            if (existing == null) {
                newPlugins.put(key, pluginType);
                continue;
            }
            if (existing.getPluginClass().equals(pluginType.getPluginClass())) continue;
            LOGGER.warn("Plugin [{}] is already mapped to {}, ignoring {}", (Object)var3_3, existing.getPluginClass(), var2_2.getPluginClass());
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isNotEmpty(List<String> list) {
        void var1_1;
        return list != null && !var1_1.isEmpty();
    }
}

