/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.plugins.PluginAliases;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.config.plugins.validation.ConstraintValidator;
import org.apache.logging.log4j.core.config.plugins.validation.ConstraintValidators;
import org.apache.logging.log4j.core.config.plugins.visitors.PluginVisitor;
import org.apache.logging.log4j.core.config.plugins.visitors.PluginVisitors;
import org.apache.logging.log4j.core.util.Builder;
import org.apache.logging.log4j.core.util.ReflectionUtil;
import org.apache.logging.log4j.core.util.TypeUtil;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.StringBuilders;

public class PluginBuilder
implements Builder<Object> {
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final PluginType<?> pluginType;
    private final Class<?> clazz;
    private Configuration configuration;
    private Node node;
    private LogEvent event;

    /*
     * WARNING - void declaration
     */
    public PluginBuilder(PluginType<?> pluginType) {
        void var1_1;
        this.pluginType = pluginType;
        this.clazz = var1_1.getPluginClass();
    }

    /*
     * WARNING - void declaration
     */
    public PluginBuilder withConfiguration(Configuration configuration) {
        void var1_1;
        this.configuration = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public PluginBuilder withConfigurationNode(Node node) {
        void var1_1;
        this.node = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public PluginBuilder forLogEvent(LogEvent event) {
        void var1_1;
        this.event = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object build() {
        this.verify();
        try {
            LOGGER.debug("Building Plugin[name={}, class={}].", (Object)this.pluginType.getElementName(), (Object)this.pluginType.getPluginClass().getName());
            Builder<?> builder = PluginBuilder.createBuilder(this.clazz);
            if (builder != null) {
                this.injectFields(builder);
                return builder.build();
            }
        }
        catch (ConfigurationException e) {
            LOGGER.error("Could not create plugin of type {} for element {}", this.clazz, (Object)this.node.getName(), (Object)e);
            return null;
        }
        catch (Throwable t) {
            LOGGER.error("Could not create plugin of type {} for element {}: {}", this.clazz, (Object)this.node.getName(), (Object)(t instanceof InvocationTargetException ? ((InvocationTargetException)t).getCause() : t).toString(), (Object)t);
        }
        try {
            void var2_5;
            Method factory = PluginBuilder.findFactoryMethod(this.clazz);
            Object[] params = this.generateParameters(factory);
            return factory.invoke(null, (Object[])var2_5);
        }
        catch (Throwable t) {
            void var1_4;
            LOGGER.error("Unable to invoke factory method in {} for element {}: {}", this.clazz, (Object)this.node.getName(), (Object)(t instanceof InvocationTargetException ? ((InvocationTargetException)t).getCause() : t).toString(), (Object)var1_4);
            return null;
        }
    }

    private void verify() {
        Objects.requireNonNull(this.configuration, "No Configuration object was set.");
        Objects.requireNonNull(this.node, "No Node object was set.");
    }

    /*
     * WARNING - void declaration
     */
    private static Builder<?> createBuilder(Class<?> clazz) throws InvocationTargetException, IllegalAccessException {
        for (Method method : clazz.getDeclaredMethods()) {
            void var3_3;
            if (!method.isAnnotationPresent(PluginBuilderFactory.class) || !Modifier.isStatic(method.getModifiers()) || !TypeUtil.isAssignable(Builder.class, method.getReturnType())) continue;
            ReflectionUtil.makeAccessible(method);
            return (Builder)var3_3.invoke(null, new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void injectFields(Builder<?> builder) throws IllegalAccessException {
        void var3_3;
        void var1_1;
        void var2_2;
        List<Field> fields = TypeUtil.getAllDeclaredFields(builder.getClass());
        AccessibleObject.setAccessible(fields.toArray(EMPTY_FIELD_ARRAY), true);
        StringBuilder log = new StringBuilder();
        for (Field field : fields) {
            StringBuilder stringBuilder = log;
            stringBuilder.append(stringBuilder.length() == 0 ? PluginBuilder.simpleName(builder) + "(" : ", ");
            Annotation[] annotations = field.getDeclaredAnnotations();
            String[] aliases = PluginBuilder.extractPluginAliases(annotations);
            Annotation[] annotationArray = annotations;
            int n = annotations.length;
            for (int i = 0; i < n; ++i) {
                Object value;
                PluginVisitor<? extends Annotation> visitor;
                Annotation a = annotationArray[i];
                if (a instanceof PluginAliases || (visitor = PluginVisitors.findVisitor(a.annotationType())) == null || (value = visitor.setAliases(aliases).setAnnotation(a).setConversionType(field.getType()).setStrSubstitutor(this.event == null ? this.configuration.getConfigurationStrSubstitutor() : this.configuration.getStrSubstitutor()).setMember(field).visit(this.configuration, this.node, this.event, log)) == null) continue;
                field.set(builder, value);
            }
        }
        String reason = PluginBuilder.validateFields(builder, (List<Field>)var2_2);
        StringBuilder stringBuilder = log;
        stringBuilder.append(stringBuilder.length() == 0 ? var1_1.getClass().getSimpleName() + "()" : ")");
        LOGGER.debug(var3_3.toString());
        if (!reason.isEmpty()) {
            throw new ConfigurationException("Arguments given for element " + this.node.getName() + " are invalid: " + reason);
        }
        this.checkForRemainingAttributes();
        this.verifyNodeChildrenUsed();
    }

    /*
     * WARNING - void declaration
     */
    private static String validateFields(Builder<?> builder, List<Field> fields) throws IllegalAccessException {
        void var2_2;
        Iterator iterator;
        String reason = "";
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            Annotation[] annotationArray = field.getDeclaredAnnotations();
            Collection<ConstraintValidator<?>> validators = ConstraintValidators.findValidators(annotationArray);
            Object value = field.get(builder);
            for (ConstraintValidator constraintValidator : validators) {
                if (constraintValidator.isValid(field.getName(), value)) continue;
                if (!reason.isEmpty()) {
                    reason = reason + ", ";
                }
                reason = reason + "field '" + field.getName() + "' has invalid value '" + value + "'";
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean validateFields(Builder<?> builder, String errorPrefix) {
        List<Field> fields = TypeUtil.getAllDeclaredFields(builder.getClass());
        AccessibleObject.setAccessible(fields.toArray(EMPTY_FIELD_ARRAY), true);
        try {
            void var2_3;
            String reason = PluginBuilder.validateFields(builder, (List<Field>)var2_3);
            if (!reason.isEmpty()) {
                LOGGER.error("{}: {}", (Object)errorPrefix, (Object)reason);
                return false;
            }
        }
        catch (IllegalAccessException e) {
            void var0_1;
            void var1_2;
            LOGGER.error("{}: {}", (Object)var1_2, (Object)e.getMessage(), (Object)var0_1);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static String simpleName(Object object) {
        void var1_1;
        Object object2;
        if (object == null) {
            return "null";
        }
        Object cls = object.getClass().getName();
        int index = ((String)cls).lastIndexOf(46);
        if (index < 0) {
            return cls;
        }
        return ((String)object2).substring((int)(var1_1 + true));
    }

    private static Method findFactoryMethod(Class<?> clazz) {
        Class<?> clazz2;
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(PluginFactory.class) || !Modifier.isStatic(method.getModifiers())) continue;
            ReflectionUtil.makeAccessible(method);
            return method;
        }
        throw new IllegalStateException("No factory method found for class " + clazz2.getName());
    }

    /*
     * WARNING - void declaration
     */
    private Object[] generateParameters(Method factory) {
        void var2_2;
        void var1_1;
        StringBuilder log = new StringBuilder();
        Class<?>[] types = factory.getParameterTypes();
        Annotation[][] annotations = factory.getParameterAnnotations();
        Object[] args = new Object[annotations.length];
        boolean invalid = false;
        for (int i = 0; i < annotations.length; ++i) {
            StringBuilder stringBuilder = log;
            stringBuilder.append(stringBuilder.length() == 0 ? factory.getName() + "(" : ", ");
            String[] aliases = PluginBuilder.extractPluginAliases(annotations[i]);
            for (Annotation a : annotations[i]) {
                Object value;
                PluginVisitor<? extends Annotation> visitor;
                if (a instanceof PluginAliases || (visitor = PluginVisitors.findVisitor(a.annotationType())) == null || (value = visitor.setAliases(aliases).setAnnotation(a).setConversionType(types[i]).setStrSubstitutor(this.event == null ? this.configuration.getConfigurationStrSubstitutor() : this.configuration.getStrSubstitutor()).setMember(factory).visit(this.configuration, this.node, this.event, log)) == null) continue;
                args[i] = value;
            }
            Collection<ConstraintValidator<?>> validators = ConstraintValidators.findValidators(annotations[i]);
            Object value = args[i];
            String argName = "arg[" + i + "](" + PluginBuilder.simpleName(value) + ")";
            for (ConstraintValidator<?> constraintValidator : validators) {
                if (constraintValidator.isValid(argName, value)) continue;
                invalid = true;
            }
        }
        StringBuilder stringBuilder = log;
        stringBuilder.append(stringBuilder.length() == 0 ? var1_1.getName() + "()" : ")");
        this.checkForRemainingAttributes();
        this.verifyNodeChildrenUsed();
        LOGGER.debug(var2_2.toString());
        if (invalid) {
            throw new ConfigurationException("Arguments given for element " + this.node.getName() + " are invalid");
        }
        return args;
    }

    /*
     * WARNING - void declaration
     */
    private static String[] extractPluginAliases(Annotation ... parmTypes) {
        void var1_1;
        Annotation[] annotationArray;
        String[] aliases = null;
        for (Annotation a : annotationArray) {
            if (!(a instanceof PluginAliases)) continue;
            aliases = ((PluginAliases)a).value();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void checkForRemainingAttributes() {
        Map<String, String> attrs = this.node.getAttributes();
        if (!attrs.isEmpty()) {
            void var2_2;
            StringBuilder sb = new StringBuilder();
            for (String key : attrs.keySet()) {
                if (sb.length() == 0) {
                    sb.append(this.node.getName());
                    sb.append(" contains ");
                    if (attrs.size() == 1) {
                        sb.append("an invalid element or attribute ");
                    } else {
                        sb.append("invalid attributes ");
                    }
                } else {
                    sb.append(", ");
                }
                StringBuilders.appendDqValue((StringBuilder)sb, (Object)key);
            }
            LOGGER.error(var2_2.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void verifyNodeChildrenUsed() {
        List<Node> children = this.node.getChildren();
        if (!this.pluginType.isDeferChildren() && !children.isEmpty()) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                void var3_3;
                Node child = (Node)iterator.next();
                String nodeType = this.node.getType().getElementName();
                String start = nodeType.equals(this.node.getName()) ? this.node.getName() : nodeType + ' ' + this.node.getName();
                LOGGER.error("{} has no parameter that matches element {}", (Object)var3_3, (Object)var2_2.getName());
            }
        }
    }
}

