/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.processor;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor7;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAliases;
import org.apache.logging.log4j.core.config.plugins.processor.PluginCache;
import org.apache.logging.log4j.core.config.plugins.processor.PluginEntry;

@SupportedAnnotationTypes(value={"org.apache.logging.log4j.core.config.plugins.*"})
public class PluginProcessor
extends AbstractProcessor {
    private static final Element[] EMPTY_ELEMENT_ARRAY = new Element[0];
    public static final String PLUGIN_CACHE_FILE = "META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat";
    private final PluginCache pluginCache = new PluginCache();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Messager messager = this.processingEnv.getMessager();
        messager.printMessage(Diagnostic.Kind.NOTE, "Processing Log4j annotations");
        try {
            void var1_1;
            Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(Plugin.class);
            if (elements.isEmpty()) {
                messager.printMessage(Diagnostic.Kind.NOTE, "No elements to process");
                return false;
            }
            this.collectPlugins(elements);
            this.writeCacheFile(elements.toArray(EMPTY_ELEMENT_ARRAY));
            var1_1.printMessage(Diagnostic.Kind.NOTE, "Annotations processed");
            return true;
        }
        catch (Exception exception) {
            void var2_2;
            Exception ex = exception;
            exception.printStackTrace();
            this.error(var2_2.getMessage());
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void error(CharSequence message) {
        void var1_1;
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, (CharSequence)var1_1);
    }

    private void collectPlugins(Iterable<? extends Element> elements) {
        Iterator iterator;
        Elements elementUtils = this.processingEnv.getElementUtils();
        PluginElementVisitor pluginVisitor = new PluginElementVisitor(elementUtils);
        PluginAliasesElementVisitor pluginAliasesVisitor = new PluginAliasesElementVisitor(elementUtils);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            Plugin plugin = element.getAnnotation(Plugin.class);
            if (plugin == null) continue;
            PluginEntry entry = element.accept(pluginVisitor, plugin);
            Map<String, PluginEntry> category = this.pluginCache.getCategory(entry.getCategory());
            category.put(entry.getKey(), entry);
            Object object = element.accept(pluginAliasesVisitor, plugin);
            object = object.iterator();
            while (object.hasNext()) {
                PluginEntry pluginEntry = (PluginEntry)object.next();
                category.put(pluginEntry.getKey(), pluginEntry);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeCacheFile(Element ... elements2) throws IOException {
        FileObject elements2 = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", PLUGIN_CACHE_FILE, elements2);
        OutputStream out2 = elements2.openOutputStream();
        Throwable throwable = null;
        try {
            this.pluginCache.writeCache(out2);
            if (out2 == null) return;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (out2 == null) throw throwable4;
                if (throwable != null) {
                    try {
                        out2.close();
                        throw throwable4;
                    }
                    catch (Throwable out2) {
                        throwable.addSuppressed(out2);
                    }
                    throw throwable4;
                } else {
                    void var1_3;
                    var1_3.close();
                }
                throw throwable4;
            }
        }
        out2.close();
        return;
    }

    private static class PluginAliasesElementVisitor
    extends SimpleElementVisitor7<Collection<PluginEntry>, Plugin> {
        private final Elements elements;

        /*
         * WARNING - void declaration
         */
        private PluginAliasesElementVisitor(Elements elements) {
            super(Collections.emptyList());
            void var1_1;
            this.elements = var1_1;
        }

        @Override
        public Collection<PluginEntry> visitType(TypeElement e, Plugin plugin) {
            String[] stringArray;
            PluginAliases aliases = e.getAnnotation(PluginAliases.class);
            if (aliases == null) {
                return (Collection)this.DEFAULT_VALUE;
            }
            ArrayList<PluginEntry> entries = new ArrayList<PluginEntry>(aliases.value().length);
            for (String alias : stringArray.value()) {
                PluginEntry entry = new PluginEntry();
                entry.setKey(alias.toLowerCase(Locale.US));
                entry.setClassName(this.elements.getBinaryName(e).toString());
                entry.setName("".equals(plugin.elementType()) ? alias : plugin.elementType());
                entry.setPrintable(plugin.printObject());
                entry.setDefer(plugin.deferChildren());
                entry.setCategory(plugin.category());
                entries.add(entry);
            }
            return entries;
        }
    }

    private static class PluginElementVisitor
    extends SimpleElementVisitor7<PluginEntry, Plugin> {
        private final Elements elements;

        /*
         * WARNING - void declaration
         */
        private PluginElementVisitor(Elements elements) {
            void var1_1;
            this.elements = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public PluginEntry visitType(TypeElement e, Plugin plugin) {
            void var3_3;
            void var2_2;
            void var1_1;
            Objects.requireNonNull(plugin, "Plugin annotation is null.");
            PluginEntry entry = new PluginEntry();
            entry.setKey(plugin.name().toLowerCase(Locale.US));
            entry.setClassName(this.elements.getBinaryName((TypeElement)var1_1).toString());
            entry.setName("".equals(plugin.elementType()) ? plugin.name() : plugin.elementType());
            entry.setPrintable(plugin.printObject());
            entry.setDefer(plugin.deferChildren());
            entry.setCategory(var2_2.category());
            return var3_3;
        }
    }
}

