/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.processor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.core.config.plugins.processor.PluginEntry;

public class PluginCache {
    private final Map<String, Map<String, PluginEntry>> categories = new TreeMap<String, Map<String, PluginEntry>>();

    public Map<String, Map<String, PluginEntry>> getAllCategories() {
        return this.categories;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, PluginEntry> getCategory(String category) {
        void var1_1;
        String key = category.toLowerCase();
        return this.categories.computeIfAbsent((String)var1_1, ignored -> new TreeMap());
    }

    /*
     * WARNING - void declaration
     */
    public void writeCache(OutputStream os) throws IOException {
        DataOutputStream out2 = new DataOutputStream(new BufferedOutputStream(os));
        Throwable throwable = null;
        try {
            out2.writeInt(this.categories.size());
            for (Map.Entry<String, Map<String, PluginEntry>> category : this.categories.entrySet()) {
                out2.writeUTF(category.getKey());
                Map<String, PluginEntry> m = category.getValue();
                out2.writeInt(m.size());
                for (Map.Entry<String, PluginEntry> entry : m.entrySet()) {
                    PluginEntry plugin = entry.getValue();
                    out2.writeUTF(plugin.getKey());
                    out2.writeUTF(plugin.getClassName());
                    out2.writeUTF(plugin.getName());
                    out2.writeBoolean(plugin.isPrintable());
                    out2.writeBoolean(plugin.isDefer());
                }
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (throwable != null) {
                    try {
                        out2.close();
                    }
                    catch (Throwable out2) {
                        throwable.addSuppressed(out2);
                    }
                } else {
                    void var1_1;
                    var1_1.close();
                }
                throw throwable4;
            }
        }
        out2.close();
        return;
    }

    /*
     * WARNING - void declaration
     */
    public void loadCacheFiles(Enumeration<URL> resources) throws IOException {
        this.categories.clear();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            DataInputStream in2 = new DataInputStream(new BufferedInputStream(url.openStream()));
            Throwable throwable = null;
            try {
                int count = in2.readInt();
                for (int i = 0; i < count; ++i) {
                    String category = in2.readUTF();
                    Map<String, PluginEntry> m = this.getCategory(category);
                    int entries = in2.readInt();
                    for (int j = 0; j < entries; ++j) {
                        String key = in2.readUTF();
                        String className = in2.readUTF();
                        String name = in2.readUTF();
                        boolean printable = in2.readBoolean();
                        boolean defer = in2.readBoolean();
                        m.computeIfAbsent(key, k -> {
                            void var3_3;
                            void var2_2;
                            void var1_1;
                            String string;
                            PluginEntry entry = new PluginEntry();
                            entry.setKey((String)k);
                            entry.setClassName(string);
                            entry.setName((String)var1_1);
                            entry.setPrintable((boolean)var2_2);
                            entry.setDefer((boolean)var3_3);
                            entry.setCategory(category);
                            return entry;
                        });
                    }
                }
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable != null) {
                        try {
                            in2.close();
                        }
                        catch (Throwable in2) {
                            throwable.addSuppressed(in2);
                        }
                    } else {
                        void var2_3;
                        var2_3.close();
                    }
                    throw throwable4;
                }
            }
            in2.close();
        }
    }

    public int size() {
        return this.categories.size();
    }
}

