/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.convert;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.UnknownFormatConversionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.convert.EnumConverter;
import org.apache.logging.log4j.core.config.plugins.convert.TypeConverter;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.util.ReflectionUtil;
import org.apache.logging.log4j.core.util.TypeUtil;
import org.apache.logging.log4j.status.StatusLogger;

public class TypeConverterRegistry {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static volatile TypeConverterRegistry INSTANCE;
    private static final Object INSTANCE_LOCK;
    private final ConcurrentMap<Type, TypeConverter<?>> registry = new ConcurrentHashMap();

    /*
     * WARNING - void declaration
     */
    public static TypeConverterRegistry getInstance() {
        void var0;
        TypeConverterRegistry result = INSTANCE;
        if (result == null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                result = INSTANCE;
                if (result == null) {
                    INSTANCE = result = new TypeConverterRegistry();
                }
            }
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public TypeConverter<?> findCompatibleConverter(Type type) {
        void var1_1;
        Object clazz;
        Objects.requireNonNull(type, "No type was provided");
        TypeConverter primary = (TypeConverter)this.registry.get(type);
        if (primary != null) {
            return primary;
        }
        if (type instanceof Class && ((Class)(clazz = (Class)type)).isEnum()) {
            EnumConverter<Enum> enumConverter = new EnumConverter<Enum>(((Class)clazz).asSubclass(Enum.class));
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                return this.registerConverter(type, enumConverter);
            }
        }
        for (Map.Entry object : this.registry.entrySet()) {
            Type key = (Type)object.getKey();
            if (!TypeUtil.isAssignable(type, key)) continue;
            LOGGER.debug("Found compatible TypeConverter<{}> for type [{}].", (Object)key, (Object)type);
            TypeConverter value = (TypeConverter)object.getValue();
            Object object2 = INSTANCE_LOCK;
            synchronized (object2) {
                void var2_3;
                return this.registerConverter(type, (TypeConverter<?>)var2_3);
            }
        }
        throw new UnknownFormatConversionException(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    private TypeConverterRegistry() {
        void var1_1;
        LOGGER.trace("TypeConverterRegistry initializing.");
        PluginManager manager = new PluginManager("TypeConverter");
        manager.collectPlugins();
        this.loadKnownTypeConverters(var1_1.getPlugins().values());
        this.registerPrimitiveTypes();
    }

    /*
     * WARNING - void declaration
     */
    private void loadKnownTypeConverters(Collection<PluginType<?>> knownTypes) {
        for (PluginType<?> pluginType : knownTypes) {
            void var3_3;
            Class<?> clazz = pluginType.getPluginClass();
            if (!TypeConverter.class.isAssignableFrom(clazz)) continue;
            Class<TypeConverter> pluginClass = clazz.asSubclass(TypeConverter.class);
            Type conversionType = TypeConverterRegistry.getTypeConverterSupportedType(pluginClass);
            TypeConverter converter = ReflectionUtil.instantiate(pluginClass);
            this.registerConverter((Type)var3_3, (TypeConverter<?>)((Object)pluginType));
        }
    }

    /*
     * WARNING - void declaration
     */
    private TypeConverter<?> registerConverter(Type conversionType, TypeConverter<?> converter) {
        void var2_2;
        void var1_1;
        TypeConverter conflictingConverter = (TypeConverter)this.registry.get(conversionType);
        if (conflictingConverter != null) {
            void var3_3;
            Comparable overridable;
            Comparable comparable;
            boolean overridable2 = converter instanceof Comparable ? (comparable = (Comparable)((Object)converter)).compareTo(conflictingConverter) < 0 : (conflictingConverter instanceof Comparable ? (overridable = (Comparable)((Object)conflictingConverter)).compareTo(converter) > 0 : false);
            if (overridable2) {
                LOGGER.debug("Replacing TypeConverter [{}] for type [{}] with [{}] after comparison.", (Object)conflictingConverter, (Object)conversionType, converter);
                this.registry.put(conversionType, converter);
                return converter;
            }
            LOGGER.warn("Ignoring TypeConverter [{}] for type [{}] that conflicts with [{}], since they are not comparable.", converter, (Object)conversionType, (Object)conflictingConverter);
            return var3_3;
        }
        this.registry.put((Type)var1_1, converter);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static Type getTypeConverterSupportedType(Class<? extends TypeConverter> typeConverterClass) {
        for (Type type : typeConverterClass.getGenericInterfaces()) {
            void var3_3;
            ParameterizedType pType;
            if (!(type instanceof ParameterizedType) || !TypeConverter.class.equals((Object)(pType = (ParameterizedType)type).getRawType())) continue;
            return var3_3.getActualTypeArguments()[0];
        }
        return Void.TYPE;
    }

    private void registerPrimitiveTypes() {
        this.registerTypeAlias((Type)((Object)Boolean.class), Boolean.TYPE);
        this.registerTypeAlias((Type)((Object)Byte.class), Byte.TYPE);
        this.registerTypeAlias((Type)((Object)Character.class), Character.TYPE);
        this.registerTypeAlias((Type)((Object)Double.class), Double.TYPE);
        this.registerTypeAlias((Type)((Object)Float.class), Float.TYPE);
        this.registerTypeAlias((Type)((Object)Integer.class), Integer.TYPE);
        this.registerTypeAlias((Type)((Object)Long.class), Long.TYPE);
        this.registerTypeAlias((Type)((Object)Short.class), Short.TYPE);
    }

    /*
     * WARNING - void declaration
     */
    private void registerTypeAlias(Type knownType, Type aliasType) {
        void var1_1;
        void var2_2;
        this.registry.putIfAbsent((Type)var2_2, (TypeConverter<?>)this.registry.get(var1_1));
    }

    static {
        INSTANCE_LOCK = new Object();
    }
}

