/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.composite;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.composite.MergeStrategy;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.filter.CompositeFilter;
import org.apache.logging.log4j.core.util.Integers;

public class DefaultMergeStrategy
implements MergeStrategy {
    private static final String APPENDERS = "appenders";
    private static final String PROPERTIES = "properties";
    private static final String LOGGERS = "loggers";
    private static final String SCRIPTS = "scripts";
    private static final String FILTERS = "filters";
    private static final String STATUS = "status";
    private static final String NAME = "name";
    private static final String REF = "ref";

    /*
     * WARNING - void declaration
     */
    @Override
    public void mergeRootProperties(Node rootNode, AbstractConfiguration configuration) {
        for (Map.Entry<String, String> attribute : configuration.getRootNode().getAttributes().entrySet()) {
            void var3_3;
            boolean bl;
            boolean isFound = false;
            for (Map.Entry<String, String> targetAttribute : rootNode.getAttributes().entrySet()) {
                if (!targetAttribute.getKey().equalsIgnoreCase(attribute.getKey())) continue;
                if (attribute.getKey().equalsIgnoreCase(STATUS)) {
                    Level targetLevel = Level.getLevel((String)targetAttribute.getValue().toUpperCase());
                    Level sourceLevel = Level.getLevel((String)attribute.getValue().toUpperCase());
                    if (targetLevel != null && sourceLevel != null) {
                        if (sourceLevel.isLessSpecificThan(targetLevel)) {
                            targetAttribute.setValue(attribute.getValue());
                        }
                    } else if (sourceLevel != null) {
                        targetAttribute.setValue(attribute.getValue());
                    }
                } else if (attribute.getKey().equalsIgnoreCase("monitorInterval")) {
                    int sourceInterval = Integers.parseInt(attribute.getValue());
                    int targetInterval = Integers.parseInt(targetAttribute.getValue());
                    if (targetInterval == 0 || sourceInterval < targetInterval) {
                        targetAttribute.setValue(attribute.getValue());
                    }
                } else if (attribute.getKey().equalsIgnoreCase("packages")) {
                    String sourcePackages = attribute.getValue();
                    String targetPackages = targetAttribute.getValue();
                    if (sourcePackages != null) {
                        if (targetPackages != null) {
                            targetAttribute.setValue(targetPackages + "," + sourcePackages);
                        } else {
                            targetAttribute.setValue(sourcePackages);
                        }
                    }
                } else {
                    targetAttribute.setValue(attribute.getValue());
                }
                bl = true;
            }
            if (bl) continue;
            rootNode.getAttributes().put(attribute.getKey(), (String)var3_3.getValue());
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void mergConfigurations(Node target, Node source, PluginManager pluginManager) {
        for (Node sourceChildNode : source.getChildren()) {
            isFilter = this.isFilterNode(sourceChildNode);
            isMerged = false;
            block11: for (Node targetChildNode : target.getChildren()) {
                if (isFilter) {
                    if (!this.isFilterNode(targetChildNode)) continue;
                    this.updateFilterNode(target, targetChildNode, sourceChildNode, pluginManager);
                    isMerged = true;
                    break;
                }
                if (!targetChildNode.getName().equalsIgnoreCase(sourceChildNode.getName())) continue;
                isMerged = targetChildNode.getName().toLowerCase();
                var9_10 = -1;
                switch (isMerged.hashCode()) {
                    case -926053069: {
                        if (!isMerged.equals("properties")) break;
                        var9_10 = 0;
                        break;
                    }
                    case 1926514952: {
                        if (!isMerged.equals("scripts")) break;
                        var9_10 = 1;
                        break;
                    }
                    case 2009213964: {
                        if (!isMerged.equals("appenders")) break;
                        var9_10 = 2;
                        break;
                    }
                    case 342277347: {
                        if (!isMerged.equals("loggers")) break;
                        var9_10 = 3;
                    }
                }
                switch (var9_10) {
                    case 0: 
                    case 1: 
                    case 2: {
                        for (Node node : sourceChildNode.getChildren()) {
                            for (Node targetNode : targetChildNode.getChildren()) {
                                if (!Objects.equals(targetNode.getAttributes().get("name"), node.getAttributes().get("name"))) continue;
                                targetChildNode.getChildren().remove(targetNode);
                                break;
                            }
                            targetChildNode.getChildren().add(node);
                        }
                        isMerged = true;
                        continue block11;
                    }
                    case 3: {
                        targetLoggers = new HashMap<String, Node>();
                        for (Object node : targetChildNode.getChildren()) {
                            targetLoggers.put(node.getName(), (Node)node);
                        }
                        for (Object node : sourceChildNode.getChildren()) {
                            targetNode = this.getLoggerNode(targetChildNode, node.getAttributes().get("name"));
                            loggerNode = new Node(targetChildNode, node.getName(), node.getType());
                            if (targetNode == null) ** GOTO lbl91
                            targetNode.getAttributes().putAll(node.getAttributes());
                            node = node.getChildren().iterator();
                            while (node.hasNext()) {
                                sourceLoggerChild = (Node)node.next();
                                if (this.isFilterNode(sourceLoggerChild)) {
                                    foundFilter = false;
                                    for (Node targetChild : targetNode.getChildren()) {
                                        if (!this.isFilterNode(targetChild)) continue;
                                        this.updateFilterNode(loggerNode, targetChild, sourceLoggerChild, pluginManager);
                                        foundFilter = true;
                                        break;
                                    }
                                    if (foundFilter) continue;
                                    childNode = new Node(loggerNode, sourceLoggerChild.getName(), sourceLoggerChild.getType());
                                    childNode.getAttributes().putAll(sourceLoggerChild.getAttributes());
                                    childNode.getChildren().addAll(sourceLoggerChild.getChildren());
                                    targetNode.getChildren().add(childNode);
                                    continue;
                                }
                                childNode = new Node(loggerNode, sourceLoggerChild.getName(), sourceLoggerChild.getType());
                                childNode.getAttributes().putAll(sourceLoggerChild.getAttributes());
                                childNode.getChildren().addAll(sourceLoggerChild.getChildren());
                                if (!childNode.getName().equalsIgnoreCase("AppenderRef")) ** GOTO lbl82
                                for (Node targetChild : targetNode.getChildren()) {
                                    if (!this.isSameReference(targetChild, childNode)) continue;
                                    targetNode.getChildren().remove(targetChild);
                                    ** GOTO lbl87
                                }
                                ** GOTO lbl87
lbl82:
                                // 2 sources

                                for (Node targetChild : targetNode.getChildren()) {
                                    if (!this.isSameName(targetChild, childNode)) continue;
                                    targetNode.getChildren().remove(targetChild);
                                    break;
                                }
lbl87:
                                // 4 sources

                                targetNode.getChildren().add(childNode);
                            }
                            continue;
lbl91:
                            // 1 sources

                            loggerNode.getAttributes().putAll(node.getAttributes());
                            loggerNode.getChildren().addAll(node.getChildren());
                            targetChildNode.getChildren().add(loggerNode);
                        }
                        var6_6 = true;
                        continue block11;
                    }
                }
                targetChildNode.getChildren().addAll(sourceChildNode.getChildren());
                var6_6 = true;
            }
            if (var6_6) continue;
            if (sourceChildNode.getName().equalsIgnoreCase("Properties")) {
                target.getChildren().add(0, sourceChildNode);
                continue;
            }
            target.getChildren().add(sourceChildNode);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Node getLoggerNode(Node parentNode, String name) {
        for (Node node : parentNode.getChildren()) {
            void var3_3;
            String nodeName = node.getAttributes().get(NAME);
            if (name == null && nodeName == null) {
                return node;
            }
            if (nodeName == null || !nodeName.equals(name)) continue;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void updateFilterNode(Node target, Node targetChildNode, Node sourceChildNode, PluginManager pluginManager) {
        void var1_1;
        void var2_2;
        void var3_3;
        Node node;
        if (CompositeFilter.class.isAssignableFrom(targetChildNode.getType().getPluginClass())) {
            node = new Node(targetChildNode, sourceChildNode.getName(), sourceChildNode.getType());
            node.getChildren().addAll(sourceChildNode.getChildren());
            node.getAttributes().putAll(sourceChildNode.getAttributes());
            targetChildNode.getChildren().add(node);
            return;
        }
        PluginType<?> pluginType = ((PluginManager)((Object)node)).getPluginType(FILTERS);
        Node filtersNode = new Node(targetChildNode, FILTERS, pluginType);
        Node node2 = new Node(filtersNode, sourceChildNode.getName(), sourceChildNode.getType());
        node2.getAttributes().putAll(sourceChildNode.getAttributes());
        List<Node> children = filtersNode.getChildren();
        children.add(targetChildNode);
        var3_3.add(node2);
        List<Node> nodes = target.getChildren();
        nodes.remove(var2_2);
        var1_1.add(filtersNode);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isFilterNode(Node node) {
        void var1_1;
        return Filter.class.isAssignableFrom(var1_1.getType().getPluginClass());
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSameName(Node node1, Node node2) {
        void var2_2;
        void var1_1;
        String value = node1.getAttributes().get(NAME);
        return value != null && var1_1.toLowerCase().equals(var2_2.getAttributes().get(NAME).toLowerCase());
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSameReference(Node node1, Node node2) {
        void var2_2;
        void var1_1;
        String value = node1.getAttributes().get(REF);
        return value != null && var1_1.toLowerCase().equals(var2_2.getAttributes().get(REF).toLowerCase());
    }
}

