/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.builder.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.AppenderRefComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.Component;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.CustomLevelComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.FilterComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.KeyValuePairComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.PropertyComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ScriptComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ScriptFileComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.config.builder.impl.DefaultAppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultAppenderRefComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultCustomLevelComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultFilterComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultKeyValuePairComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultLayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultPropertyComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultRootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultScriptComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultScriptFileComponentBuilder;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.core.util.Throwables;

public class DefaultConfigurationBuilder<T extends BuiltConfiguration>
implements ConfigurationBuilder<T> {
    private static final String INDENT = "  ";
    private final Component root = new Component();
    private Component loggers;
    private Component appenders;
    private Component filters;
    private Component properties;
    private Component customLevels;
    private Component scripts;
    private final Class<T> clazz;
    private ConfigurationSource source;
    private int monitorInterval;
    private Level level;
    private String verbosity;
    private String destination;
    private String packages;
    private String shutdownFlag;
    private long shutdownTimeoutMillis;
    private String advertiser;
    private LoggerContext loggerContext;
    private String name;

    /*
     * WARNING - void declaration
     */
    public static void formatXml(Source source, Result result) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        void var1_1;
        Source source2;
        void var2_2;
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(2));
        transformer.setOutputProperty("indent", "yes");
        var2_2.transform(source2, (Result)var1_1);
    }

    public DefaultConfigurationBuilder() {
        this(BuiltConfiguration.class);
        this.root.addAttribute("name", "Built");
    }

    /*
     * WARNING - void declaration
     */
    public DefaultConfigurationBuilder(Class<T> clazz) {
        void var1_1;
        if (clazz == null) {
            throw new IllegalArgumentException("A Configuration class must be provided");
        }
        this.clazz = clazz;
        List<Component> components = this.root.getComponents();
        this.properties = new Component("Properties");
        components.add(this.properties);
        this.scripts = new Component("Scripts");
        components.add(this.scripts);
        this.customLevels = new Component("CustomLevels");
        components.add(this.customLevels);
        this.filters = new Component("Filters");
        components.add(this.filters);
        this.appenders = new Component("Appenders");
        components.add(this.appenders);
        this.loggers = new Component("Loggers");
        var1_1.add(this.loggers);
    }

    /*
     * WARNING - void declaration
     */
    protected ConfigurationBuilder<T> add(Component parent, ComponentBuilder<?> builder) {
        void var2_2;
        parent.getComponents().add((Component)var2_2.build());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder<T> add(AppenderComponentBuilder builder) {
        void var1_1;
        DefaultConfigurationBuilder defaultConfigurationBuilder = this;
        return defaultConfigurationBuilder.add(defaultConfigurationBuilder.appenders, (ComponentBuilder<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder<T> add(CustomLevelComponentBuilder builder) {
        void var1_1;
        DefaultConfigurationBuilder defaultConfigurationBuilder = this;
        return defaultConfigurationBuilder.add(defaultConfigurationBuilder.customLevels, (ComponentBuilder<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder<T> add(FilterComponentBuilder builder) {
        void var1_1;
        DefaultConfigurationBuilder defaultConfigurationBuilder = this;
        return defaultConfigurationBuilder.add(defaultConfigurationBuilder.filters, (ComponentBuilder<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder<T> add(ScriptComponentBuilder builder) {
        void var1_1;
        DefaultConfigurationBuilder defaultConfigurationBuilder = this;
        return defaultConfigurationBuilder.add(defaultConfigurationBuilder.scripts, (ComponentBuilder<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder<T> add(ScriptFileComponentBuilder builder) {
        void var1_1;
        DefaultConfigurationBuilder defaultConfigurationBuilder = this;
        return defaultConfigurationBuilder.add(defaultConfigurationBuilder.scripts, (ComponentBuilder<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder<T> add(LoggerComponentBuilder builder) {
        void var1_1;
        DefaultConfigurationBuilder defaultConfigurationBuilder = this;
        return defaultConfigurationBuilder.add(defaultConfigurationBuilder.loggers, (ComponentBuilder<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder<T> add(RootLoggerComponentBuilder builder) {
        void var1_1;
        for (Component component : this.loggers.getComponents()) {
            if (!component.getPluginType().equals("root")) continue;
            throw new ConfigurationException("Root Logger was previously defined");
        }
        DefaultConfigurationBuilder defaultConfigurationBuilder = this;
        return defaultConfigurationBuilder.add(defaultConfigurationBuilder.loggers, (ComponentBuilder<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder<T> addProperty(String key, String value) {
        void var2_2;
        void var1_1;
        this.properties.addComponent((Component)this.newComponent((String)var1_1, "Property", (String)var2_2).build());
        return this;
    }

    @Override
    public T build() {
        return (T)this.build(true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T build(boolean initialize) {
        void var1_1;
        BuiltConfiguration configuration;
        Constructor<T> constructor;
        try {
            if (this.source == null) {
                this.source = ConfigurationSource.NULL_SOURCE;
            }
            constructor = this.clazz.getConstructor(LoggerContext.class, ConfigurationSource.class, Component.class);
            configuration = (BuiltConfiguration)constructor.newInstance(this.loggerContext, this.source, this.root);
            configuration.getRootNode().getAttributes().putAll(this.root.getAttributes());
            if (this.name != null) {
                configuration.setName(this.name);
            }
            if (this.level != null) {
                configuration.getStatusConfiguration().withStatus(this.level);
            }
            if (this.verbosity != null) {
                configuration.getStatusConfiguration().withVerbosity(this.verbosity);
            }
            if (this.destination != null) {
                configuration.getStatusConfiguration().withDestination(this.destination);
            }
            if (this.packages != null) {
                configuration.setPluginPackages(this.packages);
            }
            if (this.shutdownFlag != null) {
                configuration.setShutdownHook(this.shutdownFlag);
            }
            if (this.shutdownTimeoutMillis > 0L) {
                configuration.setShutdownTimeoutMillis(this.shutdownTimeoutMillis);
            }
            if (this.advertiser != null) {
                configuration.createAdvertiser(this.advertiser, this.source);
            }
            configuration.setMonitorInterval(this.monitorInterval);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid Configuration class specified", ex);
        }
        configuration.getStatusConfiguration().initialize();
        if (var1_1 != false) {
            ((AbstractLifeCycle)configuration).initialize();
        }
        return (T)constructor;
    }

    /*
     * WARNING - void declaration
     */
    private String formatXml(String xml) throws TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
        void var2_2;
        void var1_1;
        StringWriter writer = new StringWriter();
        DefaultConfigurationBuilder.formatXml(new StreamSource(new StringReader((String)var1_1)), new StreamResult(writer));
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeXmlConfiguration(OutputStream output) throws IOException {
        try {
            XMLStreamWriter xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(output);
            this.writeXmlConfiguration(xmlWriter);
            xmlWriter.close();
            return;
        }
        catch (XMLStreamException xMLStreamException) {
            void var1_1;
            XMLStreamException e = xMLStreamException;
            if (xMLStreamException.getNestedException() instanceof IOException) {
                throw (IOException)e.getNestedException();
            }
            Throwables.rethrow((Throwable)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toXmlConfiguration() {
        StringWriter writer = new StringWriter();
        try {
            void var2_2;
            XMLStreamWriter xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(writer);
            this.writeXmlConfiguration(xmlWriter);
            var2_2.close();
            return this.formatXml(writer.toString());
        }
        catch (XMLStreamException | TransformerException exception) {
            void var1_1;
            Exception exception2 = exception;
            Throwables.rethrow(exception);
            return var1_1.toString();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeXmlConfiguration(XMLStreamWriter xmlWriter) throws XMLStreamException {
        void var1_1;
        xmlWriter.writeStartDocument();
        xmlWriter.writeStartElement("Configuration");
        if (this.name != null) {
            xmlWriter.writeAttribute("name", this.name);
        }
        if (this.level != null) {
            xmlWriter.writeAttribute("status", this.level.name());
        }
        if (this.verbosity != null) {
            xmlWriter.writeAttribute("verbose", this.verbosity);
        }
        if (this.destination != null) {
            xmlWriter.writeAttribute("dest", this.destination);
        }
        if (this.packages != null) {
            xmlWriter.writeAttribute("packages", this.packages);
        }
        if (this.shutdownFlag != null) {
            xmlWriter.writeAttribute("shutdownHook", this.shutdownFlag);
        }
        if (this.shutdownTimeoutMillis > 0L) {
            xmlWriter.writeAttribute("shutdownTimeout", String.valueOf(this.shutdownTimeoutMillis));
        }
        if (this.advertiser != null) {
            xmlWriter.writeAttribute("advertiser", this.advertiser);
        }
        if (this.monitorInterval > 0) {
            xmlWriter.writeAttribute("monitorInterval", String.valueOf(this.monitorInterval));
        }
        this.writeXmlSection(xmlWriter, this.properties);
        this.writeXmlSection(xmlWriter, this.scripts);
        this.writeXmlSection(xmlWriter, this.customLevels);
        if (this.filters.getComponents().size() == 1) {
            this.writeXmlComponent(xmlWriter, this.filters.getComponents().get(0));
        } else if (this.filters.getComponents().size() > 1) {
            this.writeXmlSection(xmlWriter, this.filters);
        }
        this.writeXmlSection(xmlWriter, this.appenders);
        this.writeXmlSection(xmlWriter, this.loggers);
        xmlWriter.writeEndElement();
        var1_1.writeEndDocument();
    }

    /*
     * WARNING - void declaration
     */
    private void writeXmlSection(XMLStreamWriter xmlWriter, Component component) throws XMLStreamException {
        if (!component.getAttributes().isEmpty() || !component.getComponents().isEmpty() || component.getValue() != null) {
            void var2_2;
            void var1_1;
            this.writeXmlComponent((XMLStreamWriter)var1_1, (Component)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeXmlComponent(XMLStreamWriter xmlWriter, Component component) throws XMLStreamException {
        void var2_2;
        void var1_1;
        if (!component.getComponents().isEmpty() || component.getValue() != null) {
            xmlWriter.writeStartElement(component.getPluginType());
            this.writeXmlAttributes(xmlWriter, component);
            for (Component subComponent : component.getComponents()) {
                this.writeXmlComponent(xmlWriter, subComponent);
            }
            if (component.getValue() != null) {
                xmlWriter.writeCharacters(component.getValue());
            }
            xmlWriter.writeEndElement();
            return;
        }
        xmlWriter.writeEmptyElement(component.getPluginType());
        this.writeXmlAttributes((XMLStreamWriter)var1_1, (Component)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void writeXmlAttributes(XMLStreamWriter xmlWriter, Component component) throws XMLStreamException {
        for (Map.Entry<String, String> attribute : component.getAttributes().entrySet()) {
            void var3_3;
            xmlWriter.writeAttribute(attribute.getKey(), (String)var3_3.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ScriptComponentBuilder newScript(String name, String language, String text) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new DefaultScriptComponentBuilder(this, (String)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ScriptFileComponentBuilder newScriptFile(String path) {
        void var1_1;
        void v0 = var1_1;
        return new DefaultScriptFileComponentBuilder(this, (String)v0, (String)v0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ScriptFileComponentBuilder newScriptFile(String name, String path) {
        void var2_2;
        void var1_1;
        return new DefaultScriptFileComponentBuilder(this, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AppenderComponentBuilder newAppender(String name, String type) {
        void var2_2;
        void var1_1;
        return new DefaultAppenderComponentBuilder(this, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AppenderRefComponentBuilder newAppenderRef(String ref) {
        void var1_1;
        return new DefaultAppenderRefComponentBuilder(this, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerComponentBuilder newAsyncLogger(String name) {
        void var1_1;
        return new DefaultLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, (String)var1_1, null, "AsyncLogger");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerComponentBuilder newAsyncLogger(String name, boolean includeLocation) {
        void var2_2;
        void var1_1;
        return new DefaultLoggerComponentBuilder(this, (String)var1_1, null, "AsyncLogger", (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerComponentBuilder newAsyncLogger(String name, Level level) {
        void var2_2;
        void var1_1;
        return new DefaultLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, (String)var1_1, var2_2.toString(), "AsyncLogger");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerComponentBuilder newAsyncLogger(String name, Level level, boolean includeLocation) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new DefaultLoggerComponentBuilder(this, (String)var1_1, var2_2.toString(), "AsyncLogger", (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerComponentBuilder newAsyncLogger(String name, String level) {
        void var2_2;
        void var1_1;
        return new DefaultLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, (String)var1_1, (String)var2_2, "AsyncLogger");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerComponentBuilder newAsyncLogger(String name, String level, boolean includeLocation) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new DefaultLoggerComponentBuilder(this, (String)var1_1, (String)var2_2, "AsyncLogger", (boolean)var3_3);
    }

    @Override
    public RootLoggerComponentBuilder newAsyncRootLogger() {
        return new DefaultRootLoggerComponentBuilder(this, "AsyncRoot");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RootLoggerComponentBuilder newAsyncRootLogger(boolean includeLocation) {
        void var1_1;
        return new DefaultRootLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, null, "AsyncRoot", (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RootLoggerComponentBuilder newAsyncRootLogger(Level level) {
        void var1_1;
        return new DefaultRootLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, var1_1.toString(), "AsyncRoot");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RootLoggerComponentBuilder newAsyncRootLogger(Level level, boolean includeLocation) {
        void var2_2;
        void var1_1;
        return new DefaultRootLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, var1_1.toString(), "AsyncRoot", (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RootLoggerComponentBuilder newAsyncRootLogger(String level) {
        void var1_1;
        return new DefaultRootLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, (String)var1_1, "AsyncRoot");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RootLoggerComponentBuilder newAsyncRootLogger(String level, boolean includeLocation) {
        void var2_2;
        void var1_1;
        return new DefaultRootLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, (String)var1_1, "AsyncRoot", (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B extends ComponentBuilder<B>> ComponentBuilder<B> newComponent(String type) {
        void var1_1;
        return new DefaultComponentBuilder(this, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B extends ComponentBuilder<B>> ComponentBuilder<B> newComponent(String name, String type) {
        void var2_2;
        void var1_1;
        return new DefaultComponentBuilder(this, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B extends ComponentBuilder<B>> ComponentBuilder<B> newComponent(String name, String type, String value) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new DefaultComponentBuilder(this, (String)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PropertyComponentBuilder newProperty(String name, String value) {
        void var2_2;
        void var1_1;
        return new DefaultPropertyComponentBuilder(this, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public KeyValuePairComponentBuilder newKeyValuePair(String key, String value) {
        void var2_2;
        void var1_1;
        return new DefaultKeyValuePairComponentBuilder(this, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CustomLevelComponentBuilder newCustomLevel(String name, int level) {
        void var2_2;
        void var1_1;
        return new DefaultCustomLevelComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, (String)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FilterComponentBuilder newFilter(String type, Filter.Result onMatch, Filter.Result onMismatch) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new DefaultFilterComponentBuilder(this, (String)var1_1, var2_2.name(), var3_3.name());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FilterComponentBuilder newFilter(String type, String onMatch, String onMismatch) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new DefaultFilterComponentBuilder(this, (String)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LayoutComponentBuilder newLayout(String type) {
        void var1_1;
        return new DefaultLayoutComponentBuilder(this, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerComponentBuilder newLogger(String name) {
        void var1_1;
        return new DefaultLoggerComponentBuilder(this, (String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerComponentBuilder newLogger(String name, boolean includeLocation) {
        void var2_2;
        void var1_1;
        return new DefaultLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, (String)var1_1, null, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerComponentBuilder newLogger(String name, Level level) {
        void var2_2;
        void var1_1;
        return new DefaultLoggerComponentBuilder(this, (String)var1_1, var2_2.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerComponentBuilder newLogger(String name, Level level, boolean includeLocation) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new DefaultLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, (String)var1_1, var2_2.toString(), (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerComponentBuilder newLogger(String name, String level) {
        void var2_2;
        void var1_1;
        return new DefaultLoggerComponentBuilder(this, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerComponentBuilder newLogger(String name, String level, boolean includeLocation) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new DefaultLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, (String)var1_1, (String)var2_2, (boolean)var3_3);
    }

    @Override
    public RootLoggerComponentBuilder newRootLogger() {
        return new DefaultRootLoggerComponentBuilder(this, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RootLoggerComponentBuilder newRootLogger(boolean includeLocation) {
        void var1_1;
        return new DefaultRootLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, null, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RootLoggerComponentBuilder newRootLogger(Level level) {
        void var1_1;
        return new DefaultRootLoggerComponentBuilder(this, var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RootLoggerComponentBuilder newRootLogger(Level level, boolean includeLocation) {
        void var2_2;
        void var1_1;
        return new DefaultRootLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, var1_1.toString(), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RootLoggerComponentBuilder newRootLogger(String level) {
        void var1_1;
        return new DefaultRootLoggerComponentBuilder(this, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RootLoggerComponentBuilder newRootLogger(String level, boolean includeLocation) {
        void var2_2;
        void var1_1;
        return new DefaultRootLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, (String)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder<T> setAdvertiser(String advertiser) {
        void var1_1;
        this.advertiser = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder<T> setConfigurationName(String name) {
        void var1_1;
        this.name = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder<T> setConfigurationSource(ConfigurationSource configurationSource) {
        void var1_1;
        this.source = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder<T> setMonitorInterval(String intervalSeconds) {
        void var1_1;
        this.monitorInterval = Integers.parseInt((String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder<T> setPackages(String packages) {
        void var1_1;
        this.packages = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder<T> setShutdownHook(String flag) {
        void var1_1;
        this.shutdownFlag = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder<T> setShutdownTimeout(long timeout, TimeUnit timeUnit) {
        void var1_1;
        void var3_2;
        this.shutdownTimeoutMillis = var3_2.toMillis((long)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder<T> setStatusLevel(Level level) {
        void var1_1;
        this.level = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder<T> setVerbosity(String verbosity) {
        void var1_1;
        this.verbosity = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder<T> setDestination(String destination) {
        void var1_1;
        this.destination = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLoggerContext(LoggerContext loggerContext) {
        void var1_1;
        this.loggerContext = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder<T> addRootProperty(String key, String value) {
        void var2_2;
        void var1_1;
        this.root.getAttributes().put((String)var1_1, (String)var2_2);
        return this;
    }
}

