/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.builder.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.config.builder.api.Component;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.config.plugins.util.ResolverUtil;
import org.apache.logging.log4j.core.config.status.StatusConfiguration;
import org.apache.logging.log4j.core.util.Patterns;

public class BuiltConfiguration
extends AbstractConfiguration {
    private static final String[] VERBOSE_CLASSES = new String[]{ResolverUtil.class.getName()};
    private final StatusConfiguration statusConfig = new StatusConfiguration().withVerboseClasses(VERBOSE_CLASSES).withStatus(this.getDefaultStatus());
    protected Component rootComponent;
    private Component loggersComponent;
    private Component appendersComponent;
    private Component filtersComponent;
    private Component propertiesComponent;
    private Component customLevelsComponent;
    private Component scriptsComponent;
    private String contentType = "text";

    /*
     * WARNING - void declaration
     */
    public BuiltConfiguration(LoggerContext loggerContext, ConfigurationSource source, Component rootComponent) {
        super((LoggerContext)((Object)iterator), source);
        void var3_3;
        Iterator<Component> iterator;
        for (Component component : rootComponent.getComponents()) {
            switch (component.getPluginType()) {
                case "Scripts": {
                    this.scriptsComponent = component;
                    break;
                }
                case "Loggers": {
                    this.loggersComponent = component;
                    break;
                }
                case "Appenders": {
                    this.appendersComponent = component;
                    break;
                }
                case "Filters": {
                    this.filtersComponent = component;
                    break;
                }
                case "Properties": {
                    this.propertiesComponent = component;
                    break;
                }
                case "CustomLevels": {
                    void var2_2;
                    this.customLevelsComponent = var2_2;
                }
            }
        }
        this.rootComponent = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setup() {
        List<Node> children = this.rootNode.getChildren();
        if (this.propertiesComponent.getComponents().size() > 0) {
            BuiltConfiguration builtConfiguration = this;
            children.add(builtConfiguration.convertToNode(builtConfiguration.rootNode, this.propertiesComponent));
        }
        if (this.scriptsComponent.getComponents().size() > 0) {
            BuiltConfiguration builtConfiguration = this;
            children.add(builtConfiguration.convertToNode(builtConfiguration.rootNode, this.scriptsComponent));
        }
        if (this.customLevelsComponent.getComponents().size() > 0) {
            BuiltConfiguration builtConfiguration = this;
            children.add(builtConfiguration.convertToNode(builtConfiguration.rootNode, this.customLevelsComponent));
        }
        BuiltConfiguration builtConfiguration = this;
        children.add(builtConfiguration.convertToNode(builtConfiguration.rootNode, this.loggersComponent));
        BuiltConfiguration builtConfiguration2 = this;
        children.add(builtConfiguration2.convertToNode(builtConfiguration2.rootNode, this.appendersComponent));
        if (this.filtersComponent.getComponents().size() > 0) {
            if (this.filtersComponent.getComponents().size() == 1) {
                BuiltConfiguration builtConfiguration3 = this;
                children.add(builtConfiguration3.convertToNode(builtConfiguration3.rootNode, this.filtersComponent.getComponents().get(0)));
            } else {
                void var1_1;
                BuiltConfiguration builtConfiguration4 = this;
                var1_1.add(builtConfiguration4.convertToNode(builtConfiguration4.rootNode, this.filtersComponent));
            }
        }
        this.rootComponent = null;
    }

    public String getContentType() {
        return this.contentType;
    }

    /*
     * WARNING - void declaration
     */
    public void setContentType(String contentType) {
        void var1_1;
        this.contentType = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void createAdvertiser(String advertiserString, ConfigurationSource configSource) {
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] buffer = null;
        try {
            InputStream is;
            if (configSource != null && (is = configSource.getInputStream()) != null) {
                buffer = BuiltConfiguration.toByteArray(is);
            }
        }
        catch (IOException iOException) {
            LOGGER.warn("Unable to read configuration source " + configSource.toString());
        }
        super.createAdvertiser((String)var1_1, (ConfigurationSource)var2_2, (byte[])var3_3, this.contentType);
    }

    public StatusConfiguration getStatusConfiguration() {
        return this.statusConfig;
    }

    /*
     * WARNING - void declaration
     */
    public void setPluginPackages(String packages) {
        void var1_1;
        this.pluginPackages.addAll(Arrays.asList(var1_1.split(Patterns.COMMA_SEPARATOR)));
    }

    /*
     * WARNING - void declaration
     */
    public void setShutdownHook(String flag) {
        void var1_1;
        this.isShutdownHookEnabled = !"disable".equalsIgnoreCase((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setShutdownTimeoutMillis(long shutdownTimeoutMillis) {
        void var1_1;
        this.shutdownTimeoutMillis = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setMonitorInterval(int intervalSeconds) {
        if (this instanceof Reconfigurable && intervalSeconds > 0) {
            void var1_1;
            BuiltConfiguration builtConfiguration = this;
            builtConfiguration.initializeWatchers((Reconfigurable)((Object)builtConfiguration), this.getConfigurationSource(), (int)var1_1);
        }
    }

    @Override
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    /*
     * WARNING - void declaration
     */
    protected Node convertToNode(Node parent, Component component) {
        void var1_1;
        Iterator<Component> iterator;
        String name = component.getPluginType();
        PluginType<?> pluginType = this.pluginManager.getPluginType(name);
        Node node = new Node(parent, name, pluginType);
        node.getAttributes().putAll(component.getAttributes());
        node.setValue(component.getValue());
        List<Node> children = node.getChildren();
        for (Component child : ((Component)((Object)iterator)).getComponents()) {
            children.add(this.convertToNode(node, child));
        }
        return var1_1;
    }
}

