/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.arbiters;

import java.util.Map;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.arbiters.Arbiter;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginNode;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.script.ScriptRef;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="ScriptArbiter", category="Core", elementType="Arbiter", deferChildren=true, printObject=true)
public class ScriptArbiter
implements Arbiter {
    private final AbstractScript script;
    private final Configuration configuration;

    /*
     * WARNING - void declaration
     */
    private ScriptArbiter(Configuration configuration, AbstractScript script) {
        void var2_2;
        void var1_1;
        this.configuration = var1_1;
        this.script = var2_2;
    }

    @Override
    public boolean isCondition() {
        Object object;
        SimpleBindings bindings = new SimpleBindings();
        bindings.putAll((Map<? extends String, ? extends Object>)this.configuration.getProperties());
        bindings.put("substitutor", (Object)this.configuration.getStrSubstitutor());
        object = this.configuration.getScriptManager().execute(this.script.getName(), (Bindings)object);
        return Boolean.parseBoolean(object.toString());
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<ScriptArbiter> {
        private static final Logger LOGGER = StatusLogger.getLogger();
        @PluginConfiguration
        private AbstractConfiguration configuration;
        @PluginNode
        private Node node;

        /*
         * WARNING - void declaration
         */
        public Builder setConfiguration(AbstractConfiguration configuration) {
            void var1_1;
            this.configuration = var1_1;
            return this.asBuilder();
        }

        /*
         * WARNING - void declaration
         */
        public Builder setNode(Node node) {
            void var1_1;
            this.node = var1_1;
            return this.asBuilder();
        }

        public Builder asBuilder() {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ScriptArbiter build() {
            void var1_1;
            AbstractScript script = null;
            for (Node child : this.node.getChildren()) {
                void var3_3;
                PluginType<?> type = child.getType();
                if (type == null) {
                    LOGGER.error("Node {} is missing a Plugintype", (Object)child.getName());
                    continue;
                }
                if (!AbstractScript.class.isAssignableFrom(type.getPluginClass())) continue;
                script = (AbstractScript)this.configuration.createPluginObject(type, child);
                this.node.getChildren().remove(var3_3);
                break;
            }
            if (script == null) {
                LOGGER.error("A Script, ScriptFile or ScriptRef element must be provided for this ScriptFilter");
                return null;
            }
            if (this.configuration.getScriptManager() == null) {
                LOGGER.error("Script support is not enabled");
                return null;
            }
            if (script instanceof ScriptRef) {
                if (this.configuration.getScriptManager().getScript(script.getName()) == null) {
                    LOGGER.error("No script with name {} has been declared.", (Object)script.getName());
                    return null;
                }
            } else if (!this.configuration.getScriptManager().addScript(script)) {
                return null;
            }
            return new ScriptArbiter(this.configuration, (AbstractScript)var1_1);
        }
    }
}

