/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.PropertiesPlugin;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.PluginValue;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="property", category="Core", printObject=true)
public final class Property {
    public static final Property[] EMPTY_ARRAY = new Property[0];
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final String name;
    private final String rawValue;
    private final String value;
    private final boolean valueNeedsLookup;

    /*
     * WARNING - void declaration
     */
    private Property(String name, String rawValue, String value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.name = var1_1;
        this.rawValue = var2_2;
        this.value = value;
        this.valueNeedsLookup = value != null && var3_3.contains("${");
    }

    public final String getName() {
        return this.name;
    }

    public final String getRawValue() {
        return Objects.toString(this.rawValue, "");
    }

    public final String getValue() {
        return Objects.toString(this.value, "");
    }

    public final boolean isValueNeedsLookup() {
        return this.valueNeedsLookup;
    }

    /*
     * WARNING - void declaration
     */
    public final String evaluate(StrSubstitutor substitutor) {
        if (this.valueNeedsLookup) {
            void var1_1;
            return var1_1.replace(PropertiesPlugin.unescape(this.getRawValue()));
        }
        return this.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public static Property createProperty(String name, String value) {
        void var1_1;
        void v0 = var1_1;
        return Property.createProperty(name, (String)v0, (String)v0);
    }

    /*
     * WARNING - void declaration
     */
    public static Property createProperty(String name, String rawValue, String value) {
        void var2_2;
        void var1_1;
        String string;
        if (name == null) {
            throw new IllegalArgumentException("Property name cannot be null");
        }
        return new Property(string, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static Property createProperty(@PluginAttribute(value="name") String name, @PluginValue(value="value", substitute=false) String rawValue, @PluginConfiguration Configuration configuration) {
        void var1_1;
        void var2_2;
        return Property.createProperty(name, rawValue, configuration == null ? rawValue : var2_2.getStrSubstitutor().replace((String)var1_1));
    }

    public final String toString() {
        return this.name + '=' + this.getValue();
    }
}

