/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.LookupResult;
import org.apache.logging.log4j.core.lookup.PropertiesLookup;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;

@Plugin(name="properties", category="Core", printObject=true)
public final class PropertiesPlugin {
    private static final StrSubstitutor UNESCAPING_SUBSTITUTOR = PropertiesPlugin.createUnescapingSubstitutor();

    private PropertiesPlugin() {
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static StrLookup configureSubstitutor(@PluginElement(value="Properties") Property[] properties, @PluginConfiguration Configuration config) {
        void var1_1;
        void var2_2;
        Property[] unescapedProperties = new Property[properties == null ? 0 : properties.length];
        for (int i = 0; i < unescapedProperties.length; ++i) {
            unescapedProperties[i] = PropertiesPlugin.unescape(properties[i]);
        }
        return new Interpolator(new PropertiesLookup((Property[])var2_2, config.getProperties()), var1_1.getPluginPackages());
    }

    private static Property unescape(Property input) {
        Property property;
        return Property.createProperty(input.getName(), PropertiesPlugin.unescape(input.getRawValue()), property.getValue());
    }

    static String unescape(String input) {
        String string;
        return UNESCAPING_SUBSTITUTOR.replace(string);
    }

    /*
     * WARNING - void declaration
     */
    private static StrSubstitutor createUnescapingSubstitutor() {
        void var0;
        StrSubstitutor substitutor = new StrSubstitutor(NullLookup.INSTANCE);
        substitutor.setValueDelimiter(null);
        substitutor.setValueDelimiterMatcher(null);
        return var0;
    }

    private static enum NullLookup implements StrLookup
    {
        INSTANCE;


        @Override
        public final String lookup(String key) {
            return null;
        }

        @Override
        public final String lookup(LogEvent event, String key) {
            return null;
        }

        @Override
        public final LookupResult evaluate(String key) {
            return null;
        }

        @Override
        public final LookupResult evaluate(LogEvent event, String key) {
            return null;
        }
    }
}

