/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.async.AsyncLoggerConfig;
import org.apache.logging.log4j.core.async.AsyncLoggerContext;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.AppenderControlArraySet;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultReliabilityStrategy;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.ReliabilityStrategy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.impl.DefaultLogEventFactory;
import org.apache.logging.log4j.core.impl.LocationAware;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.LogEventFactory;
import org.apache.logging.log4j.core.impl.ReusableLogEventFactory;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="logger", category="Core", printObject=true)
public class LoggerConfig
extends AbstractFilterable
implements LocationAware {
    public static final String ROOT = "root";
    private static LogEventFactory LOG_EVENT_FACTORY = null;
    private List<AppenderRef> appenderRefs = new ArrayList<AppenderRef>();
    private final AppenderControlArraySet appenders = new AppenderControlArraySet();
    private final String name;
    private LogEventFactory logEventFactory = LOG_EVENT_FACTORY;
    private Level level;
    private boolean additive = true;
    private boolean includeLocation = true;
    private LoggerConfig parent;
    private Map<Property, Boolean> propertiesMap;
    private final List<Property> properties;
    private final boolean propertiesRequireLookup;
    private final Configuration config;
    private final ReliabilityStrategy reliabilityStrategy;

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return new Builder().asBuilder();
    }

    public LoggerConfig() {
        this.level = Level.ERROR;
        this.name = "";
        this.properties = null;
        this.propertiesRequireLookup = false;
        this.config = null;
        this.reliabilityStrategy = new DefaultReliabilityStrategy(this);
    }

    /*
     * WARNING - void declaration
     */
    public LoggerConfig(String name, Level level, boolean additive) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.name = var1_1;
        this.level = var2_2;
        this.additive = var3_3;
        this.properties = null;
        this.propertiesRequireLookup = false;
        this.config = null;
        this.reliabilityStrategy = new DefaultReliabilityStrategy(this);
    }

    /*
     * WARNING - void declaration
     */
    protected LoggerConfig(String name, List<AppenderRef> appenders, Filter filter, Level level, boolean additive, Property[] properties, Configuration config, boolean includeLocation) {
        super((Filter)var3_3);
        void var2_2;
        void var1_1;
        void var3_3;
        this.name = var1_1;
        this.appenderRefs = var2_2;
        this.level = level;
        this.additive = additive;
        this.includeLocation = includeLocation;
        this.config = config;
        this.properties = properties != null && properties.length > 0 ? Collections.unmodifiableList(Arrays.asList(Arrays.copyOf(properties, properties.length))) : null;
        this.propertiesRequireLookup = LoggerConfig.containsPropertyRequiringLookup(properties);
        this.reliabilityStrategy = config.getReliabilityStrategy(this);
    }

    private static boolean containsPropertyRequiringLookup(Property[] properties) {
        if (properties == null) {
            return false;
        }
        for (int i = 0; i < properties.length; ++i) {
            if (!properties[i].isValueNeedsLookup()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Filter getFilter() {
        return super.getFilter();
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public void setParent(LoggerConfig parent) {
        void var1_1;
        this.parent = var1_1;
    }

    public LoggerConfig getParent() {
        return this.parent;
    }

    /*
     * WARNING - void declaration
     */
    public void addAppender(Appender appender, Level level, Filter filter) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.appenders.add(new AppenderControl((Appender)var1_1, (Level)var2_2, (Filter)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public void removeAppender(String name) {
        AppenderControl removed;
        while ((removed = this.appenders.remove(name)) != null) {
            void var2_2;
            this.cleanupFilter((AppenderControl)var2_2);
        }
    }

    public Map<String, Appender> getAppenders() {
        return this.appenders.asMap();
    }

    protected void clearAppenders() {
        do {
            AppenderControl[] appenderControlArray = this.appenders.clear();
            AppenderControl[] appenderControlArray2 = appenderControlArray;
            appenderControlArray2 = appenderControlArray;
            int n = appenderControlArray.length;
            for (int i = 0; i < n; ++i) {
                AppenderControl ctl = appenderControlArray2[i];
                this.cleanupFilter(ctl);
            }
        } while (!this.appenders.isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    private void cleanupFilter(AppenderControl ctl) {
        Filter filter = ctl.getFilter();
        if (filter != null) {
            void var2_2;
            void var1_1;
            var1_1.removeFilter(filter);
            var2_2.stop();
        }
    }

    public List<AppenderRef> getAppenderRefs() {
        return this.appenderRefs;
    }

    /*
     * WARNING - void declaration
     */
    public void setLevel(Level level) {
        void var1_1;
        this.level = var1_1;
    }

    public Level getLevel() {
        if (this.level == null) {
            if (this.parent == null) {
                return Level.ERROR;
            }
            return this.parent.getLevel();
        }
        return this.level;
    }

    public Level getExplicitLevel() {
        return this.level;
    }

    public LogEventFactory getLogEventFactory() {
        return this.logEventFactory;
    }

    /*
     * WARNING - void declaration
     */
    public void setLogEventFactory(LogEventFactory logEventFactory) {
        void var1_1;
        this.logEventFactory = var1_1;
    }

    public boolean isAdditive() {
        return this.additive;
    }

    /*
     * WARNING - void declaration
     */
    public void setAdditive(boolean additive) {
        void var1_1;
        this.additive = var1_1;
    }

    public boolean isIncludeLocation() {
        return this.includeLocation;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public Map<Property, Boolean> getProperties() {
        if (this.properties == null) {
            return null;
        }
        if (this.propertiesMap == null) {
            void var1_1;
            HashMap<Property, Boolean> result = new HashMap<Property, Boolean>(this.properties.size() << 1);
            for (int i = 0; i < this.properties.size(); ++i) {
                result.put(this.properties.get(i), this.properties.get(i).isValueNeedsLookup());
            }
            this.propertiesMap = Collections.unmodifiableMap(var1_1);
        }
        return this.propertiesMap;
    }

    public List<Property> getPropertyList() {
        return this.properties;
    }

    public boolean isPropertiesRequireLookup() {
        return this.propertiesRequireLookup;
    }

    /*
     * WARNING - void declaration
     */
    @PerformanceSensitive(value={"allocation"})
    public void log(String loggerName, String fqcn, Marker marker, Level level, Message data, Throwable t) {
        void var2_2;
        void var3_4;
        List<Property> props = this.getProperties(loggerName, fqcn, marker, level, data, t);
        LogEvent logEvent = this.logEventFactory.createEvent(loggerName, (Marker)var3_4, fqcn, this.location((String)var2_2), level, data, props, t);
        try {
            this.log(logEvent, LoggerConfigPredicate.ALL);
        }
        catch (Throwable throwable) {
            void var1_1;
            ReusableLogEventFactory.release((LogEvent)var1_1);
            throw throwable;
        }
        ReusableLogEventFactory.release(logEvent);
    }

    /*
     * WARNING - void declaration
     */
    private StackTraceElement location(String fqcn) {
        if (this.requiresLocation()) {
            void var1_1;
            return StackLocatorUtil.calcLocation((String)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @PerformanceSensitive(value={"allocation"})
    public void log(String loggerName, String fqcn, StackTraceElement location, Marker marker, Level level, Message data, Throwable t) {
        void var3_4;
        void var2_2;
        List<Property> props = this.getProperties(loggerName, fqcn, marker, level, data, t);
        LogEvent logEvent = this.logEventFactory.createEvent(loggerName, marker, (String)var2_2, (StackTraceElement)var3_4, level, data, props, t);
        try {
            this.log(logEvent, LoggerConfigPredicate.ALL);
        }
        catch (Throwable throwable) {
            void var1_1;
            ReusableLogEventFactory.release((LogEvent)var1_1);
            throw throwable;
        }
        ReusableLogEventFactory.release(logEvent);
    }

    /*
     * WARNING - void declaration
     */
    private List<Property> getProperties(String loggerName, String fqcn, Marker marker, Level level, Message data, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        List<Property> snapshot = this.properties;
        if (snapshot == null || !this.propertiesRequireLookup) {
            return snapshot;
        }
        return this.getPropertiesWithLookups((String)var1_1, (String)var2_2, (Marker)var3_3, level, data, t, snapshot);
    }

    /*
     * WARNING - void declaration
     */
    private List<Property> getPropertiesWithLookups(String loggerName, String fqcn, Marker marker, Level level, Message data, Throwable t, List<Property> props) {
        ArrayList<Property> results = new ArrayList<Property>(props.size());
        Log4jLogEvent.newBuilder().setMessage(data).setMarker(marker).setLevel(level).setLoggerName(loggerName).setLoggerFqcn(fqcn).setThrown(t).build();
        for (int i = 0; i < props.size(); ++i) {
            void var3_4;
            void var2_3;
            Property prop = props.get(i);
            String value = prop.evaluate(this.config.getStrSubstitutor());
            results.add(Property.createProperty(prop.getName(), var2_3.getRawValue(), (String)var3_4));
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    public void log(LogEvent event) {
        void var1_1;
        this.log((LogEvent)var1_1, LoggerConfigPredicate.ALL);
    }

    /*
     * WARNING - void declaration
     */
    protected void log(LogEvent event, LoggerConfigPredicate predicate) {
        if (!this.isFiltered(event)) {
            void var2_2;
            void var1_1;
            this.processLogEvent((LogEvent)var1_1, (LoggerConfigPredicate)var2_2);
        }
    }

    public ReliabilityStrategy getReliabilityStrategy() {
        return this.reliabilityStrategy;
    }

    /*
     * WARNING - void declaration
     */
    private void processLogEvent(LogEvent event, LoggerConfigPredicate predicate) {
        void var2_2;
        void var1_1;
        event.setIncludeLocation(this.isIncludeLocation());
        if (predicate.allow(this)) {
            this.callAppenders(event);
        }
        this.logParent((LogEvent)var1_1, (LoggerConfigPredicate)var2_2);
    }

    @Override
    public boolean requiresLocation() {
        if (!this.includeLocation) {
            return false;
        }
        AppenderControl[] controls = this.appenders.get();
        LoggerConfig loggerConfig = this;
        while (loggerConfig != null) {
            AppenderControl[] appenderControlArray = controls;
            int n = controls.length;
            for (int i = 0; i < n; ++i) {
                AppenderControl appenderControl = appenderControlArray[i];
                Appender appender = appenderControl.getAppender();
                if (!(appender instanceof LocationAware) || !((LocationAware)((Object)appender)).requiresLocation()) continue;
                return true;
            }
            if (!loggerConfig.additive) break;
            loggerConfig = loggerConfig.parent;
            if (loggerConfig == null) continue;
            controls = loggerConfig.appenders.get();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void logParent(LogEvent event, LoggerConfigPredicate predicate) {
        if (this.additive && this.parent != null) {
            void var2_2;
            void var1_1;
            this.parent.log((LogEvent)var1_1, (LoggerConfigPredicate)var2_2);
        }
    }

    @PerformanceSensitive(value={"allocation"})
    protected void callAppenders(LogEvent event) {
        AppenderControl[] controls = this.appenders.get();
        for (int i = 0; i < controls.length; ++i) {
            controls[i].callAppender(event);
        }
    }

    public String toString() {
        if (Strings.isEmpty((CharSequence)this.name)) {
            return ROOT;
        }
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static LoggerConfig createLogger(String additivity, Level level, @PluginAttribute(value="name") String loggerName, String includeLocation, AppenderRef[] refs, Property[] properties, @PluginConfiguration Configuration config, Filter filter) {
        void var3_4;
        void var0_1;
        void var1_2;
        void var2_3;
        String name;
        if (loggerName == null) {
            LOGGER.error("Loggers cannot be configured without a name");
            return null;
        }
        List<AppenderRef> appenderRefs = Arrays.asList(refs);
        name = loggerName.equals(ROOT) ? "" : name;
        boolean additive = Booleans.parseBoolean(additivity, true);
        return new LoggerConfig((String)var2_3, appenderRefs, filter, (Level)var1_2, (boolean)var0_1, properties, config, LoggerConfig.includeLocation((String)var3_4, config));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static LoggerConfig createLogger(@PluginAttribute(value="additivity", defaultBoolean=true) boolean additivity, @PluginAttribute(value="level") Level level, @Required(message="Loggers cannot be configured without a name") @PluginAttribute(value="name") String loggerName, @PluginAttribute(value="includeLocation") String includeLocation, @PluginElement(value="AppenderRef") AppenderRef[] refs, @PluginElement(value="Properties") Property[] properties, @PluginConfiguration Configuration config, @PluginElement(value="Filter") Filter filter) {
        void var3_3;
        boolean bl;
        void var1_1;
        void var2_2;
        String name;
        name = loggerName.equals(ROOT) ? "" : name;
        return new LoggerConfig((String)var2_2, Arrays.asList(refs), filter, (Level)var1_1, bl, properties, config, LoggerConfig.includeLocation((String)var3_3, config));
    }

    protected static boolean includeLocation(String includeLocationConfigValue) {
        return LoggerConfig.includeLocation(includeLocationConfigValue, null);
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean includeLocation(String includeLocationConfigValue, Configuration configuration) {
        Object object;
        if (includeLocationConfigValue == null) {
            Object context = null;
            if (configuration != null) {
                void var1_1;
                context = var1_1.getLoggerContext();
            }
            if (context != null) {
                return !(object instanceof AsyncLoggerContext);
            }
            return !AsyncLoggerContextSelector.isSelected();
        }
        return Boolean.parseBoolean((String)object);
    }

    protected final boolean hasAppenders() {
        return !this.appenders.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    protected static LevelAndRefs getLevelAndRefs(Level level, AppenderRef[] refs, String levelAndRefs, Configuration config) {
        void var1_1;
        String[] stringArray;
        LevelAndRefs result = new LevelAndRefs();
        if (levelAndRefs != null) {
            void var3_3;
            if (var3_3 instanceof PropertiesConfiguration) {
                void var2_2;
                if (level != null) {
                    LOGGER.warn("Level is ignored when levelAndRefs syntax is used.");
                }
                if (refs != null && refs.length > 0) {
                    LOGGER.warn("Appender references are ignored when levelAndRefs syntax is used");
                }
                String[] parts = Strings.splitList((String)var2_2);
                result.level = Level.getLevel((String)parts[0]);
                if (parts.length > 1) {
                    ArrayList refList = new ArrayList();
                    Arrays.stream(stringArray).skip(1L).forEach(ref -> {
                        void var1_1;
                        refList.add(AppenderRef.createAppenderRef((String)var1_1, null, null));
                    });
                    result.refs = var1_1;
                }
            } else {
                LOGGER.warn("levelAndRefs are only allowed in a properties configuration. The value is ignored.");
                result.level = stringArray;
                result.refs = var1_1 != null ? Arrays.asList(var1_1) : new ArrayList<AppenderRef>();
            }
        } else {
            result.level = stringArray;
            result.refs = var1_1 != null ? Arrays.asList(var1_1) : new ArrayList<AppenderRef>();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    static {
        String factory = PropertiesUtil.getProperties().getStringProperty("Log4jLogEventFactory");
        if (factory != null) {
            try {
                Class<?> clazz = Loader.loadClass(factory);
                if (clazz != null && LogEventFactory.class.isAssignableFrom(clazz)) {
                    LOG_EVENT_FACTORY = (LogEventFactory)clazz.newInstance();
                }
            }
            catch (Exception ex) {
                void var1_2;
                void var0;
                LOGGER.error("Unable to create LogEventFactory {}", (Object)var0, (Object)var1_2);
            }
        }
        if (LOG_EVENT_FACTORY == null) {
            LOG_EVENT_FACTORY = Constants.ENABLE_THREADLOCALS ? new ReusableLogEventFactory() : new DefaultLogEventFactory();
        }
    }

    protected static enum LoggerConfigPredicate {
        ALL{

            @Override
            final boolean allow(LoggerConfig config) {
                return true;
            }
        }
        ,
        ASYNCHRONOUS_ONLY{

            @Override
            final boolean allow(LoggerConfig config) {
                return config instanceof AsyncLoggerConfig;
            }
        }
        ,
        SYNCHRONOUS_ONLY{

            /*
             * WARNING - void declaration
             */
            @Override
            final boolean allow(LoggerConfig config) {
                void var1_1;
                return !ASYNCHRONOUS_ONLY.allow((LoggerConfig)var1_1);
            }
        };


        abstract boolean allow(LoggerConfig var1);
    }

    protected static class LevelAndRefs {
        public Level level;
        public List<AppenderRef> refs;

        protected LevelAndRefs() {
        }
    }

    @Plugin(name="root", category="Core", printObject=true)
    public static class RootLogger
    extends LoggerConfig {
        @PluginBuilderFactory
        public static <B extends Builder<B>> B newRootBuilder() {
            return new Builder().asBuilder();
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public static LoggerConfig createLogger(@PluginAttribute(value="additivity") String additivity, @PluginAttribute(value="level") Level level, @PluginAttribute(value="includeLocation") String includeLocation, @PluginElement(value="AppenderRef") AppenderRef[] refs, @PluginElement(value="Properties") Property[] properties, @PluginConfiguration Configuration config, @PluginElement(value="Filter") Filter filter) {
            void var2_3;
            void var0_1;
            void var1_2;
            void var3_4;
            Level actualLevel;
            List<AppenderRef> appenderRefs = Arrays.asList(refs);
            actualLevel = level == null ? Level.ERROR : actualLevel;
            boolean additive = Booleans.parseBoolean(additivity, true);
            return new LoggerConfig("", (List<AppenderRef>)var3_4, filter, (Level)var1_2, (boolean)var0_1, properties, config, RootLogger.includeLocation((String)var2_3, config));
        }

        public static class Builder<B extends Builder<B>>
        implements org.apache.logging.log4j.core.util.Builder<LoggerConfig> {
            @PluginBuilderAttribute
            private boolean additivity;
            @PluginBuilderAttribute
            private Level level;
            @PluginBuilderAttribute
            private String levelAndRefs;
            @PluginBuilderAttribute
            private String includeLocation;
            @PluginElement(value="AppenderRef")
            private AppenderRef[] refs;
            @PluginElement(value="Properties")
            private Property[] properties;
            @PluginConfiguration
            private Configuration config;
            @PluginElement(value="Filter")
            private Filter filter;

            public boolean isAdditivity() {
                return this.additivity;
            }

            /*
             * WARNING - void declaration
             */
            public B withAdditivity(boolean additivity) {
                void var1_1;
                this.additivity = var1_1;
                return this.asBuilder();
            }

            public Level getLevel() {
                return this.level;
            }

            /*
             * WARNING - void declaration
             */
            public B withLevel(Level level) {
                void var1_1;
                this.level = var1_1;
                return this.asBuilder();
            }

            public String getLevelAndRefs() {
                return this.levelAndRefs;
            }

            /*
             * WARNING - void declaration
             */
            public B withLevelAndRefs(String levelAndRefs) {
                void var1_1;
                this.levelAndRefs = var1_1;
                return this.asBuilder();
            }

            public String getIncludeLocation() {
                return this.includeLocation;
            }

            /*
             * WARNING - void declaration
             */
            public B withIncludeLocation(String includeLocation) {
                void var1_1;
                this.includeLocation = var1_1;
                return this.asBuilder();
            }

            public AppenderRef[] getRefs() {
                return this.refs;
            }

            /*
             * WARNING - void declaration
             */
            public B withRefs(AppenderRef[] refs) {
                void var1_1;
                this.refs = var1_1;
                return this.asBuilder();
            }

            public Property[] getProperties() {
                return this.properties;
            }

            /*
             * WARNING - void declaration
             */
            public B withProperties(Property[] properties) {
                void var1_1;
                this.properties = var1_1;
                return this.asBuilder();
            }

            public Configuration getConfig() {
                return this.config;
            }

            /*
             * WARNING - void declaration
             */
            public B withConfig(Configuration config) {
                void var1_1;
                this.config = var1_1;
                return this.asBuilder();
            }

            public Filter getFilter() {
                return this.filter;
            }

            /*
             * WARNING - void declaration
             */
            public B withtFilter(Filter filter) {
                void var1_1;
                this.filter = var1_1;
                return this.asBuilder();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public LoggerConfig build() {
                void var1_1;
                LevelAndRefs container = LoggerConfig.getLevelAndRefs(this.level, this.refs, this.levelAndRefs, this.config);
                return new LoggerConfig("", container.refs, this.filter, var1_1.level, this.additivity, this.properties, this.config, LoggerConfig.includeLocation(this.includeLocation, this.config));
            }

            public B asBuilder() {
                return (B)this;
            }
        }
    }

    public static class Builder<B extends Builder<B>>
    implements org.apache.logging.log4j.core.util.Builder<LoggerConfig> {
        @PluginBuilderAttribute
        private Boolean additivity;
        @PluginBuilderAttribute
        private Level level;
        @PluginBuilderAttribute
        private String levelAndRefs;
        @PluginBuilderAttribute(value="name")
        @Required(message="Loggers cannot be configured without a name")
        private String loggerName;
        @PluginBuilderAttribute
        private String includeLocation;
        @PluginElement(value="AppenderRef")
        private AppenderRef[] refs;
        @PluginElement(value="Properties")
        private Property[] properties;
        @PluginConfiguration
        private Configuration config;
        @PluginElement(value="Filter")
        private Filter filter;

        public boolean isAdditivity() {
            return this.additivity == null || this.additivity != false;
        }

        /*
         * WARNING - void declaration
         */
        public B withAdditivity(boolean additivity) {
            void var1_1;
            this.additivity = (boolean)var1_1;
            return this.asBuilder();
        }

        public Level getLevel() {
            return this.level;
        }

        /*
         * WARNING - void declaration
         */
        public B withLevel(Level level) {
            void var1_1;
            this.level = var1_1;
            return this.asBuilder();
        }

        public String getLevelAndRefs() {
            return this.levelAndRefs;
        }

        /*
         * WARNING - void declaration
         */
        public B withLevelAndRefs(String levelAndRefs) {
            void var1_1;
            this.levelAndRefs = var1_1;
            return this.asBuilder();
        }

        public String getLoggerName() {
            return this.loggerName;
        }

        /*
         * WARNING - void declaration
         */
        public B withLoggerName(String loggerName) {
            void var1_1;
            this.loggerName = var1_1;
            return this.asBuilder();
        }

        public String getIncludeLocation() {
            return this.includeLocation;
        }

        /*
         * WARNING - void declaration
         */
        public B withIncludeLocation(String includeLocation) {
            void var1_1;
            this.includeLocation = var1_1;
            return this.asBuilder();
        }

        public AppenderRef[] getRefs() {
            return this.refs;
        }

        /*
         * WARNING - void declaration
         */
        public B withRefs(AppenderRef[] refs) {
            void var1_1;
            this.refs = var1_1;
            return this.asBuilder();
        }

        public Property[] getProperties() {
            return this.properties;
        }

        /*
         * WARNING - void declaration
         */
        public B withProperties(Property[] properties) {
            void var1_1;
            this.properties = var1_1;
            return this.asBuilder();
        }

        public Configuration getConfig() {
            return this.config;
        }

        /*
         * WARNING - void declaration
         */
        public B withConfig(Configuration config) {
            void var1_1;
            this.config = var1_1;
            return this.asBuilder();
        }

        public Filter getFilter() {
            return this.filter;
        }

        /*
         * WARNING - void declaration
         */
        public B withtFilter(Filter filter) {
            void var1_1;
            this.filter = var1_1;
            return this.asBuilder();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public LoggerConfig build() {
            void var3_3;
            void var2_2;
            void var1_1;
            String name = this.loggerName.equals(LoggerConfig.ROOT) ? "" : this.loggerName;
            LevelAndRefs container = LoggerConfig.getLevelAndRefs(this.level, this.refs, this.levelAndRefs, this.config);
            boolean useLocation = LoggerConfig.includeLocation(this.includeLocation, this.config);
            return new LoggerConfig((String)var1_1, container.refs, this.filter, var2_2.level, this.isAdditivity(), this.properties, this.config, (boolean)var3_3);
        }

        public B asBuilder() {
            return (B)this;
        }
    }
}

