/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LocationAwareReliabilityStrategy;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.ReliabilityStrategy;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.Supplier;

public class LockingReliabilityStrategy
implements LocationAwareReliabilityStrategy,
ReliabilityStrategy {
    private final LoggerConfig loggerConfig;
    private final ReadWriteLock reconfigureLock = new ReentrantReadWriteLock();
    private volatile boolean isStopping;

    /*
     * WARNING - void declaration
     */
    public LockingReliabilityStrategy(LoggerConfig loggerConfig) {
        void var1_1;
        this.loggerConfig = (LoggerConfig)Objects.requireNonNull(var1_1, "loggerConfig was null");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Supplier<LoggerConfig> reconfigured, String loggerName, String fqcn, Marker marker, Level level, Message data, Throwable t) {
        LoggerConfig config = this.getActiveLoggerConfig(reconfigured);
        try {
            void var3_4;
            void var2_2;
            config.log((String)var2_2, (String)var3_4, marker, level, data, t);
            config.getReliabilityStrategy().afterLogEvent();
            return;
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.getReliabilityStrategy().afterLogEvent();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Supplier<LoggerConfig> reconfigured, String loggerName, String fqcn, StackTraceElement location, Marker marker, Level level, Message data, Throwable t) {
        LoggerConfig config = this.getActiveLoggerConfig(reconfigured);
        try {
            void var3_4;
            void var2_2;
            config.log((String)var2_2, (String)var3_4, location, marker, level, data, t);
            config.getReliabilityStrategy().afterLogEvent();
            return;
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.getReliabilityStrategy().afterLogEvent();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Supplier<LoggerConfig> reconfigured, LogEvent event) {
        LoggerConfig config = this.getActiveLoggerConfig(reconfigured);
        try {
            void var2_2;
            config.log((LogEvent)var2_2);
            config.getReliabilityStrategy().afterLogEvent();
            return;
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.getReliabilityStrategy().afterLogEvent();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerConfig getActiveLoggerConfig(Supplier<LoggerConfig> next) {
        void var2_2;
        LoggerConfig result = this.loggerConfig;
        if (!this.beforeLogEvent()) {
            void var1_1;
            result = (LoggerConfig)next.get();
            if (result == this.loggerConfig) {
                return result;
            }
            return result.getReliabilityStrategy().getActiveLoggerConfig((Supplier<LoggerConfig>)var1_1);
        }
        return var2_2;
    }

    private boolean beforeLogEvent() {
        this.reconfigureLock.readLock().lock();
        if (this.isStopping) {
            this.reconfigureLock.readLock().unlock();
            return false;
        }
        return true;
    }

    @Override
    public void afterLogEvent() {
        this.reconfigureLock.readLock().unlock();
    }

    @Override
    public void beforeStopAppenders() {
        this.reconfigureLock.writeLock().lock();
        try {
            this.isStopping = true;
            return;
        }
        finally {
            this.reconfigureLock.writeLock().unlock();
        }
    }

    @Override
    public void beforeStopConfiguration(Configuration configuration) {
    }
}

