/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.apache.logging.log4j.util.Strings;

public final class Configurator {
    private static final String FQCN = Configurator.class.getName();
    private static final Logger LOGGER = StatusLogger.getLogger();

    /*
     * WARNING - void declaration
     */
    private static Log4jContextFactory getFactory() {
        LoggerContextFactory factory = LogManager.getFactory();
        if (factory instanceof Log4jContextFactory) {
            return (Log4jContextFactory)factory;
        }
        if (factory != null) {
            void var0;
            LOGGER.error("LogManager returned an instance of {} which does not implement {}. Unable to initialize Log4j.", (Object)var0.getClass().getName(), (Object)Log4jContextFactory.class.getName());
        } else {
            LOGGER.fatal("LogManager did not return a LoggerContextFactory. This indicates something has gone terribly wrong!");
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static LoggerContext initialize(ClassLoader loader, ConfigurationSource source) {
        void var1_1;
        return Configurator.initialize(loader, (ConfigurationSource)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static LoggerContext initialize(ClassLoader loader, ConfigurationSource source, Object externalContext) {
        try {
            void var2_2;
            ClassLoader classLoader;
            Log4jContextFactory factory = Configurator.getFactory();
            if (factory == null) {
                return null;
            }
            return factory.getContext(FQCN, classLoader, (Object)var2_2, false, source);
        }
        catch (Exception ex) {
            void var3_4;
            void var1_1;
            LOGGER.error("There was a problem obtaining a LoggerContext using the configuration source [{}]", (Object)var1_1, (Object)var3_4);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static LoggerContext initialize(String name, ClassLoader loader, String configLocation) {
        void var2_2;
        void var1_1;
        return Configurator.initialize(name, (ClassLoader)var1_1, (String)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static LoggerContext initialize(String name, ClassLoader loader, String configLocation, Object externalContext) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        if (Strings.isBlank((String)configLocation)) {
            return Configurator.initialize(name, loader, null, externalContext);
        }
        if (configLocation.contains(",")) {
            return Configurator.initialize(name, loader, NetUtils.toURIs(configLocation), externalContext);
        }
        return Configurator.initialize(string, (ClassLoader)var1_1, NetUtils.toURI((String)var2_2), (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static LoggerContext initialize(String name, ClassLoader loader, URI configLocation) {
        void var2_2;
        void var1_1;
        return Configurator.initialize(name, (ClassLoader)var1_1, (URI)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static LoggerContext initialize(String name, ClassLoader loader, URI configLocation, Object externalContext) {
        try {
            void var3_3;
            void var1_1;
            Log4jContextFactory factory = Configurator.getFactory();
            if (factory == null) {
                return null;
            }
            return factory.getContext(FQCN, (ClassLoader)var1_1, (Object)var3_3, false, configLocation, name);
        }
        catch (Exception ex) {
            void var2_2;
            String string;
            LOGGER.error("There was a problem initializing the LoggerContext [{}] using configuration at [{}].", (Object)string, (Object)var2_2, (Object)ex);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static LoggerContext initialize(String name, ClassLoader loader, URI configLocation, Map.Entry<String, Object> entry) {
        try {
            void var3_3;
            void var1_1;
            Log4jContextFactory factory = Configurator.getFactory();
            if (factory == null) {
                return null;
            }
            return factory.getContext(FQCN, (ClassLoader)var1_1, (Map.Entry<String, Object>)var3_3, false, configLocation, name);
        }
        catch (Exception ex) {
            void var2_2;
            String string;
            LOGGER.error("There was a problem initializing the LoggerContext [{}] using configuration at [{}].", (Object)string, (Object)var2_2, (Object)ex);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static LoggerContext initialize(String name, ClassLoader loader, List<URI> configLocations, Object externalContext) {
        try {
            void var3_3;
            void var1_1;
            Log4jContextFactory factory = Configurator.getFactory();
            if (factory == null) {
                return null;
            }
            return factory.getContext(FQCN, (ClassLoader)var1_1, (Object)var3_3, false, configLocations, name);
        }
        catch (Exception ex) {
            void var2_2;
            String string;
            LOGGER.error("There was a problem initializing the LoggerContext [{}] using configurations at [{}].", (Object)string, (Object)var2_2, (Object)ex);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static LoggerContext initialize(String name, String configLocation) {
        void var1_1;
        return Configurator.initialize(name, null, (String)var1_1);
    }

    public static LoggerContext initialize(Configuration configuration) {
        Configuration configuration2;
        return Configurator.initialize(null, configuration2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static LoggerContext initialize(ClassLoader loader, Configuration configuration) {
        void var1_1;
        return Configurator.initialize(loader, (Configuration)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static LoggerContext initialize(ClassLoader loader, Configuration configuration, Object externalContext) {
        try {
            void var2_2;
            ClassLoader classLoader;
            Log4jContextFactory factory = Configurator.getFactory();
            if (factory == null) {
                return null;
            }
            return factory.getContext(FQCN, classLoader, (Object)var2_2, false, configuration);
        }
        catch (Exception ex) {
            void var3_4;
            void var1_1;
            LOGGER.error("There was a problem initializing the LoggerContext using configuration {}", (Object)var1_1.getName(), (Object)var3_4);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void reconfigure(Configuration configuration) {
        try {
            Log4jContextFactory factory = Configurator.getFactory();
            if (factory != null) {
                factory.getContext(FQCN, null, null, false).reconfigure(configuration);
            }
            return;
        }
        catch (Exception ex) {
            void var1_2;
            Configuration configuration2;
            LOGGER.error("There was a problem initializing the LoggerContext using configuration {}", (Object)configuration2.getName(), (Object)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void reconfigure() {
        try {
            Log4jContextFactory factory = Configurator.getFactory();
            if (factory == null) {
                LOGGER.warn("Unable to reconfigure - Log4j has not been initialized.");
                return;
            }
            factory.getSelector().getContext(FQCN, null, false).reconfigure();
        }
        catch (Exception ex) {
            void var0_1;
            LOGGER.error("Error encountered trying to reconfigure logging", (Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void reconfigure(URI uri) {
        try {
            URI uRI;
            Log4jContextFactory factory = Configurator.getFactory();
            if (factory == null) {
                LOGGER.warn("Unable to reconfigure - Log4j has not been initialized.");
                return;
            }
            factory.getSelector().getContext(FQCN, null, false).setConfigLocation(uRI);
        }
        catch (Exception ex) {
            void var1_2;
            LOGGER.error("Error encountered trying to reconfigure logging", (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setAllLevels(String parentLogger, Level level) {
        Iterator<Map.Entry<String, LoggerConfig>> iterator;
        LoggerContext loggerContext = LoggerContext.getContext(StackLocatorUtil.getCallerClassLoader((int)2), false, null);
        Configuration config = loggerContext.getConfiguration();
        boolean set = Configurator.setLevel(parentLogger, level, config);
        for (Map.Entry<String, LoggerConfig> entry : iterator.getLoggers().entrySet()) {
            if (!entry.getKey().startsWith(parentLogger)) continue;
            set |= Configurator.setLevel(entry.getValue(), level);
        }
        if (set) {
            void var2_2;
            var2_2.updateLoggers();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Logger setLevel(Logger logger, Level level) {
        Logger logger2;
        void var1_1;
        Configurator.setLevel(LoggerContext.getContext(StackLocatorUtil.getCallerClassLoader((int)2), false, null), logger.getName(), (Level)var1_1);
        return logger2;
    }

    /*
     * WARNING - void declaration
     */
    public static void setLevel(Class<?> clazz, Level level) {
        void var1_1;
        Class<?> clazz2;
        void var2_2;
        String canonicalName = clazz.getCanonicalName();
        Configurator.setLevel(LoggerContext.getContext(StackLocatorUtil.getCallerClassLoader((int)2), false, null), (String)(canonicalName != null ? var2_2 : clazz2.getName()), (Level)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean setLevel(LoggerConfig loggerConfig, Level level) {
        void var2_2;
        boolean set = !loggerConfig.getLevel().equals((Object)level);
        if (set) {
            void var1_1;
            LoggerConfig loggerConfig2;
            loggerConfig2.setLevel((Level)var1_1);
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static void setLevel(LoggerContext loggerContext, String loggerName, Level level) {
        void var2_2;
        void var1_1;
        if (Strings.isEmpty((CharSequence)loggerName)) {
            Configurator.setRootLevel(level, loggerContext);
            return;
        }
        if (Configurator.setLevel((String)var1_1, (Level)var2_2, loggerContext.getConfiguration())) {
            LoggerContext loggerContext2;
            loggerContext2.updateLoggers();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setLevel(Map<String, Level> levelMap) {
        void var3_3;
        Object object;
        LoggerContext loggerContext = LoggerContext.getContext(StackLocatorUtil.getCallerClassLoader((int)2), false, null);
        Configuration config = loggerContext.getConfiguration();
        boolean set = false;
        for (Map.Entry entry : object.entrySet()) {
            String loggerName = (String)entry.getKey();
            Level level = (Level)entry.getValue();
            set |= Configurator.setLevel(loggerName, level, config);
        }
        if (var3_3 != false) {
            void var1_1;
            var1_1.updateLoggers();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setLevel(String loggerName, Level level) {
        void var1_1;
        String string;
        Configurator.setLevel(LoggerContext.getContext(StackLocatorUtil.getCallerClassLoader((int)2), false, null), string, (Level)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void setLevel(String loggerName, String level) {
        void var1_1;
        String string;
        Configurator.setLevel(LoggerContext.getContext(StackLocatorUtil.getCallerClassLoader((int)2), false, null), string, Level.toLevel((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static boolean setLevel(String loggerName, Level level, Configuration config) {
        void var0_1;
        boolean set;
        LoggerConfig loggerConfig = config.getLoggerConfig(loggerName);
        if (!loggerName.equals(loggerConfig.getName())) {
            void var2_3;
            loggerConfig = new LoggerConfig(loggerName, level, true);
            var2_3.addLogger(loggerName, loggerConfig);
            loggerConfig.setLevel(level);
            set = true;
        } else {
            void var1_2;
            void var3_4;
            set = Configurator.setLevel((LoggerConfig)var3_4, (Level)var1_2);
        }
        return (boolean)var0_1;
    }

    public static void setRootLevel(Level level) {
        Configurator.setRootLevel(level, LoggerContext.getContext(StackLocatorUtil.getCallerClassLoader((int)2), false, null));
    }

    /*
     * WARNING - void declaration
     */
    private static void setRootLevel(Level level, LoggerContext loggerContext) {
        LoggerConfig loggerConfig = loggerContext.getConfiguration().getRootLogger();
        if (!loggerConfig.getLevel().equals((Object)level)) {
            void var1_1;
            Level level2;
            void var2_2;
            var2_2.setLevel(level2);
            var1_1.updateLoggers();
        }
    }

    public static void shutdown(LoggerContext ctx) {
        if (ctx != null) {
            LoggerContext loggerContext;
            loggerContext.stop();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean shutdown(LoggerContext ctx, long timeout, TimeUnit timeUnit) {
        if (ctx != null) {
            void var3_2;
            void var1_1;
            LoggerContext loggerContext;
            return ((AbstractLifeCycle)loggerContext).stop((long)var1_1, (TimeUnit)var3_2);
        }
        return true;
    }

    private Configurator() {
    }
}

