/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.net.UrlConnectionFactory;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.Source;
import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.LoaderUtil;

public class ConfigurationSource {
    public static final ConfigurationSource NULL_SOURCE = new ConfigurationSource(Constants.EMPTY_BYTE_ARRAY, null, 0L);
    public static final ConfigurationSource COMPOSITE_SOURCE = new ConfigurationSource(Constants.EMPTY_BYTE_ARRAY, null, 0L);
    private final InputStream stream;
    private volatile byte[] data;
    private volatile Source source;
    private final long lastModified;
    private volatile long modifiedMillis;

    /*
     * WARNING - void declaration
     */
    public ConfigurationSource(InputStream stream, File file) {
        void var3_3;
        void var1_1;
        this.stream = (InputStream)Objects.requireNonNull(var1_1, "stream is null");
        this.data = null;
        this.source = new Source(file);
        long modified = 0L;
        try {
            void var2_2;
            modified = var2_2.lastModified();
        }
        catch (Exception exception) {}
        this.lastModified = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public ConfigurationSource(InputStream stream, Path path) {
        void var3_3;
        void var1_1;
        this.stream = (InputStream)Objects.requireNonNull(var1_1, "stream is null");
        this.data = null;
        this.source = new Source(path);
        long modified = 0L;
        try {
            void var2_2;
            modified = Files.getLastModifiedTime((Path)var2_2, new LinkOption[0]).toMillis();
        }
        catch (Exception exception) {}
        this.lastModified = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public ConfigurationSource(InputStream stream, URL url) {
        void var2_2;
        void var1_1;
        this.stream = (InputStream)Objects.requireNonNull(var1_1, "stream is null");
        this.data = null;
        this.lastModified = 0L;
        this.source = new Source((URL)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ConfigurationSource(InputStream stream, URL url, long lastModified) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.stream = (InputStream)Objects.requireNonNull(var1_1, "stream is null");
        this.data = null;
        this.lastModified = var3_3;
        this.source = new Source((URL)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ConfigurationSource(InputStream stream) throws IOException {
        this(ConfigurationSource.toByteArray((InputStream)var1_1), null, 0L);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ConfigurationSource(Source source, byte[] data, long lastModified) {
        void var1_1;
        void var3_3;
        void var2_2;
        Objects.requireNonNull(source, "source is null");
        this.data = Objects.requireNonNull(data, "data is null");
        this.stream = new ByteArrayInputStream((byte[])var2_2);
        this.lastModified = var3_3;
        this.source = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ConfigurationSource(byte[] data, URL url, long lastModified) {
        void var2_2;
        void var3_3;
        this.data = Objects.requireNonNull(data, "data is null");
        this.stream = new ByteArrayInputStream(data);
        this.lastModified = var3_3;
        if (url == null) {
            void var1_1;
            this.data = var1_1;
            return;
        }
        this.source = new Source((URL)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] toByteArray(InputStream inputStream) throws IOException {
        void var2_3;
        int buffSize = Math.max(4096, inputStream.available());
        ByteArrayOutputStream contents = new ByteArrayOutputStream(buffSize);
        byte[] buff = new byte[buffSize];
        int length = inputStream.read(buff);
        while (length > 0) {
            contents.write(buff, 0, length);
            length = inputStream.read(buff);
        }
        return var2_3.toByteArray();
    }

    public File getFile() {
        if (this.source == null) {
            return null;
        }
        return this.source.getFile();
    }

    private boolean isFile() {
        return this.source != null && this.source.getFile() != null;
    }

    private boolean isURL() {
        return this.source != null && this.source.getURI() != null;
    }

    private boolean isLocation() {
        return this.source != null && this.source.getLocation() != null;
    }

    public URL getURL() {
        if (this.source == null) {
            return null;
        }
        return this.source.getURL();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setSource(Source source) {
        void var1_1;
        this.source = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setData(byte[] data) {
        void var1_1;
        this.data = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setModifiedMillis(long modifiedMillis) {
        void var1_1;
        this.modifiedMillis = var1_1;
    }

    public URI getURI() {
        if (this.source == null) {
            return null;
        }
        return this.source.getURI();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getLocation() {
        if (this.source == null) {
            return null;
        }
        return this.source.getLocation();
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    public ConfigurationSource resetInputStream() throws IOException {
        if (this.source != null && this.data != null) {
            return new ConfigurationSource(this.source, this.data, this.lastModified);
        }
        if (this.isFile()) {
            return new ConfigurationSource((InputStream)new FileInputStream(this.getFile()), this.getFile());
        }
        if (this.isURL() && this.data != null) {
            return new ConfigurationSource(this.data, this.getURL(), this.modifiedMillis == 0L ? this.lastModified : this.modifiedMillis);
        }
        if (this.isURL()) {
            return ConfigurationSource.fromUri(this.getURI());
        }
        if (this.data != null) {
            return new ConfigurationSource(this.data, null, this.lastModified);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        if (this.isLocation()) {
            return this.getLocation();
        }
        if (this == NULL_SOURCE) {
            return "NULL_SOURCE";
        }
        int length = this.data == null ? -1 : this.data.length;
        return "stream (" + (int)var1_1 + " bytes, unknown location)";
    }

    /*
     * WARNING - void declaration
     */
    public static ConfigurationSource fromUri(URI configLocation) {
        File configFile = FileUtils.fileFromUri((URI)configLocation);
        if (configFile != null && configFile.exists() && configFile.canRead()) {
            try {
                return new ConfigurationSource((InputStream)new FileInputStream(configFile), configFile);
            }
            catch (FileNotFoundException ex) {
                ConfigurationFactory.LOGGER.error("Cannot locate file {}", (Object)((URI)configLocation).getPath(), (Object)ex);
            }
        }
        if (ConfigurationFactory.isClassLoaderUri((URI)configLocation)) {
            ClassLoader loader = LoaderUtil.getThreadContextClassLoader();
            configLocation = ConfigurationFactory.extractClassLoaderUriPath((URI)configLocation);
            return ConfigurationSource.fromResource((String)configLocation, loader);
        }
        if (!((URI)configLocation).isAbsolute()) {
            ConfigurationFactory.LOGGER.error("File not found in file system or classpath: {}", (Object)((URI)configLocation).toString());
            return null;
        }
        try {
            return ConfigurationSource.getConfigurationSource(((URI)configLocation).toURL());
        }
        catch (MalformedURLException ex) {
            void var1_3;
            URI uRI;
            ConfigurationFactory.LOGGER.error("Invalid URL {}", (Object)uRI.toString(), (Object)var1_3);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ConfigurationSource fromResource(String resource, ClassLoader loader) {
        URL uRL;
        void var1_1;
        URL url = Loader.getResource(resource, (ClassLoader)var1_1);
        if (url == null) {
            return null;
        }
        return ConfigurationSource.getConfigurationSource(uRL);
    }

    /*
     * WARNING - void declaration
     */
    private static ConfigurationSource getConfigurationSource(URL url) {
        try {
            File file = FileUtils.fileFromUri(url.toURI());
            URLConnection urlConnection = UrlConnectionFactory.createConnection(url);
            try {
                void var2_3;
                if (file != null) {
                    return new ConfigurationSource(urlConnection.getInputStream(), FileUtils.fileFromUri(url.toURI()));
                }
                if (urlConnection instanceof JarURLConnection) {
                    void var3_4;
                    long lastModified = new File(((JarURLConnection)urlConnection).getJarFile().getName()).lastModified();
                    return new ConfigurationSource(urlConnection.getInputStream(), url, (long)var3_4);
                }
                return new ConfigurationSource(urlConnection.getInputStream(), url, var2_3.getLastModified());
            }
            catch (FileNotFoundException fileNotFoundException) {
                ConfigurationFactory.LOGGER.info("Unable to locate file {}, ignoring.", (Object)url.toString());
                return null;
            }
        }
        catch (IOException | URISyntaxException ex) {
            void var1_2;
            URL uRL;
            ConfigurationFactory.LOGGER.warn("Error accessing {} due to {}, ignoring.", (Object)uRL.toString(), (Object)var1_2.getMessage());
            return null;
        }
    }
}

