/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.config.CronScheduledFuture;
import org.apache.logging.log4j.core.util.CronExpression;
import org.apache.logging.log4j.core.util.Log4jThreadFactory;
import org.apache.logging.log4j.status.StatusLogger;

public class ConfigurationScheduler
extends AbstractLifeCycle {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String SIMPLE_NAME = "Log4j2 " + ConfigurationScheduler.class.getSimpleName();
    private static final int MAX_SCHEDULED_ITEMS = 5;
    private volatile ScheduledExecutorService executorService;
    private int scheduledItems = 0;
    private final String name;

    public ConfigurationScheduler() {
        this(SIMPLE_NAME);
    }

    /*
     * WARNING - void declaration
     */
    public ConfigurationScheduler(String name) {
        void var1_1;
        this.name = var1_1;
    }

    @Override
    public void start() {
        super.start();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        if (this.isExecutorServiceSet()) {
            LOGGER.debug("{} shutting down threads in {}", (Object)this.name, (Object)this.getExecutorService());
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(timeout, timeUnit);
            }
            catch (InterruptedException interruptedException) {
                this.executorService.shutdownNow();
                try {
                    void var3_2;
                    void var1_1;
                    this.executorService.awaitTermination((long)var1_1, (TimeUnit)var3_2);
                }
                catch (InterruptedException interruptedException2) {
                    LOGGER.warn("{} stopped but some scheduled services may not have completed.", (Object)this.name);
                }
                Thread.currentThread().interrupt();
            }
        }
        this.setStopped();
        return true;
    }

    public boolean isExecutorServiceSet() {
        return this.executorService != null;
    }

    public void incrementScheduledItems() {
        if (this.isExecutorServiceSet()) {
            LOGGER.error("{} attempted to increment scheduled items after start", (Object)this.name);
            return;
        }
        ++this.scheduledItems;
    }

    public void decrementScheduledItems() {
        if (!this.isStarted() && this.scheduledItems > 0) {
            --this.scheduledItems;
        }
    }

    /*
     * WARNING - void declaration
     */
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        void var2_2;
        void var1_1;
        return this.getExecutorService().schedule(var1_1, (long)var2_2, unit);
    }

    /*
     * WARNING - void declaration
     */
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        void var2_2;
        void var1_1;
        return this.getExecutorService().schedule((Runnable)var1_1, (long)var2_2, unit);
    }

    /*
     * WARNING - void declaration
     */
    public CronScheduledFuture<?> scheduleWithCron(CronExpression cronExpression, Runnable command) {
        void var2_2;
        void var1_1;
        return this.scheduleWithCron((CronExpression)var1_1, new Date(), (Runnable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public CronScheduledFuture<?> scheduleWithCron(CronExpression cronExpression, Date startDate, Runnable command) {
        void var2_2;
        void var1_1;
        void var3_3;
        Date fireDate = cronExpression.getNextValidTimeAfter(startDate == null ? new Date() : startDate);
        CronRunnable runnable = new CronRunnable(this, command, cronExpression);
        ScheduledFuture<?> future = this.schedule(runnable, this.nextFireInterval(fireDate), TimeUnit.MILLISECONDS);
        CronScheduledFuture cronScheduledFuture = new CronScheduledFuture(future, fireDate);
        var3_3.setScheduledFuture(cronScheduledFuture);
        LOGGER.debug("{} scheduled cron expression {} to fire at {}", (Object)this.name, (Object)var1_1.getCronExpression(), (Object)var2_2);
        return cronScheduledFuture;
    }

    /*
     * WARNING - void declaration
     */
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        void var2_2;
        void var1_1;
        return this.getExecutorService().scheduleAtFixedRate((Runnable)var1_1, (long)var2_2, period, unit);
    }

    /*
     * WARNING - void declaration
     */
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        void var2_2;
        void var1_1;
        return this.getExecutorService().scheduleWithFixedDelay((Runnable)var1_1, (long)var2_2, delay, unit);
    }

    public long nextFireInterval(Date fireDate) {
        return fireDate.getTime() - new Date().getTime();
    }

    /*
     * WARNING - void declaration
     */
    private ScheduledExecutorService getExecutorService() {
        if (this.executorService == null) {
            ConfigurationScheduler configurationScheduler = this;
            synchronized (configurationScheduler) {
                if (this.executorService == null) {
                    if (this.scheduledItems > 0) {
                        void var2_2;
                        LOGGER.debug("{} starting {} threads", (Object)this.name, (Object)this.scheduledItems);
                        this.scheduledItems = Math.min(this.scheduledItems, 5);
                        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(this.scheduledItems, Log4jThreadFactory.createDaemonThreadFactory("Scheduled"));
                        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
                        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
                        this.executorService = var2_2;
                    } else {
                        LOGGER.debug("{}: No scheduled items", (Object)this.name);
                    }
                }
            }
        }
        return this.executorService;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder("ConfigurationScheduler [name=");
        sb.append(this.name);
        sb.append(", [");
        if (this.executorService != null) {
            Iterator iterator;
            BlockingQueue<Runnable> queue = ((ScheduledThreadPoolExecutor)this.executorService).getQueue();
            boolean first = true;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Runnable runnable = (Runnable)iterator.next();
                if (!first) {
                    sb.append(", ");
                }
                sb.append(runnable.toString());
                first = false;
            }
        }
        sb.append("]");
        return var1_1.toString();
    }

    public class CronRunnable
    implements Runnable {
        private final CronExpression cronExpression;
        private final Runnable runnable;
        private CronScheduledFuture<?> scheduledFuture;
        final /* synthetic */ ConfigurationScheduler this$0;

        /*
         * WARNING - void declaration
         */
        public CronRunnable(ConfigurationScheduler this$0, Runnable runnable, CronExpression cronExpression) {
            void var2_2;
            void var3_3;
            void var1_1;
            this.this$0 = var1_1;
            this.cronExpression = var3_3;
            this.runnable = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public void setScheduledFuture(CronScheduledFuture<?> future) {
            void var1_1;
            this.scheduledFuture = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            ScheduledFuture<?> future;
            Date fireDate;
            try {
                long millis = this.scheduledFuture.getFireTime().getTime() - System.currentTimeMillis();
                if (millis > 0L) {
                    LOGGER.debug("{} Cron thread woke up {} millis early. Sleeping", (Object)this.this$0.name, (Object)millis);
                    try {
                        Thread.sleep(millis);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.runnable.run();
                fireDate = this.cronExpression.getNextValidTimeAfter(new Date());
                CronRunnable cronRunnable = this;
                future = this.this$0.schedule(cronRunnable, cronRunnable.this$0.nextFireInterval(fireDate), TimeUnit.MILLISECONDS);
            }
            catch (Throwable ex) {
                void var1_4;
                ScheduledFuture<?> future2;
                Date fireDate2;
                try {
                    LOGGER.error("{} caught error running command", (Object)this.this$0.name, (Object)ex);
                    fireDate2 = this.cronExpression.getNextValidTimeAfter(new Date());
                    CronRunnable cronRunnable = this;
                    future2 = this.this$0.schedule(cronRunnable, cronRunnable.this$0.nextFireInterval(fireDate2), TimeUnit.MILLISECONDS);
                }
                catch (Throwable throwable) {
                    void var2_8;
                    void var3_9;
                    Date fireDate3 = this.cronExpression.getNextValidTimeAfter(new Date());
                    CronRunnable cronRunnable = this;
                    ScheduledFuture<?> future3 = this.this$0.schedule(cronRunnable, cronRunnable.this$0.nextFireInterval(fireDate3), TimeUnit.MILLISECONDS);
                    LOGGER.debug("{} Cron expression {} scheduled to fire again at {}", (Object)this.this$0.name, (Object)this.cronExpression.getCronExpression(), (Object)fireDate3);
                    this.scheduledFuture.reset((ScheduledFuture<?>)var3_9, (Date)var2_8);
                    throw throwable;
                }
                LOGGER.debug("{} Cron expression {} scheduled to fire again at {}", (Object)this.this$0.name, (Object)this.cronExpression.getCronExpression(), (Object)fireDate2);
                this.scheduledFuture.reset(future2, (Date)var1_4);
                return;
            }
            LOGGER.debug("{} Cron expression {} scheduled to fire again at {}", (Object)this.this$0.name, (Object)this.cronExpression.getCronExpression(), (Object)fireDate);
            this.scheduledFuture.reset(future, fireDate);
            return;
        }

        public String toString() {
            return "CronRunnable{" + this.cronExpression.getCronExpression() + " - " + this.scheduledFuture.getFireTime();
        }
    }
}

