/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LocationAwareReliabilityStrategy;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.ReliabilityStrategy;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.Supplier;

public class AwaitCompletionReliabilityStrategy
implements LocationAwareReliabilityStrategy,
ReliabilityStrategy {
    private static final int MAX_RETRIES = 3;
    private final AtomicInteger counter = new AtomicInteger();
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private final Lock shutdownLock = new ReentrantLock();
    private final Condition noLogEvents = this.shutdownLock.newCondition();
    private final LoggerConfig loggerConfig;

    /*
     * WARNING - void declaration
     */
    public AwaitCompletionReliabilityStrategy(LoggerConfig loggerConfig) {
        void var1_1;
        this.loggerConfig = (LoggerConfig)Objects.requireNonNull(var1_1, "loggerConfig is null");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Supplier<LoggerConfig> reconfigured, String loggerName, String fqcn, Marker marker, Level level, Message data, Throwable t) {
        LoggerConfig config = this.getActiveLoggerConfig(reconfigured);
        try {
            void var3_4;
            void var2_2;
            config.log((String)var2_2, (String)var3_4, marker, level, data, t);
            config.getReliabilityStrategy().afterLogEvent();
            return;
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.getReliabilityStrategy().afterLogEvent();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Supplier<LoggerConfig> reconfigured, String loggerName, String fqcn, StackTraceElement location, Marker marker, Level level, Message data, Throwable t) {
        LoggerConfig config = this.getActiveLoggerConfig(reconfigured);
        try {
            void var3_4;
            void var2_2;
            config.log((String)var2_2, (String)var3_4, location, marker, level, data, t);
            config.getReliabilityStrategy().afterLogEvent();
            return;
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.getReliabilityStrategy().afterLogEvent();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Supplier<LoggerConfig> reconfigured, LogEvent event) {
        LoggerConfig config = this.getActiveLoggerConfig(reconfigured);
        try {
            void var2_2;
            config.log((LogEvent)var2_2);
            config.getReliabilityStrategy().afterLogEvent();
            return;
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.getReliabilityStrategy().afterLogEvent();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerConfig getActiveLoggerConfig(Supplier<LoggerConfig> next) {
        void var2_2;
        LoggerConfig result = this.loggerConfig;
        if (!this.beforeLogEvent()) {
            void var1_1;
            result = (LoggerConfig)next.get();
            if (result == this.loggerConfig) {
                return result;
            }
            return result.getReliabilityStrategy().getActiveLoggerConfig((Supplier<LoggerConfig>)var1_1);
        }
        return var2_2;
    }

    private boolean beforeLogEvent() {
        return this.counter.incrementAndGet() > 0;
    }

    @Override
    public void afterLogEvent() {
        if (this.counter.decrementAndGet() == 0 && this.shutdown.get()) {
            this.signalCompletionIfShutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void signalCompletionIfShutdown() {
        Lock lock = this.shutdownLock;
        lock.lock();
        try {
            this.noLogEvents.signalAll();
            lock.unlock();
            return;
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.unlock();
            throw throwable;
        }
    }

    @Override
    public void beforeStopAppenders() {
        this.waitForCompletion();
    }

    private void waitForCompletion() {
        this.shutdownLock.lock();
        try {
            if (this.shutdown.compareAndSet(false, true)) {
                int retries = 0;
                while (!this.counter.compareAndSet(0, Integer.MIN_VALUE)) {
                    if (this.counter.get() < 0) {
                        return;
                    }
                    try {
                        this.noLogEvents.await(retries + 1, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        if (++retries > 3) break;
                    }
                }
            }
            return;
        }
        finally {
            this.shutdownLock.unlock();
        }
    }

    @Override
    public void beforeStopConfiguration(Configuration configuration) {
    }
}

