/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.util.PerformanceSensitive;

@PerformanceSensitive
public class AppenderControlArraySet {
    private static final AtomicReferenceFieldUpdater<AppenderControlArraySet, AppenderControl[]> appenderArrayUpdater = AtomicReferenceFieldUpdater.newUpdater(AppenderControlArraySet.class, AppenderControl[].class, "appenderArray");
    private volatile AppenderControl[] appenderArray = AppenderControl.EMPTY_ARRAY;

    /*
     * WARNING - void declaration
     */
    public boolean add(AppenderControl control) {
        AppenderControl[] appenderControlArray;
        void var2_3;
        boolean bl;
        do {
            AppenderControl[] original = this.appenderArray;
            appenderControlArray = this.appenderArray;
            int n = appenderControlArray.length;
            for (int i = 0; i < n; ++i) {
                AppenderControl appenderControl = appenderControlArray[i];
                if (!appenderControl.equals(control)) continue;
                return false;
            }
            AppenderControl[] appenderControlArray2 = Arrays.copyOf(original, original.length + 1);
            AppenderControl[] copy = appenderControlArray2;
            appenderControlArray2[copy.length - 1] = control;
        } while (!(bl = appenderArrayUpdater.compareAndSet(this, (AppenderControl[])var2_3, appenderControlArray)));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public AppenderControl remove(String name) {
        boolean bl;
        block0: do {
            boolean success = true;
            AppenderControl[] original = this.appenderArray;
            for (int i = 0; i < original.length; ++i) {
                void var2_3;
                AppenderControl appenderControl = original[i];
                if (!Objects.equals(name, appenderControl.getAppenderName())) continue;
                AppenderControl[] copy = this.removeElementAt(i, original);
                if (appenderArrayUpdater.compareAndSet(this, original, (AppenderControl[])var2_3)) {
                    return appenderControl;
                }
                bl = false;
                continue block0;
            }
        } while (!bl);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private AppenderControl[] removeElementAt(int i, AppenderControl[] array) {
        void var3_3;
        void var1_1;
        void var2_2;
        AppenderControl[] result = Arrays.copyOf(array, array.length - 1);
        System.arraycopy(var2_2, i + 1, result, i, result.length - var1_1);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Appender> asMap() {
        void var1_1;
        HashMap<String, Appender> result = new HashMap<String, Appender>();
        AppenderControl[] appenderControlArray = this.appenderArray;
        int n = this.appenderArray.length;
        for (int i = 0; i < n; ++i) {
            AppenderControl appenderControl = appenderControlArray[i];
            result.put(appenderControl.getAppenderName(), appenderControl.getAppender());
        }
        return var1_1;
    }

    public AppenderControl[] clear() {
        return appenderArrayUpdater.getAndSet(this, AppenderControl.EMPTY_ARRAY);
    }

    public boolean isEmpty() {
        return this.appenderArray.length == 0;
    }

    public AppenderControl[] get() {
        return this.appenderArray;
    }

    public String toString() {
        return "AppenderControlArraySet [appenderArray=" + Arrays.toString(this.appenderArray) + "]";
    }
}

