/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.filter.Filterable;
import org.apache.logging.log4j.util.PerformanceSensitive;

public class AppenderControl
extends AbstractFilterable {
    static final AppenderControl[] EMPTY_ARRAY = new AppenderControl[0];
    private final ThreadLocal<AppenderControl> recursive = new ThreadLocal();
    private final Appender appender;
    private final Level level;
    private final int intLevel;
    private final String appenderName;

    /*
     * WARNING - void declaration
     */
    public AppenderControl(Appender appender, Level level, Filter filter) {
        super((Filter)var3_3);
        void var2_2;
        void var1_1;
        void var3_3;
        this.appender = Objects.requireNonNull(appender, "appender");
        this.appenderName = var1_1.getName();
        this.level = level;
        this.intLevel = level == null ? Level.ALL.intLevel() : var2_2.intLevel();
        ((AbstractLifeCycle)this).start();
    }

    public String getAppenderName() {
        return this.appenderName;
    }

    public Appender getAppender() {
        return this.appender;
    }

    /*
     * WARNING - void declaration
     */
    public void callAppender(LogEvent event) {
        void var1_1;
        if (this.shouldSkip(event)) {
            return;
        }
        this.callAppenderPreventRecursion((LogEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean shouldSkip(LogEvent event) {
        void var1_1;
        return this.isFilteredByAppenderControl(event) || this.isFilteredByLevel((LogEvent)var1_1) || this.isRecursiveCall();
    }

    /*
     * WARNING - void declaration
     */
    @PerformanceSensitive
    private boolean isFilteredByAppenderControl(LogEvent event) {
        void var1_1;
        void var2_2;
        Filter filter = this.getFilter();
        return filter != null && Filter.Result.DENY == var2_2.filter((LogEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @PerformanceSensitive
    private boolean isFilteredByLevel(LogEvent event) {
        void var1_1;
        return this.level != null && this.intLevel < var1_1.getLevel().intLevel();
    }

    @PerformanceSensitive
    private boolean isRecursiveCall() {
        if (this.recursive.get() != null) {
            this.appenderErrorHandlerMessage("Recursive call to appender ");
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private String appenderErrorHandlerMessage(String prefix) {
        void var1_1;
        String result = this.createErrorMsg(prefix);
        this.appender.getHandler().error(result);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void callAppenderPreventRecursion(LogEvent event) {
        try {
            void var1_1;
            this.recursive.set(this);
            this.callAppender0((LogEvent)var1_1);
            return;
        }
        finally {
            this.recursive.set(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void callAppender0(LogEvent event) {
        this.ensureAppenderStarted();
        if (!this.isFilteredByAppender(event)) {
            void var1_1;
            this.tryCallAppender((LogEvent)var1_1);
        }
    }

    private void ensureAppenderStarted() {
        if (!this.appender.isStarted()) {
            this.handleError("Attempted to append to non-started appender ");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleError(String prefix) {
        String msg = this.appenderErrorHandlerMessage(prefix);
        if (!this.appender.ignoreExceptions()) {
            void var1_1;
            throw new AppenderLoggingException((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String createErrorMsg(String prefix) {
        void var1_1;
        return (String)var1_1 + this.appender.getName();
    }

    /*
     * WARNING - void declaration
     */
    private boolean isFilteredByAppender(LogEvent event) {
        void var1_1;
        return this.appender instanceof Filterable && ((Filterable)((Object)this.appender)).isFiltered((LogEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void tryCallAppender(LogEvent event) {
        try {
            this.appender.append(event);
            return;
        }
        catch (RuntimeException error) {
            this.handleAppenderError(event, error);
            return;
        }
        catch (Throwable throwable) {
            void var2_3;
            void var1_1;
            this.handleAppenderError((LogEvent)var1_1, (RuntimeException)((Object)new AppenderLoggingException((Throwable)var2_3)));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleAppenderError(LogEvent event, RuntimeException ex) {
        void var1_1;
        this.appender.getHandler().error(this.createErrorMsg("An exception occurred processing Appender "), (LogEvent)var1_1, ex);
        if (!this.appender.ignoreExceptions()) {
            void var2_2;
            throw var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AppenderControl)) {
            return false;
        }
        AppenderControl other = (AppenderControl)obj;
        return Objects.equals(this.appenderName, var1_1.appenderName);
    }

    public int hashCode() {
        return this.appenderName.hashCode();
    }

    public String toString() {
        return super.toString() + "[appender=" + this.appender + ", appenderName=" + this.appenderName + ", level=" + this.level + ", intLevel=" + this.intLevel + ", recursive=" + this.recursive + ", filter=" + this.getFilter() + "]";
    }
}

