/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LifeCycle2;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.Version;
import org.apache.logging.log4j.core.appender.AsyncAppender;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.async.AsyncLoggerConfig;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDelegate;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDisruptor;
import org.apache.logging.log4j.core.async.AsyncWaitStrategyFactory;
import org.apache.logging.log4j.core.async.AsyncWaitStrategyFactoryConfig;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFileWatcher;
import org.apache.logging.log4j.core.config.ConfigurationListener;
import org.apache.logging.log4j.core.config.ConfigurationScheduler;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.CustomLevelConfig;
import org.apache.logging.log4j.core.config.CustomLevels;
import org.apache.logging.log4j.core.config.DefaultAdvertiser;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.LoggerContextAware;
import org.apache.logging.log4j.core.config.Loggers;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.config.ReliabilityStrategy;
import org.apache.logging.log4j.core.config.ReliabilityStrategyFactory;
import org.apache.logging.log4j.core.config.Scheduled;
import org.apache.logging.log4j.core.config.arbiters.Arbiter;
import org.apache.logging.log4j.core.config.arbiters.SelectArbiter;
import org.apache.logging.log4j.core.config.plugins.util.PluginBuilder;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.lookup.ConfigurationStrSubstitutor;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.PropertiesLookup;
import org.apache.logging.log4j.core.lookup.RuntimeStrSubstitutor;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.script.ScriptManager;
import org.apache.logging.log4j.core.script.ScriptRef;
import org.apache.logging.log4j.core.util.DummyNanoClock;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.NameUtil;
import org.apache.logging.log4j.core.util.NanoClock;
import org.apache.logging.log4j.core.util.Source;
import org.apache.logging.log4j.core.util.WatchManager;
import org.apache.logging.log4j.core.util.Watcher;
import org.apache.logging.log4j.core.util.WatcherFactory;
import org.apache.logging.log4j.util.PropertiesUtil;

public abstract class AbstractConfiguration
extends AbstractFilterable
implements Configuration {
    private static final int BUF_SIZE = 16384;
    protected Node rootNode;
    protected final List<ConfigurationListener> listeners = new CopyOnWriteArrayList<ConfigurationListener>();
    protected final List<String> pluginPackages = new ArrayList<String>();
    protected PluginManager pluginManager;
    protected boolean isShutdownHookEnabled = true;
    protected long shutdownTimeoutMillis;
    protected ScriptManager scriptManager;
    private Advertiser advertiser = new DefaultAdvertiser();
    private Node advertiserNode;
    private Object advertisement;
    private String name;
    private ConcurrentMap<String, Appender> appenders = new ConcurrentHashMap<String, Appender>();
    private ConcurrentMap<String, LoggerConfig> loggerConfigs = new ConcurrentHashMap<String, LoggerConfig>();
    private List<CustomLevelConfig> customLevels = Collections.emptyList();
    private final ConcurrentMap<String, String> propertyMap = new ConcurrentHashMap<String, String>();
    private final Interpolator tempLookup = new Interpolator(this.propertyMap);
    private final StrSubstitutor runtimeStrSubstitutor = new RuntimeStrSubstitutor(this.tempLookup);
    private final StrSubstitutor configurationStrSubstitutor = new ConfigurationStrSubstitutor(this.runtimeStrSubstitutor);
    private LoggerConfig root = new LoggerConfig();
    private final ConcurrentMap<String, Object> componentMap = new ConcurrentHashMap<String, Object>();
    private final ConfigurationSource configurationSource;
    private final ConfigurationScheduler configurationScheduler = new ConfigurationScheduler();
    private final WatchManager watchManager = new WatchManager(this.configurationScheduler);
    private AsyncLoggerConfigDisruptor asyncLoggerConfigDisruptor;
    private AsyncWaitStrategyFactory asyncWaitStrategyFactory;
    private NanoClock nanoClock = new DummyNanoClock();
    private final WeakReference<LoggerContext> loggerContext;

    /*
     * WARNING - void declaration
     */
    protected AbstractConfiguration(LoggerContext loggerContext, ConfigurationSource configurationSource) {
        void var2_2;
        void var1_1;
        this.loggerContext = new WeakReference<LoggerContext>(loggerContext);
        this.tempLookup.setLoggerContext((LoggerContext)var1_1);
        this.configurationSource = (ConfigurationSource)Objects.requireNonNull(var2_2, "configurationSource is null");
        this.componentMap.put("ContextProperties", this.propertyMap);
        this.pluginManager = new PluginManager("Core");
        this.rootNode = new Node();
        this.setState(LifeCycle.State.INITIALIZING);
    }

    @Override
    public ConfigurationSource getConfigurationSource() {
        return this.configurationSource;
    }

    @Override
    public List<String> getPluginPackages() {
        return this.pluginPackages;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.propertyMap;
    }

    @Override
    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    /*
     * WARNING - void declaration
     */
    public void setScriptManager(ScriptManager scriptManager) {
        void var1_1;
        this.scriptManager = var1_1;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    /*
     * WARNING - void declaration
     */
    public void setPluginManager(PluginManager pluginManager) {
        void var1_1;
        this.pluginManager = var1_1;
    }

    @Override
    public WatchManager getWatchManager() {
        return this.watchManager;
    }

    @Override
    public ConfigurationScheduler getScheduler() {
        return this.configurationScheduler;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    @Override
    public AsyncLoggerConfigDelegate getAsyncLoggerConfigDelegate() {
        if (this.asyncLoggerConfigDisruptor == null) {
            this.asyncLoggerConfigDisruptor = new AsyncLoggerConfigDisruptor(this.asyncWaitStrategyFactory);
        }
        return this.asyncLoggerConfigDisruptor;
    }

    @Override
    public AsyncWaitStrategyFactory getAsyncWaitStrategyFactory() {
        return this.asyncWaitStrategyFactory;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize() {
        LOGGER.debug(Version.getProductString() + " initializing configuration {}", (Object)this);
        this.runtimeStrSubstitutor.setConfiguration(this);
        this.configurationStrSubstitutor.setConfiguration(this);
        String scriptLanguages = PropertiesUtil.getProperties().getStringProperty("log4j2.Script.enableLanguages");
        if (scriptLanguages != null) {
            try {
                AbstractConfiguration abstractConfiguration = this;
                this.scriptManager = new ScriptManager(abstractConfiguration, abstractConfiguration.watchManager, scriptLanguages);
            }
            catch (Exception | LinkageError e) {
                LOGGER.info("Cannot initialize scripting support because this JRE does not support it.", e);
            }
        }
        this.pluginManager.collectPlugins(this.pluginPackages);
        PluginManager levelPlugins = new PluginManager("Level");
        levelPlugins.collectPlugins(this.pluginPackages);
        Map<String, PluginType<?>> plugins = levelPlugins.getPlugins();
        if (plugins != null) {
            Iterator iterator;
            for (PluginType type : iterator.values()) {
                try {
                    Loader.initializeClass(type.getPluginClass().getName(), type.getPluginClass().getClassLoader());
                }
                catch (Exception e) {
                    void var3_4;
                    void var2_3;
                    LOGGER.error("Unable to initialize {} due to {}", (Object)var2_3.getPluginClass().getName(), (Object)e.getClass().getSimpleName(), (Object)var3_4);
                }
            }
        }
        this.setup();
        this.setupAdvertisement();
        this.doConfigure();
        this.setState(LifeCycle.State.INITIALIZED);
        LOGGER.debug("Configuration {} initialized", (Object)this);
    }

    /*
     * WARNING - void declaration
     */
    protected void initializeWatchers(Reconfigurable reconfigurable, ConfigurationSource configSource, int monitorIntervalSeconds) {
        if (configSource != null && (configSource.getFile() != null || configSource.getURL() != null)) {
            void var3_3;
            void var1_1;
            if (monitorIntervalSeconds > 0) {
                this.watchManager.setIntervalSeconds(monitorIntervalSeconds);
                if (configSource.getFile() != null) {
                    void var3_4;
                    Source cfgSource = new Source(configSource);
                    long lastModifeid = configSource.getFile().lastModified();
                    ConfigurationFileWatcher watcher = new ConfigurationFileWatcher(this, reconfigurable, this.listeners, lastModifeid);
                    this.watchManager.watch((Source)var3_4, (Watcher)var1_1);
                    return;
                }
                if (configSource.getURL() != null) {
                    this.monitorSource((Reconfigurable)var1_1, configSource);
                    return;
                }
            } else if (this.watchManager.hasEventListeners() && configSource.getURL() != null && var3_3 >= 0) {
                void var2_2;
                this.monitorSource((Reconfigurable)var1_1, (ConfigurationSource)var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void monitorSource(Reconfigurable reconfigurable, ConfigurationSource configSource) {
        void var2_2;
        if (configSource.getLastModified() > 0L) {
            Source cfgSource = new Source(configSource);
            Watcher watcher = WatcherFactory.getInstance(this.pluginPackages).newWatcher(cfgSource, this, reconfigurable, this.listeners, configSource.getLastModified());
            if (watcher != null) {
                void var1_1;
                void var3_3;
                this.watchManager.watch((Source)var3_3, (Watcher)var1_1);
            }
            return;
        }
        LOGGER.info("{} does not support dynamic reconfiguration", (Object)var2_2.getURI());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start() {
        void var1_1;
        if (this.getState().equals((Object)LifeCycle.State.INITIALIZING)) {
            ((AbstractLifeCycle)this).initialize();
        }
        LOGGER.debug("Starting configuration {}", (Object)this);
        this.setStarting();
        if (this.watchManager.getIntervalSeconds() >= 0) {
            ((AbstractLifeCycle)this.watchManager).start();
        }
        if (this.hasAsyncLoggers()) {
            ((AbstractLifeCycle)this.asyncLoggerConfigDisruptor).start();
        }
        HashSet<void> alreadyStarted = new HashSet<void>();
        for (LoggerConfig logger : this.loggerConfigs.values()) {
            Appender appender;
            ((AbstractLifeCycle)logger).start();
            alreadyStarted.add((void)appender);
        }
        for (Appender appender : this.appenders.values()) {
            appender.start();
        }
        if (!var1_1.contains(this.root)) {
            ((AbstractLifeCycle)this.root).start();
        }
        super.start();
        LOGGER.debug("Started configuration {} OK.", (Object)this);
    }

    private boolean hasAsyncLoggers() {
        if (this.root instanceof AsyncLoggerConfig) {
            return true;
        }
        for (LoggerConfig loggerConfig : this.loggerConfigs.values()) {
            if (!(loggerConfig instanceof AsyncLoggerConfig)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        void var3_2;
        void var1_1;
        this.setStopping();
        super.stop(timeout, timeUnit, false);
        LOGGER.trace("Stopping {}...", (Object)this);
        for (Iterator iterator : this.loggerConfigs.values()) {
            ((LoggerConfig)((Object)iterator)).getReliabilityStrategy().beforeStopConfiguration(this);
        }
        this.root.getReliabilityStrategy().beforeStopConfiguration(this);
        String cls = this.getClass().getSimpleName();
        LOGGER.trace("{} notified {} ReliabilityStrategies that config will be stopped.", (Object)cls, (Object)(this.loggerConfigs.size() + 1));
        if (!this.loggerConfigs.isEmpty()) {
            LOGGER.trace("{} stopping {} LoggerConfigs.", (Object)cls, (Object)this.loggerConfigs.size());
            for (LoggerConfig loggerConfig : this.loggerConfigs.values()) {
                ((AbstractLifeCycle)loggerConfig).stop(timeout, timeUnit);
            }
        }
        LOGGER.trace("{} stopping root LoggerConfig.", (Object)cls);
        if (!this.root.isStopped()) {
            ((AbstractLifeCycle)this.root).stop(timeout, timeUnit);
        }
        if (this.hasAsyncLoggers()) {
            LOGGER.trace("{} stopping AsyncLoggerConfigDisruptor.", (Object)cls);
            ((AbstractLifeCycle)this.asyncLoggerConfigDisruptor).stop(timeout, timeUnit);
        }
        LOGGER.trace("{} notifying ReliabilityStrategies that appenders will be stopped.", (Object)cls);
        for (LoggerConfig loggerConfig : this.loggerConfigs.values()) {
            loggerConfig.getReliabilityStrategy().beforeStopAppenders();
        }
        this.root.getReliabilityStrategy().beforeStopAppenders();
        Appender[] array = this.appenders.values().toArray(Appender.EMPTY_ARRAY);
        Object async = this.getAsyncAppenders(array);
        if (!async.isEmpty()) {
            LOGGER.trace("{} stopping {} AsyncAppenders.", (Object)cls, (Object)async.size());
            async = async.iterator();
            while (async.hasNext()) {
                Appender appender = (Appender)async.next();
                if (appender instanceof LifeCycle2) {
                    ((LifeCycle2)((Object)appender)).stop(timeout, timeUnit);
                    continue;
                }
                appender.stop();
            }
        }
        LOGGER.trace("{} stopping remaining Appenders.", (Object)cls);
        int appenderCount = 0;
        for (int i = array.length - 1; i >= 0; --i) {
            if (!array[i].isStarted()) continue;
            if (array[i] instanceof LifeCycle2) {
                ((LifeCycle2)((Object)array[i])).stop(timeout, timeUnit);
            } else {
                array[i].stop();
            }
            ++appenderCount;
        }
        LOGGER.trace("{} stopped {} remaining Appenders.", (Object)cls, (Object)appenderCount);
        LOGGER.trace("{} cleaning Appenders from {} LoggerConfigs.", (Object)cls, (Object)(this.loggerConfigs.size() + 1));
        for (Object object : this.loggerConfigs.values()) {
            ((LoggerConfig)object).clearAppenders();
        }
        this.root.clearAppenders();
        if (this.watchManager.isStarted()) {
            ((AbstractLifeCycle)this.watchManager).stop(timeout, timeUnit);
        }
        ((AbstractLifeCycle)this.configurationScheduler).stop((long)var1_1, (TimeUnit)var3_2);
        if (this.advertiser != null && this.advertisement != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        LOGGER.debug("Stopped {} OK", (Object)this);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private List<Appender> getAsyncAppenders(Appender[] all) {
        void var2_2;
        ArrayList<Appender> result = new ArrayList<Appender>();
        for (int i = all.length - 1; i >= 0; --i) {
            if (!(all[i] instanceof AsyncAppender)) continue;
            result.add(all[i]);
        }
        return var2_2;
    }

    @Override
    public boolean isShutdownHookEnabled() {
        return this.isShutdownHookEnabled;
    }

    @Override
    public long getShutdownTimeoutMillis() {
        return this.shutdownTimeoutMillis;
    }

    public void setup() {
    }

    /*
     * WARNING - void declaration
     */
    protected Level getDefaultStatus() {
        String statusLevel = PropertiesUtil.getProperties().getStringProperty("Log4jDefaultStatusLevel", Level.ERROR.name());
        try {
            void var1_1;
            return Level.toLevel((String)var1_1);
        }
        catch (Exception exception) {
            return Level.ERROR;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void createAdvertiser(String advertiserString, ConfigurationSource configSource, byte[] buffer, String contentType) {
        if (advertiserString != null) {
            void var1_1;
            void var3_3;
            Node node = new Node(null, advertiserString, null);
            Map<String, String> attributes = node.getAttributes();
            attributes.put("content", new String((byte[])var3_3));
            attributes.put("contentType", contentType);
            attributes.put("name", "configuration");
            if (configSource.getLocation() != null) {
                void var2_2;
                attributes.put("location", var2_2.getLocation());
            }
            this.advertiserNode = var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setupAdvertisement() {
        String nodeName;
        PluginType<?> type;
        if (this.advertiserNode != null && (type = this.pluginManager.getPluginType(nodeName = this.advertiserNode.getName())) != null) {
            Class<Advertiser> clazz = type.getPluginClass().asSubclass(Advertiser.class);
            try {
                this.advertiser = clazz.newInstance();
                this.advertisement = this.advertiser.advertise(this.advertiserNode.getAttributes());
                return;
            }
            catch (ReflectiveOperationException e) {
                void var2_3;
                void var1_1;
                LOGGER.error("{} attempting to instantiate advertiser: {}", (Object)e.getClass().getSimpleName(), (Object)var1_1, (Object)var2_3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T getComponent(String componentName) {
        void var1_1;
        return (T)this.componentMap.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addComponent(String componentName, Object obj) {
        void var2_2;
        void var1_1;
        this.componentMap.putIfAbsent((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void preConfigure(Node node) {
        try {
            for (Node child : node.getChildren()) {
                void var3_4;
                if (child.getType() == null) {
                    LOGGER.error("Unable to locate plugin type for " + child.getName());
                    continue;
                }
                Class<?> clazz = child.getType().getPluginClass();
                if (clazz.isAnnotationPresent(Scheduled.class)) {
                    this.configurationScheduler.incrementScheduledItems();
                }
                this.preConfigure((Node)var3_4);
            }
            return;
        }
        catch (Exception ex) {
            void var2_3;
            void var1_1;
            LOGGER.error("Error capturing node data for node " + var1_1.getName(), (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void processConditionals(Node node) {
        try {
            ArrayList<Node> addList = new ArrayList<Node>();
            ArrayList<Node> removeList = new ArrayList<Node>();
            for (Node child : node.getChildren()) {
                PluginType<?> type = child.getType();
                if (type != null && "Arbiter".equals(type.getElementName())) {
                    Class<?> clazz = type.getPluginClass();
                    if (SelectArbiter.class.isAssignableFrom(clazz)) {
                        removeList.add(child);
                        addList.addAll(this.processSelect(child, type));
                        continue;
                    }
                    if (Arbiter.class.isAssignableFrom(clazz)) {
                        removeList.add(child);
                        try {
                            Arbiter arbiter = (Arbiter)this.createPluginObject(type, child, null);
                            if (!arbiter.isCondition()) continue;
                            addList.addAll(child.getChildren());
                            this.processConditionals(child);
                        }
                        catch (Exception exception) {
                            LOGGER.error("Exception processing {}: Ignoring and including children", type.getPluginClass());
                            this.processConditionals(child);
                        }
                        continue;
                    }
                    LOGGER.error("Encountered Condition Plugin that does not implement Condition: {}", (Object)child.getName());
                    this.processConditionals(child);
                    continue;
                }
                this.processConditionals(child);
            }
            if (!removeList.isEmpty()) {
                void var3_4;
                List<Node> children = node.getChildren();
                children.removeAll((Collection<?>)var3_4);
                children.addAll(addList);
                for (Node node2 : addList) {
                    node2.setParent(node);
                }
            }
            return;
        }
        catch (Exception ex) {
            void var2_3;
            void var1_1;
            LOGGER.error("Error capturing node data for node " + var1_1.getName(), (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected List<Node> processSelect(Node selectNode, PluginType<?> type) {
        void var3_3;
        void var2_2;
        ArrayList<Node> addList = new ArrayList<Node>();
        SelectArbiter select = (SelectArbiter)this.createPluginObject(type, selectNode, null);
        ArrayList<Arbiter> conditions = new ArrayList<Arbiter>();
        for (Node child : selectNode.getChildren()) {
            PluginType<?> nodeType = child.getType();
            if (nodeType != null) {
                if (Arbiter.class.isAssignableFrom(nodeType.getPluginClass())) {
                    Arbiter condition = (Arbiter)this.createPluginObject(nodeType, child, null);
                    conditions.add(condition);
                    child.setObject(condition);
                    continue;
                }
                LOGGER.error("Invalid Node {} for Select. Must be a Condition", (Object)child.getName());
                continue;
            }
            LOGGER.error("No PluginType for node {}", (Object)child.getName());
        }
        Arbiter condition = var2_2.evaluateConditions(conditions);
        if (condition != null) {
            void var1_1;
            for (Node child : var1_1.getChildren()) {
                if (condition != child.getObject()) continue;
                addList.addAll(child.getChildren());
                this.processConditionals(child);
            }
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected void doConfigure() {
        void var2_4;
        void var1_2;
        StrLookup lookup;
        AbstractConfiguration abstractConfiguration = this;
        abstractConfiguration.processConditionals(abstractConfiguration.rootNode);
        AbstractConfiguration abstractConfiguration2 = this;
        abstractConfiguration2.preConfigure(abstractConfiguration2.rootNode);
        ((AbstractLifeCycle)this.configurationScheduler).start();
        if (this.rootNode.hasChildren() && this.rootNode.getChildren().get(0).getName().equalsIgnoreCase("Properties")) {
            Node first = this.rootNode.getChildren().get(0);
            this.createConfiguration(first, null);
            if (first.getObject() != null) {
                lookup = (StrLookup)first.getObject();
                if (lookup instanceof LoggerContextAware) {
                    ((LoggerContextAware)((Object)lookup)).setLoggerContext((LoggerContext)this.loggerContext.get());
                }
                this.runtimeStrSubstitutor.setVariableResolver(lookup);
                this.configurationStrSubstitutor.setVariableResolver(lookup);
            }
        } else {
            Iterator<Object> iterator;
            Map map = (Map)this.getComponent("ContextProperties");
            lookup = map == null ? null : new PropertiesLookup(map);
            Interpolator interpolator = new Interpolator(lookup, this.pluginPackages);
            interpolator.setLoggerContext((LoggerContext)this.loggerContext.get());
            this.runtimeStrSubstitutor.setVariableResolver(interpolator);
            this.configurationStrSubstitutor.setVariableResolver((StrLookup)((Object)iterator));
        }
        boolean setLoggers = false;
        boolean setRoot = false;
        for (Node object : this.rootNode.getChildren()) {
            if (object.getName().equalsIgnoreCase("Properties")) {
                if (this.tempLookup != this.runtimeStrSubstitutor.getVariableResolver()) continue;
                LOGGER.error("Properties declaration must be the first element in the configuration");
                continue;
            }
            this.createConfiguration(object, null);
            if (object.getObject() == null) continue;
            if (object.getName().equalsIgnoreCase("Scripts")) {
                for (AbstractScript script : object.getObject(AbstractScript[].class)) {
                    if (script instanceof ScriptRef) {
                        LOGGER.error("Script reference to {} not added. Scripts definition cannot contain script references", (Object)script.getName());
                        continue;
                    }
                    if (this.scriptManager == null) continue;
                    this.scriptManager.addScript(script);
                }
                continue;
            }
            if (object.getName().equalsIgnoreCase("Appenders")) {
                this.appenders = (ConcurrentMap)object.getObject();
                continue;
            }
            if (object.isInstanceOf(Filter.class)) {
                this.addFilter(object.getObject(Filter.class));
                continue;
            }
            if (object.getName().equalsIgnoreCase("Loggers")) {
                Loggers l = (Loggers)object.getObject();
                this.loggerConfigs = l.getMap();
                setLoggers = true;
                if (l.getRoot() == null) continue;
                this.root = l.getRoot();
                setRoot = true;
                continue;
            }
            if (object.getName().equalsIgnoreCase("CustomLevels")) {
                this.customLevels = object.getObject(CustomLevels.class).getCustomLevels();
                continue;
            }
            if (object.isInstanceOf(CustomLevelConfig.class)) {
                ArrayList<CustomLevelConfig> copy = new ArrayList<CustomLevelConfig>(this.customLevels);
                copy.add(object.getObject(CustomLevelConfig.class));
                this.customLevels = copy;
                continue;
            }
            if (object.isInstanceOf(AsyncWaitStrategyFactoryConfig.class)) {
                AsyncWaitStrategyFactoryConfig awsfc = object.getObject(AsyncWaitStrategyFactoryConfig.class);
                this.asyncWaitStrategyFactory = awsfc.createWaitStrategyFactory();
                continue;
            }
            List<String> expected = Arrays.asList("\"Appenders\"", "\"Loggers\"", "\"Properties\"", "\"Scripts\"", "\"CustomLevels\"");
            LOGGER.error("Unknown object \"{}\" of type {} is ignored: try nesting it inside one of: {}.", (Object)object.getName(), (Object)object.getObject().getClass().getName(), expected);
        }
        if (var1_2 == false) {
            LOGGER.warn("No Loggers were configured, using default. Is the Loggers element missing?");
            this.setToDefault();
            return;
        }
        if (var2_4 == false) {
            LOGGER.warn("No Root logger was configured, creating default ERROR-level Root logger with Console appender");
            this.setToDefault();
        }
        for (Map.Entry entry : this.loggerConfigs.entrySet()) {
            LoggerConfig loggerConfig = (LoggerConfig)entry.getValue();
            for (AppenderRef ref : loggerConfig.getAppenderRefs()) {
                Appender app = (Appender)this.appenders.get(ref.getRef());
                if (app != null) {
                    loggerConfig.addAppender(app, ref.getLevel(), ref.getFilter());
                    continue;
                }
                LOGGER.error("Unable to locate appender \"{}\" for logger config \"{}\"", (Object)ref.getRef(), (Object)loggerConfig);
            }
        }
        this.setParents();
    }

    public static Level getDefaultLevel() {
        String string = PropertiesUtil.getProperties().getStringProperty("org.apache.logging.log4j.level", Level.ERROR.name());
        return Level.valueOf((String)string);
    }

    /*
     * WARNING - void declaration
     */
    protected void setToDefault() {
        void var2_2;
        this.setName("Default@" + Integer.toHexString(this.hashCode()));
        PatternLayout patternLayout = PatternLayout.newBuilder().withPattern("%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n").withConfiguration(this).build();
        ConsoleAppender appender = ConsoleAppender.createDefaultAppenderForLayout(patternLayout);
        appender.start();
        this.addAppender(appender);
        LoggerConfig rootLoggerConfig = this.getRootLogger();
        rootLoggerConfig.addAppender((Appender)((Object)patternLayout), null, null);
        var2_2.setLevel(AbstractConfiguration.getDefaultLevel());
    }

    /*
     * WARNING - void declaration
     */
    public void setName(String name) {
        void var1_1;
        this.name = var1_1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addListener(ConfigurationListener listener) {
        void var1_1;
        this.listeners.add((ConfigurationListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeListener(ConfigurationListener listener) {
        void var1_1;
        this.listeners.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends Appender> T getAppender(String appenderName) {
        if (appenderName != null) {
            void var1_1;
            return (T)((Appender)this.appenders.get(var1_1));
        }
        return null;
    }

    @Override
    public Map<String, Appender> getAppenders() {
        return this.appenders;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addAppender(Appender appender) {
        if (appender != null) {
            void var1_1;
            this.appenders.putIfAbsent(appender.getName(), (Appender)var1_1);
        }
    }

    @Override
    public StrSubstitutor getStrSubstitutor() {
        return this.runtimeStrSubstitutor;
    }

    @Override
    public StrSubstitutor getConfigurationStrSubstitutor() {
        return this.configurationStrSubstitutor;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAdvertiser(Advertiser advertiser) {
        void var1_1;
        this.advertiser = var1_1;
    }

    @Override
    public Advertiser getAdvertiser() {
        return this.advertiser;
    }

    @Override
    public ReliabilityStrategy getReliabilityStrategy(LoggerConfig loggerConfig) {
        return ReliabilityStrategyFactory.getReliabilityStrategy(loggerConfig);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void addLoggerAppender(Logger logger, Appender appender) {
        void var1_1;
        void var3_3;
        void var2_2;
        if (appender == null || logger == null) {
            return;
        }
        String loggerName = logger.getName();
        this.appenders.putIfAbsent(appender.getName(), appender);
        LoggerConfig lc = this.getLoggerConfig(loggerName);
        if (lc.getName().equals(loggerName)) {
            lc.addAppender(appender, null, null);
            return;
        }
        LoggerConfig nlc = new LoggerConfig(loggerName, lc.getLevel(), lc.isAdditive());
        nlc.addAppender((Appender)var2_2, null, null);
        nlc.setParent(lc);
        this.loggerConfigs.putIfAbsent((String)var3_3, nlc);
        this.setParents();
        var1_1.getContext().updateLoggers();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void addLoggerFilter(Logger logger, Filter filter) {
        void var1_1;
        void var3_3;
        void var2_2;
        String loggerName = logger.getName();
        LoggerConfig lc = this.getLoggerConfig(loggerName);
        if (lc.getName().equals(loggerName)) {
            lc.addFilter(filter);
            return;
        }
        LoggerConfig nlc = new LoggerConfig(loggerName, lc.getLevel(), lc.isAdditive());
        nlc.addFilter((Filter)var2_2);
        nlc.setParent(lc);
        this.loggerConfigs.putIfAbsent((String)var3_3, nlc);
        this.setParents();
        var1_1.getContext().updateLoggers();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setLoggerAdditive(Logger logger, boolean additive) {
        void var1_1;
        void var2_3;
        void var3_4;
        String loggerName = logger.getName();
        LoggerConfig lc = this.getLoggerConfig(loggerName);
        if (lc.getName().equals(loggerName)) {
            lc.setAdditive(additive);
            return;
        }
        LoggerConfig nlc = new LoggerConfig(loggerName, lc.getLevel(), additive);
        nlc.setParent(lc);
        this.loggerConfigs.putIfAbsent((String)var3_4, (LoggerConfig)var2_3);
        this.setParents();
        var1_1.getContext().updateLoggers();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void removeAppender(String appenderName) {
        void var1_1;
        Iterator iterator = this.loggerConfigs.values().iterator();
        while (iterator.hasNext()) {
            LoggerConfig loggerConfig = (LoggerConfig)iterator.next();
            loggerConfig.removeAppender(appenderName);
        }
        Appender app = appenderName != null ? (Appender)this.appenders.remove(var1_1) : null;
        if (app != null) {
            iterator.stop();
        }
    }

    @Override
    public List<CustomLevelConfig> getCustomLevels() {
        return Collections.unmodifiableList(this.customLevels);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerConfig getLoggerConfig(String loggerName) {
        String substr;
        LoggerConfig loggerConfig = (LoggerConfig)this.loggerConfigs.get(loggerName);
        if (loggerConfig != null) {
            return loggerConfig;
        }
        while ((substr = NameUtil.getSubName(substr)) != null) {
            void var2_2;
            loggerConfig = (LoggerConfig)this.loggerConfigs.get(substr);
            if (loggerConfig == null) continue;
            return var2_2;
        }
        return this.root;
    }

    @Override
    public LoggerContext getLoggerContext() {
        return (LoggerContext)this.loggerContext.get();
    }

    @Override
    public LoggerConfig getRootLogger() {
        return this.root;
    }

    @Override
    public Map<String, LoggerConfig> getLoggers() {
        return Collections.unmodifiableMap(this.loggerConfigs);
    }

    /*
     * WARNING - void declaration
     */
    public LoggerConfig getLogger(String loggerName) {
        void var1_1;
        return (LoggerConfig)this.loggerConfigs.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void addLogger(String loggerName, LoggerConfig loggerConfig) {
        void var2_2;
        void var1_1;
        this.loggerConfigs.putIfAbsent((String)var1_1, (LoggerConfig)var2_2);
        this.setParents();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void removeLogger(String loggerName) {
        void var1_1;
        this.loggerConfigs.remove(var1_1);
        this.setParents();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void createConfiguration(Node node, LogEvent event) {
        void var2_2;
        void var1_1;
        void var3_3;
        PluginType<?> type = node.getType();
        if (type == null || !type.isDeferChildren()) {
            for (Node child : node.getChildren()) {
                this.createConfiguration(child, event);
            }
            if (type == null) {
                if (node.getParent() == null) return;
                LOGGER.error("Unable to locate plugin for {}", (Object)node.getName());
                return;
            }
        }
        node.setObject(this.createPluginObject((PluginType<?>)var3_3, (Node)var1_1, (LogEvent)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public Object createPluginObject(PluginType<?> type, Node node) {
        if (this.getState().equals((Object)LifeCycle.State.INITIALIZING)) {
            void var2_2;
            void var1_1;
            return this.createPluginObject((PluginType<?>)var1_1, (Node)var2_2, null);
        }
        LOGGER.warn("Plugin Object creation is not allowed after initialization");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Object createPluginObject(PluginType<?> type, Node node, LogEvent event) {
        void var3_3;
        void var2_2;
        void var1_1;
        Class<?> clazz = type.getPluginClass();
        if (Map.class.isAssignableFrom(clazz)) {
            try {
                return AbstractConfiguration.createPluginMap(node);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to create Map for {} of class {}", (Object)type.getElementName(), clazz, (Object)e);
            }
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            try {
                return AbstractConfiguration.createPluginCollection(node);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to create List for {} of class {}", (Object)type.getElementName(), clazz, (Object)e);
            }
        }
        return new PluginBuilder((PluginType<?>)var1_1).withConfiguration(this).withConfigurationNode((Node)var2_2).forLogEvent((LogEvent)var3_3).build();
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, ?> createPluginMap(Node node) {
        void var1_1;
        Object object;
        LinkedHashMap<String, void> map = new LinkedHashMap<String, void>();
        for (Node child : ((Node)object).getChildren()) {
            void var3_3;
            void var2_2;
            Object object2 = child.getObject();
            map.put(var2_2.getName(), var3_3);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<?> createPluginCollection(Node node) {
        void var1_1;
        Iterator iterator;
        Iterator children = node.getChildren();
        ArrayList<Node> list = new ArrayList<Node>(children.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            Object object = node2.getObject();
            list.add(node2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void setParents() {
        for (Map.Entry entry : this.loggerConfigs.entrySet()) {
            void var3_3;
            LoggerConfig logger = (LoggerConfig)entry.getValue();
            String key = (String)entry.getKey();
            if (key.isEmpty()) continue;
            int i = key.lastIndexOf(46);
            if (i > 0) {
                void var2_2;
                LoggerConfig parent = this.getLoggerConfig(key = key.substring(0, i));
                if (parent == null) {
                    parent = this.root;
                }
                logger.setParent((LoggerConfig)var2_2);
                continue;
            }
            var3_3.setParent(this.root);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static byte[] toByteArray(InputStream is) throws IOException {
        void var1_1;
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            void var2_3;
            buffer.write(data, 0, (int)var2_3);
        }
        return var1_1.toByteArray();
    }

    @Override
    public NanoClock getNanoClock() {
        return this.nanoClock;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setNanoClock(NanoClock nanoClock) {
        void var1_1;
        this.nanoClock = (NanoClock)Objects.requireNonNull(var1_1, "nanoClock");
    }
}

