/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import java.util.concurrent.TimeUnit;

class TimeoutBlockingWaitStrategy
implements WaitStrategy {
    private final Object mutex = new Object();
    private final long timeoutInNanos;
    private static final int ONE_MILLISECOND_IN_NANOSECONDS = 1000000;

    /*
     * WARNING - void declaration
     */
    public TimeoutBlockingWaitStrategy(long timeout, TimeUnit units) {
        void var1_1;
        void var3_2;
        this.timeoutInNanos = var3_2.toNanos((long)var1_1);
    }

    public long waitFor(long sequence, Sequence cursorSequence, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException, TimeoutException {
        long availableSequence;
        long timeoutNanos = this.timeoutInNanos;
        if (cursorSequence.get() < sequence) {
            Object object = this.mutex;
            synchronized (object) {
                while (cursorSequence.get() < sequence) {
                    barrier.checkAlert();
                    if ((timeoutNanos = TimeoutBlockingWaitStrategy.awaitNanos(this.mutex, timeoutNanos)) > 0L) continue;
                    throw TimeoutException.INSTANCE;
                }
            }
        }
        while ((availableSequence = dependentSequence.get()) < sequence) {
            barrier.checkAlert();
        }
        return availableSequence;
    }

    public void signalAllWhenBlocking() {
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notifyAll();
            return;
        }
    }

    public String toString() {
        return "TimeoutBlockingWaitStrategy{mutex=" + this.mutex + ", timeoutInNanos=" + this.timeoutInNanos + '}';
    }

    /*
     * WARNING - void declaration
     */
    private static long awaitNanos(Object mutex, long timeoutNanos) throws InterruptedException {
        void var1_1;
        void var3_2;
        Object object;
        long millis = timeoutNanos / 1000000L;
        long nanos = timeoutNanos % 1000000L;
        long t0 = System.nanoTime();
        object.wait((long)var3_2, (int)nanos);
        long t1 = System.nanoTime();
        return (long)(var1_1 - (t1 - t0));
    }
}

