/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.PropertiesUtil;

public enum ThreadNameCachingStrategy {
    CACHED{

        /*
         * WARNING - void declaration
         */
        @Override
        public final String getThreadName() {
            void var1_1;
            String result = (String)THREADLOCAL_NAME.get();
            if (result == null) {
                result = Thread.currentThread().getName();
                THREADLOCAL_NAME.set(result);
            }
            return var1_1;
        }
    }
    ,
    UNCACHED{

        @Override
        public final String getThreadName() {
            return Thread.currentThread().getName();
        }
    };

    private static final StatusLogger LOGGER;
    private static final ThreadLocal<String> THREADLOCAL_NAME;
    static final ThreadNameCachingStrategy DEFAULT_STRATEGY;

    abstract String getThreadName();

    /*
     * WARNING - void declaration
     */
    public static ThreadNameCachingStrategy create() {
        String name = PropertiesUtil.getProperties().getStringProperty("AsyncLogger.ThreadNameStrategy");
        try {
            ThreadNameCachingStrategy result = name != null ? ThreadNameCachingStrategy.valueOf(name) : DEFAULT_STRATEGY;
            LOGGER.debug("AsyncLogger.ThreadNameStrategy={} (user specified {}, default is {})", (Object)result.name(), (Object)name, (Object)DEFAULT_STRATEGY.name());
            return result;
        }
        catch (Exception ex) {
            void var1_2;
            void var0;
            LOGGER.debug("Using AsyncLogger.ThreadNameStrategy.{}: '{}' not valid: {}", (Object)DEFAULT_STRATEGY.name(), (Object)var0, (Object)var1_2.toString());
            return DEFAULT_STRATEGY;
        }
    }

    static boolean isAllocatingThreadGetName() {
        if (Constants.JAVA_MAJOR_VERSION == 8) {
            try {
                Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)_(\\d+)");
                Matcher m = pattern.matcher(System.getProperty("java.version"));
                if (m.matches()) {
                    return Integers.parseInt(m.group(3)) == 0 && Integers.parseInt(((Matcher)((Object)pattern)).group(4)) < 102;
                }
                return true;
            }
            catch (Exception exception) {
                return true;
            }
        }
        return Constants.JAVA_MAJOR_VERSION < 8;
    }

    static {
        LOGGER = StatusLogger.getLogger();
        THREADLOCAL_NAME = new ThreadLocal();
        DEFAULT_STRATEGY = ThreadNameCachingStrategy.isAllocatingThreadGetName() ? CACHED : UNCACHED;
    }
}

