/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.apache.logging.log4j.core.async.BlockingQueueFactory;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.jctools.queues.MpscArrayQueue;

@Plugin(name="JCToolsBlockingQueue", category="Core", elementType="BlockingQueueFactory")
public class JCToolsBlockingQueueFactory<E>
implements BlockingQueueFactory<E> {
    private final WaitStrategy waitStrategy;

    /*
     * WARNING - void declaration
     */
    private JCToolsBlockingQueueFactory(WaitStrategy waitStrategy) {
        void var1_1;
        this.waitStrategy = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public BlockingQueue<E> create(int capacity) {
        void var1_1;
        return new MpscBlockingQueue((int)var1_1, this.waitStrategy);
    }

    @PluginFactory
    public static <E> JCToolsBlockingQueueFactory<E> createFactory(@PluginAttribute(value="WaitStrategy", defaultString="PARK") WaitStrategy waitStrategy) {
        WaitStrategy waitStrategy2;
        return new JCToolsBlockingQueueFactory<E>(waitStrategy2);
    }

    private static interface Idle {
        public int idle(int var1);
    }

    public static enum WaitStrategy {
        SPIN(idleCounter -> idleCounter + 1),
        YIELD(idleCounter -> {
            int n;
            Thread.yield();
            return n + 1;
        }),
        PARK(idleCounter -> {
            int n;
            LockSupport.parkNanos(1L);
            return n + 1;
        }),
        PROGRESSIVE(idleCounter -> {
            int n;
            if (idleCounter > 200) {
                LockSupport.parkNanos(1L);
            } else if (idleCounter > 100) {
                Thread.yield();
            }
            return n + 1;
        });

        private final Idle idle;

        /*
         * WARNING - void declaration
         */
        private int idle(int idleCounter) {
            void var1_1;
            return this.idle.idle((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private WaitStrategy(Idle idle) {
            void var3_3;
            this.idle = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$000(WaitStrategy x0, int x1) {
            void var1_1;
            return x0.idle((int)var1_1);
        }
    }

    private static final class MpscBlockingQueue<E>
    extends MpscArrayQueue<E>
    implements BlockingQueue<E> {
        private final WaitStrategy waitStrategy;

        /*
         * WARNING - void declaration
         */
        MpscBlockingQueue(int capacity, WaitStrategy waitStrategy) {
            super((int)var1_1);
            void var2_2;
            void var1_1;
            this.waitStrategy = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int drainTo(Collection<? super E> c) {
            void var1_1;
            return this.drainTo((Collection<? super E>)var1_1, this.capacity());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int drainTo(Collection<? super E> c, int maxElements) {
            void var2_2;
            void var1_1;
            return this.drain(arg_0 -> MpscBlockingQueue.lambda$drainTo$0((Collection)var1_1, arg_0), (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
            void var2_2;
            int idleCounter = 0;
            long timeoutNanos = System.nanoTime() + unit.toNanos((long)var2_2);
            do {
                if (this.offer(e)) {
                    return true;
                }
                if (System.nanoTime() - timeoutNanos > 0L) {
                    return false;
                }
                idleCounter = WaitStrategy.access$000(this.waitStrategy, idleCounter);
            } while (!Thread.interrupted());
            throw new InterruptedException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final E poll(long timeout, TimeUnit unit) throws InterruptedException {
            void var3_3;
            int idleCounter = 0;
            long timeoutNanos = System.nanoTime() + var3_3.toNanos(timeout);
            do {
                Object result;
                if ((result = this.poll()) != null) {
                    void var1_2;
                    return var1_2;
                }
                if (System.nanoTime() - timeoutNanos > 0L) {
                    return null;
                }
                idleCounter = WaitStrategy.access$000(this.waitStrategy, idleCounter);
            } while (!Thread.interrupted());
            throw new InterruptedException();
        }

        @Override
        public final void put(E e) throws InterruptedException {
            int idleCounter = 0;
            do {
                if (this.offer(e)) {
                    return;
                }
                idleCounter = WaitStrategy.access$000(this.waitStrategy, idleCounter);
            } while (!Thread.interrupted());
            throw new InterruptedException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean offer(E e) {
            void var1_1;
            return this.offerIfBelowThreshold(var1_1, this.capacity() - 32);
        }

        @Override
        public final int remainingCapacity() {
            return this.capacity() - this.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final E take() throws InterruptedException {
            int idleCounter = 100;
            do {
                Object result;
                if ((result = this.relaxedPoll()) != null) {
                    void var2_2;
                    return var2_2;
                }
                idleCounter = WaitStrategy.access$000(this.waitStrategy, idleCounter);
            } while (!Thread.interrupted());
            throw new InterruptedException();
        }

        /*
         * WARNING - void declaration
         */
        private static /* synthetic */ void lambda$drainTo$0(Collection c, Object e) {
            void var1_1;
            c.add(var1_1);
        }
    }
}

